/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.tests.model;

import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.util.URIResolver;
import org.eclipse.wst.sse.core.internal.util.URIResolverExtension;

public class ModelTest
extends TestCase {
    public void testNewModelURIResolver() throws IOException {
        IStructuredModel model = StructuredModelManager.getModelManager().createUnManagedStructuredModelFor("org.eclipse.core.runtime.xml");
        model.setResolver((URIResolver)new DummyResolver());
        IStructuredModel newModel = StructuredModelManager.getModelManager().createNewInstance(model);
        ModelTest.assertNotSame((String)"Model URI Resolvers should be different.", (Object)model.getResolver(), (Object)newModel.getResolver());
    }

    public void testOKtoReleaseUnmanagedRead() {
        IStructuredModel model = null;
        try {
            model = StructuredModelManager.getModelManager().createUnManagedStructuredModelFor("org.eclipse.core.runtime.xml");
            model.getStructuredDocument().set(this.getName());
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    public void testOKtoReleaseUnmanagedEdit() {
        IStructuredModel model = null;
        try {
            model = StructuredModelManager.getModelManager().createUnManagedStructuredModelFor("org.eclipse.core.runtime.xml");
            model.getStructuredDocument().set(this.getName());
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    private class DummyResolver
    implements URIResolver,
    URIResolverExtension {
        private DummyResolver() {
        }

        public URIResolver newInstance() {
            return new DummyResolver();
        }

        public String getFileBaseLocation() {
            return null;
        }

        public String getLocationByURI(String uri) {
            return null;
        }

        public String getLocationByURI(String uri, boolean resolveCrossProjectLinks) {
            return null;
        }

        public String getLocationByURI(String uri, String baseReference) {
            return null;
        }

        public String getLocationByURI(String uri, String baseReference, boolean resolveCrossProjectLinks) {
            return null;
        }

        public IProject getProject() {
            return null;
        }

        public IContainer getRootLocation() {
            return null;
        }

        public InputStream getURIStream(String uri) {
            return null;
        }

        public void setFileBaseLocation(String newLocation) {
        }

        public void setProject(IProject newProject) {
        }
    }
}

