/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.tests.extensions;

import junit.framework.TestCase;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.wst.xsl.ui.internal.contentassist.ContentAssistProcessorFactory;

public class TestContentAssistProcessorFactory
extends TestCase {
    private static final String XML_CONTENT_ASSIST_PROCESSOR = "org.eclipse.wst.xml.ui.internal.contentassist.XMLContentAssistProcessor";
    private static final String XSL_CONTENT_ASSIST_PROCESSOR = "org.eclipse.wst.xsl.ui.internal.contentassist.XSLContentAssistProcessor";

    public void testContentAssistProcessorsExist() {
        IContentAssistProcessor[] processors = ContentAssistProcessorFactory.createProcessors();
        TestContentAssistProcessorFactory.assertNotNull((Object)processors);
    }

    public void testXMLContentAssistProcessorExists() {
        IContentAssistProcessor[] processors = ContentAssistProcessorFactory.createProcessors();
        if (processors == null) {
            TestContentAssistProcessorFactory.fail((String)"Missing Content Assist Processors.");
        }
        TestContentAssistProcessorFactory.assertTrue((String)"Did not find XML Content Assist Processor", (boolean)this.findProcessor(processors, XML_CONTENT_ASSIST_PROCESSOR));
    }

    public void testXSLContentAssistProcessorExists() {
        IContentAssistProcessor[] processors = ContentAssistProcessorFactory.createProcessors();
        if (processors == null) {
            TestContentAssistProcessorFactory.fail((String)"Missing Content Assist Processors.");
        }
        TestContentAssistProcessorFactory.assertTrue((String)"Did not find XSL Content Assist Processor", (boolean)this.findProcessor(processors, XSL_CONTENT_ASSIST_PROCESSOR));
    }

    private boolean findProcessor(IContentAssistProcessor[] processors, String name) {
        boolean fndsw = false;
        IContentAssistProcessor[] iContentAssistProcessorArray = processors;
        int n = processors.length;
        int n2 = 0;
        while (n2 < n) {
            IContentAssistProcessor processor = iContentAssistProcessorArray[n2];
            if (processor.getClass().getName().equals(name)) {
                fndsw = true;
            }
            ++n2;
        }
        return fndsw;
    }
}

