/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.tests.contentassist;

import java.io.File;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.sse.ui.internal.contentassist.CustomCompletionProposal;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xsl.ui.tests.AbstractSourceViewerTest;
import org.junit.Assert;
import org.junit.Test;

public class XSLCompletionTest
extends AbstractSourceViewerTest {
    @Test
    public void testGetNodeAtLine10() throws Exception {
        this.fileName = "utils.xsl";
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        IDOMNode node = (IDOMNode)ContentAssistUtils.getNodeAt((ITextViewer)this.sourceViewer, (int)(this.sourceViewer.getDocument().getLineOffset(9) + 1));
        Assert.assertEquals((String)"Wrong node name returned:", (Object)"xsl:stylesheet", (Object)node.getNodeName());
    }

    @Test
    public void testGetNodeAtLine12() throws Exception {
        this.fileName = "utils.xsl";
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        IDOMNode node = (IDOMNode)ContentAssistUtils.getNodeAt((ITextViewer)this.sourceViewer, (int)(this.sourceViewer.getDocument().getLineOffset(11) + 11));
        Assert.assertEquals((String)"Wrong node name returned:", (Object)"xsl:template", (Object)node.getNodeName());
    }

    @Test
    public void testGetNodeAtLine13() throws Exception {
        this.fileName = "utils.xsl";
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        IDOMNode node = (IDOMNode)ContentAssistUtils.getNodeAt((ITextViewer)this.sourceViewer, (int)(this.sourceViewer.getDocument().getLineOffset(12) + 14));
        Assert.assertEquals((String)"Wrong node name returned:", (Object)"xsl:param", (Object)node.getNodeName());
    }

    @Test
    public void testAttributeNotValueAvailable() throws Exception {
        this.fileName = "utils.xsl";
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        ICompletionProposal[] proposals = this.getProposals(14, 42);
        Assert.assertTrue((proposals.length > 1 ? 1 : 0) != 0);
        ICompletionProposal proposal = proposals[0];
        Assert.assertFalse((String)"Found \"number(substring($date, 6, 2))\".", (boolean)proposal.getDisplayString().equals("\"number(substring($date, 6, 2))\""));
    }

    @Test
    public void testSelectAttributeProposalsAvailable() throws Exception {
        this.fileName = "utils.xsl";
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        int offset = this.sourceViewer.getDocument().getLineOffset(14) + 42;
        String s = this.sourceViewer.getDocument().get(offset - 1, 6);
        Assert.assertEquals((Object)"number", (Object)s);
        ICompletionProposal[] proposals = this.getProposals(14, 41);
        Assert.assertTrue((proposals.length > 1 ? 1 : 0) != 0);
        ICompletionProposal proposal = proposals[3];
        Assert.assertEquals((String)"Wrong select item returned: ", (Object)"..", (Object)proposal.getDisplayString());
    }

    @Test
    public void testSelectAttributeProposalsNarrow() throws Exception {
        this.fileName = "utils.xsl";
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        Thread.sleep(6000L);
        int offset = this.sourceViewer.getDocument().getLineOffset(14) + 42;
        String s = this.sourceViewer.getDocument().get(offset - 9, 9);
        Assert.assertEquals((Object)"select=\"n", (Object)s);
        ICompletionProposal[] proposals = this.getProposals(offset);
        Assert.assertEquals((String)"Wrong xpath item returned: ", (Object)"name(node-set)", (Object)proposals[0].getDisplayString());
        Assert.assertEquals((String)"Wrong Number of items returned: ", (long)6L, (long)proposals.length);
    }

    @Test
    public void testTestAttributeProposalsAvailable() throws Exception {
        this.fileName = "simple.xsl";
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        ICompletionProposal[] proposals = this.getXMLProposals(4, 30);
        Assert.assertTrue((proposals.length >= 1 ? 1 : 0) != 0);
        int i = 0;
        while (i < proposals.length) {
            ICompletionProposal proposal = proposals[i];
            if (proposal.getDisplayString().contains("disable-output-escaping")) {
                return;
            }
            ++i;
        }
        Assert.fail((String)"Did not find disable-output-escaping=\"no\"");
    }

    @Test
    public void testXSLElementProposalsAvailable() throws Exception {
        this.fileName = "utils.xsl";
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        ICompletionProposal[] proposals = this.getXMLProposals(51, 20);
        Assert.assertTrue((proposals.length >= 2 ? 1 : 0) != 0);
        ICompletionProposal proposal = proposals[1];
        Assert.assertTrue((String)"Can't find XSL element proposals.", (boolean)proposal.getDisplayString().equals("xsl:otherwise"));
    }

    @Test
    public void testXPathProposalAvaialbleAfterComma() throws Exception {
        this.fileName = "utils.xsl";
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        ICompletionProposal[] proposals = this.getProposals(861);
        Assert.assertTrue((proposals.length > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testVariableInsertPositionOffset() throws Exception {
        this.fileName = "bug281420.xsl";
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        ICompletionProposal[] proposals = this.getProposals(7, 29);
        Assert.assertTrue((String)"Did not find any proposals.", (proposals.length > 0 ? 1 : 0) != 0);
        CustomCompletionProposal testprop = null;
        int cnt = 0;
        while (cnt < proposals.length) {
            if (proposals[cnt].getDisplayString().equals("$test")) {
                testprop = (CustomCompletionProposal)proposals[cnt];
            }
            ++cnt;
        }
        if (testprop == null) {
            Assert.fail((String)"Didn't find the $test proposal");
        }
        int startoffset = this.calculateOffset(7, 28);
        if (testprop.getReplacementOffset() != startoffset) {
            Assert.fail((String)("Replacement Offset position worng expected " + startoffset + "but received " + testprop.getReplacementOffset()));
        }
    }
}

