/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.core.document;

import org.eclipse.wst.json.core.TestUtil;
import org.eclipse.wst.json.core.document.IJSONDocument;
import org.eclipse.wst.json.core.document.IJSONModel;
import org.eclipse.wst.json.core.document.IJSONObject;
import org.eclipse.wst.json.core.document.IJSONPair;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.junit.Assert;
import org.junit.Test;

public class JSONObjectCreationTest {
    @Test
    public void createEmptyObjectNotClosed() throws Exception {
        IJSONModel model = (IJSONModel)TestUtil.createModel();
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        IJSONDocument document = model.getDocument();
        Assert.assertNull((Object)document.getFirstChild());
        structuredDocument.set("{");
        Assert.assertNotNull((Object)document.getFirstChild());
        Assert.assertTrue((boolean)(document.getFirstChild() instanceof IJSONObject));
        IJSONObject object = (IJSONObject)document.getFirstChild();
        Assert.assertFalse((boolean)object.isClosed());
    }

    @Test
    public void createEmptyObject() throws Exception {
        IJSONModel model = (IJSONModel)TestUtil.createModel();
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        IJSONDocument document = model.getDocument();
        Assert.assertNull((Object)document.getFirstChild());
        structuredDocument.set("{}");
        Assert.assertNotNull((Object)document.getFirstChild());
        Assert.assertTrue((boolean)(document.getFirstChild() instanceof IJSONObject));
        IJSONObject object = (IJSONObject)document.getFirstChild();
        Assert.assertTrue((boolean)object.isClosed());
    }

    @Test
    public void createObjectWithObjectValue() throws Exception {
        IJSONModel model = (IJSONModel)TestUtil.createModel();
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        IJSONDocument document = model.getDocument();
        Assert.assertNull((Object)document.getFirstChild());
        structuredDocument.set("{\"object\": {}}");
        Assert.assertNotNull((Object)document.getFirstChild());
        Assert.assertTrue((boolean)(document.getFirstChild() instanceof IJSONObject));
        IJSONObject rootObject = (IJSONObject)document.getFirstChild();
        Assert.assertTrue((boolean)rootObject.isClosed());
        Assert.assertNotNull((Object)rootObject.getFirstChild());
        Assert.assertTrue((boolean)(rootObject.getFirstChild() instanceof IJSONPair));
    }

    @Test
    public void createComplexObject() throws Exception {
        IJSONModel model = (IJSONModel)TestUtil.createModel();
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        IJSONDocument document = model.getDocument();
        Assert.assertNull((Object)document.getFirstChild());
        structuredDocument.set("{\n\t\"aaaaa\": {},\n\t\"array\": [\n\t\t1,\n\t\t2,\n\t\t3],\n\t\"boolean\": true,\n\t\"null\": null,\n\t\"number\": 123,\n\t\"object\": {\n\t\t\"a\": \"b\",\n\t\t\"c\": \"d\"\n\t},\n\t\"string\": \"Hello World\"\n}");
        Assert.assertNotNull((Object)document.getFirstChild());
        Assert.assertTrue((boolean)(document.getFirstChild() instanceof IJSONObject));
    }
}

