/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.core.internal.validation;

import junit.framework.TestCase;
import org.eclipse.wst.xsd.core.internal.validation.XSDValidationConfiguration;

public class XSDValidationConfigurationTest
extends TestCase {
    XSDValidationConfiguration configuration;

    protected void setUp() throws Exception {
        super.setUp();
        this.configuration = new XSDValidationConfiguration();
    }

    protected void tearDown() throws Exception {
        this.configuration = null;
        super.tearDown();
    }

    public void testSetHonourAllSchemaLocationsFeatureDefault() {
        try {
            XSDValidationConfigurationTest.assertFalse((String)"The HONOUR_ALL_SCHEMA_LOCATIONS feature is not set by default to false.", (boolean)this.configuration.getFeature(XSDValidationConfiguration.HONOUR_ALL_SCHEMA_LOCATIONS));
        }
        catch (Exception e) {
            XSDValidationConfigurationTest.fail((String)("Unable to set read the HONOUR_ALL_SCHEMA_LOCATIONS feature: " + e));
        }
    }

    public void testSetHonourAllSchemaLocationsFeatureTrue() {
        try {
            this.configuration.setFeature(XSDValidationConfiguration.HONOUR_ALL_SCHEMA_LOCATIONS, true);
            XSDValidationConfigurationTest.assertTrue((String)"The HONOUR_ALL_SCHEMA_LOCATIONS feature is not set to true.", (boolean)this.configuration.getFeature(XSDValidationConfiguration.HONOUR_ALL_SCHEMA_LOCATIONS));
        }
        catch (Exception e) {
            XSDValidationConfigurationTest.fail((String)("Unable to set HONOUR_ALL_SCHEMA_LOCATIONS to true: " + e));
        }
    }

    public void testSetHonourAllSchemaLocationsFeatureFalse() {
        try {
            this.configuration.setFeature(XSDValidationConfiguration.HONOUR_ALL_SCHEMA_LOCATIONS, false);
            XSDValidationConfigurationTest.assertFalse((String)"The HONOUR_ALL_SCHEMA_LOCATIONS feature is not set to false.", (boolean)this.configuration.getFeature(XSDValidationConfiguration.HONOUR_ALL_SCHEMA_LOCATIONS));
        }
        catch (Exception e) {
            XSDValidationConfigurationTest.fail((String)("Unable to set HONOUR_ALL_SCHEMA_LOCATIONS to false: " + e));
        }
    }

    public void testSetNotExistantFeature() {
        try {
            this.configuration.setFeature("NON_EXISTANT_FEATURE", false);
            XSDValidationConfigurationTest.fail((String)"Setting a non existant feature did not produce an exception.");
        }
        catch (Exception exception) {}
    }

    public void testGetNotExistantFeature() {
        try {
            this.configuration.getFeature("NON_EXISTANT_FEATURE");
            XSDValidationConfigurationTest.fail((String)"Getting a non existant feature did not produce an exception.");
        }
        catch (Exception exception) {}
    }
}

