/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.tests.write;

import java.util.List;
import org.eclipse.jst.jsf.facesconfig.emf.DynamicElement;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.ValidatorExtensionType;
import org.eclipse.jst.jsf.facesconfig.emf.ValidatorType;
import org.eclipse.jst.jsf.facesconfig.tests.util.CommonStructuresUtil;
import org.eclipse.jst.jsf.facesconfig.tests.util.FacesConfigModelUtil;
import org.eclipse.jst.jsf.facesconfig.tests.write.WriteValidatorTestCase;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;

public class WriteValidatorTestCase_1_2
extends WriteValidatorTestCase {
    private static final String EXTENDED_VALIDATOR_ID = "extended-validator-id";
    private static final String VALIDATOR_EXTENSION = CommonStructuresUtil.createPreficedString("validator", "extension");
    private static final String VALIDATOR_EXTENSION_ID = CommonStructuresUtil.createPreficedString(VALIDATOR_EXTENSION, "id");
    private static final String VALIDATOR_EXTENSION_TAG = CommonStructuresUtil.createPreficedString(VALIDATOR_EXTENSION, "tag");

    public WriteValidatorTestCase_1_2(String name) {
        super(name);
    }

    public void testValidatorExtension() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForWrite();
            WriteValidatorTestCase_1_2.assertNotNull((Object)edit.getFacesConfig());
            FacesConfigPackage facesConfigPackage = FacesConfigPackage.eINSTANCE;
            FacesConfigFactory facesConfigFactory = facesConfigPackage.getFacesConfigFactory();
            ValidatorType validator = facesConfigFactory.createValidatorType();
            validator.setId(EXTENDED_VALIDATOR_ID);
            ValidatorExtensionType extensionType = facesConfigFactory.createValidatorExtensionType();
            extensionType.setId(VALIDATOR_EXTENSION_ID);
            extensionType.getChildNodes().add((Object)this.createDynamicElement(VALIDATOR_EXTENSION_TAG));
            validator.getValidatorExtension().add((Object)extensionType);
            edit.getFacesConfig().getValidator().add((Object)validator);
            edit.save(null);
        }
        finally {
            if (edit != null) {
                edit.dispose();
                WriteValidatorTestCase_1_2.assertTrue((boolean)edit.isDisposed());
                edit = null;
            }
        }
        try {
            edit = this.getArtifactEditForRead();
            WriteValidatorTestCase_1_2.assertNotNull((Object)edit.getFacesConfig());
            ValidatorType validator = (ValidatorType)FacesConfigModelUtil.findEObjectElementById((List)edit.getFacesConfig().getValidator(), EXTENDED_VALIDATOR_ID);
            WriteValidatorTestCase_1_2.assertNotNull((Object)validator);
            WriteValidatorTestCase_1_2.assertEquals((int)1, (int)validator.getValidatorExtension().size());
            ValidatorExtensionType extensionType = (ValidatorExtensionType)validator.getValidatorExtension().get(0);
            WriteValidatorTestCase_1_2.assertEquals((String)VALIDATOR_EXTENSION_ID, (String)extensionType.getId());
            WriteValidatorTestCase_1_2.assertEquals((int)1, (int)extensionType.getChildNodes().size());
            DynamicElement element = (DynamicElement)extensionType.getChildNodes().get(0);
            WriteValidatorTestCase_1_2.assertEquals((String)VALIDATOR_EXTENSION_TAG, (String)element.getName());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }
}

