/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import java.util.Hashtable;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.CorrectionEngine;
import org.eclipse.wst.jsdt.core.ICorrectionRequestor;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.TypeNameRequestor;
import org.eclipse.wst.jsdt.core.tests.model.AbstractJavaModelTests;
import org.eclipse.wst.jsdt.core.tests.model.CodeCorrectionTestsRequestor;

public class CodeCorrectionTests
extends AbstractJavaModelTests {
    public static boolean fgDebug = false;
    public static boolean fgSpecific = false;

    public CodeCorrectionTests(String name) {
        super(name);
    }

    private IMarker[] getMarkers(IJavaScriptUnit unit) {
        try {
            IResource resource = unit.getCorrespondingResource();
            return resource.findMarkers("org.eclipse.wst.jsdt.core.problem", true, 2);
        }
        catch (CoreException coreException) {
            return new IMarker[0];
        }
    }

    private IMarker getMarker(IJavaScriptUnit unit, String message) throws CoreException {
        IMarker[] markers = this.getMarkers(unit);
        int i = 0;
        while (i < markers.length) {
            IMarker marker = markers[i];
            if (message.equals(marker.getAttribute("message"))) {
                return marker;
            }
            ++i;
        }
        return null;
    }

    public static String[] getProjectNames() {
        return new String[]{"Compiler", "CodeCorrection"};
    }

    @Override
    public void setUpSuite() throws Exception {
        super.setUpSuite();
        IJavaScriptProject project = this.setUpJavaProject("CodeCorrection");
        SearchEngine engine = new SearchEngine();
        IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
        try {
            engine.searchAllTypeNames(null, 0, "!@$#!@".toCharArray(), 10, 5, scope, new TypeNameRequestor(){

                public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                }
            }, 3, null);
        }
        catch (CoreException coreException) {}
        JavaScriptCore.setOptions((Hashtable)JavaScriptCore.getDefaultOptions());
        try {
            this.getWorkspace().getRoot().getProject("CodeCorrection").build(6, null);
            CodeCorrectionTests.waitForAutoBuild();
        }
        catch (CoreException coreException) {
            CodeCorrectionTests.assertTrue((String)"building failed", (boolean)false);
        }
    }

    @Override
    public void tearDownSuite() throws Exception {
        this.deleteProject("CodeCorrection");
        super.tearDownSuite();
    }

    public static Test suite() {
        return CodeCorrectionTests.buildModelTestSuite(CodeCorrectionTests.class);
    }

    public void testCorrectFieldType1() throws JavaScriptModelException {
        CorrectionEngine engine = new CorrectionEngine((Map)JavaScriptCore.getOptions());
        CodeCorrectionTestsRequestor requestor = new CodeCorrectionTestsRequestor();
        IJavaScriptUnit cu = this.getCompilationUnit("CodeCorrection", "src", "", "CorrectFieldType1.js");
        IMarker[] markers = this.getMarkers(cu);
        CodeCorrectionTests.assertTrue((String)"should have one problem", (markers.length == 1 ? 1 : 0) != 0);
        engine.computeCorrections(markers[0], null, 0, (ICorrectionRequestor)requestor);
        String src = cu.getSource();
        String error = "dddz";
        int start = src.indexOf(error);
        int end = start + error.length();
        CodeCorrectionTests.assertEquals((String)"should have two suggestions", (String)"ddd\nddd.eee", (String)requestor.getSuggestions());
        CodeCorrectionTests.assertEquals((String)"a start of a suggestion is not correct", (String)(String.valueOf(start) + "\n" + start), (String)requestor.getStarts());
        CodeCorrectionTests.assertEquals((String)"a end of a suggestion is not correct", (String)(String.valueOf(end) + "\n" + end), (String)requestor.getEnds());
    }

    public void testCorrectFieldType2() throws JavaScriptModelException {
        CorrectionEngine engine = new CorrectionEngine((Map)JavaScriptCore.getOptions());
        CodeCorrectionTestsRequestor requestor = new CodeCorrectionTestsRequestor();
        IJavaScriptUnit cu = this.getCompilationUnit("CodeCorrection", "src", "", "CorrectFieldType2.js");
        IMarker[] markers = this.getMarkers(cu);
        CodeCorrectionTests.assertTrue((String)"should have one problem", (markers.length == 1 ? 1 : 0) != 0);
        engine.computeCorrections(markers[0], null, 0, (ICorrectionRequestor)requestor);
        String src = cu.getSource();
        String error = "AClassz";
        int start = src.indexOf(error);
        int end = start + error.length();
        CodeCorrectionTests.assertEquals((String)"should have two suggestions", (String)"AClass\nAClass2", (String)requestor.getSuggestions());
        CodeCorrectionTests.assertEquals((String)"a start of a suggestion is not correct", (String)(String.valueOf(start) + "\n" + start), (String)requestor.getStarts());
        CodeCorrectionTests.assertEquals((String)"a end of a suggestion is not correct", (String)(String.valueOf(end) + "\n" + end), (String)requestor.getEnds());
    }

    public void testCorrectFieldType3() throws CoreException {
        CorrectionEngine engine = new CorrectionEngine((Map)JavaScriptCore.getOptions());
        CodeCorrectionTestsRequestor requestor = new CodeCorrectionTestsRequestor();
        IJavaScriptUnit cu = this.getCompilationUnit("CodeCorrection", "src", "", "CorrectFieldType3.js");
        IMarker marker = this.getMarker(cu, "AClassz cannot be resolved to a type");
        CodeCorrectionTests.assertTrue((String)"Marker not found", (marker != null ? 1 : 0) != 0);
        try {
            engine.computeCorrections(marker, null, 0, (ICorrectionRequestor)requestor);
        }
        catch (CoreException coreException) {}
        String src = cu.getSource();
        String error = "AClassz";
        int start = src.indexOf(error);
        int end = start + error.length();
        CodeCorrectionTests.assertEquals((String)"should have two suggestions", (String)"AClass\nAClass2", (String)requestor.getSuggestions());
        CodeCorrectionTests.assertEquals((String)"a start of a suggestion is not correct", (String)(String.valueOf(start) + "\n" + start), (String)requestor.getStarts());
        CodeCorrectionTests.assertEquals((String)"a end of a suggestion is not correct", (String)(String.valueOf(end) + "\n" + end), (String)requestor.getEnds());
    }

    public void testCorrectLocalVariableType1() throws JavaScriptModelException {
        CorrectionEngine engine = new CorrectionEngine((Map)JavaScriptCore.getOptions());
        CodeCorrectionTestsRequestor requestor = new CodeCorrectionTestsRequestor();
        IJavaScriptUnit cu = this.getCompilationUnit("CodeCorrection", "src", "", "CorrectLocalVariableType1.js");
        IMarker[] markers = this.getMarkers(cu);
        CodeCorrectionTests.assertTrue((String)"should have one problem", (markers.length == 1 ? 1 : 0) != 0);
        engine.computeCorrections(markers[0], null, 0, (ICorrectionRequestor)requestor);
        String src = cu.getSource();
        String error = "dddz";
        int start = src.indexOf(error);
        int end = start + error.length();
        CodeCorrectionTests.assertEquals((String)"should have two suggestions", (String)"ddd\nddd.eee", (String)requestor.getSuggestions());
        CodeCorrectionTests.assertEquals((String)"a start of a suggestion is not correct", (String)(String.valueOf(start) + "\n" + start), (String)requestor.getStarts());
        CodeCorrectionTests.assertEquals((String)"a end of a suggestion is not correct", (String)(String.valueOf(end) + "\n" + end), (String)requestor.getEnds());
    }

    public void testCorrectLocalVariableType2() throws JavaScriptModelException {
        CorrectionEngine engine = new CorrectionEngine((Map)JavaScriptCore.getOptions());
        CodeCorrectionTestsRequestor requestor = new CodeCorrectionTestsRequestor();
        IJavaScriptUnit cu = this.getCompilationUnit("CodeCorrection", "src", "", "CorrectLocalVariableType2.js");
        IMarker[] markers = this.getMarkers(cu);
        CodeCorrectionTests.assertTrue((String)"should have one problem", (markers.length == 1 ? 1 : 0) != 0);
        engine.computeCorrections(markers[0], null, 0, (ICorrectionRequestor)requestor);
        String src = cu.getSource();
        String error = "AClassz";
        int start = src.indexOf(error);
        int end = start + error.length();
        CodeCorrectionTests.assertEquals((String)"should have two suggestions", (String)"AClass\nAClass2", (String)requestor.getSuggestions());
        CodeCorrectionTests.assertEquals((String)"a start of a suggestion is not correct", (String)(String.valueOf(start) + "\n" + start), (String)requestor.getStarts());
        CodeCorrectionTests.assertEquals((String)"a end of a suggestion is not correct", (String)(String.valueOf(end) + "\n" + end), (String)requestor.getEnds());
    }

    public void testCorrectImport1() throws JavaScriptModelException {
        CorrectionEngine engine = new CorrectionEngine((Map)JavaScriptCore.getOptions());
        CodeCorrectionTestsRequestor requestor = new CodeCorrectionTestsRequestor();
        IJavaScriptUnit cu = this.getCompilationUnit("CodeCorrection", "src", "", "CorrectImport1.js");
        IMarker[] markers = this.getMarkers(cu);
        CodeCorrectionTests.assertTrue((String)"should have one problem", (markers.length == 1 ? 1 : 0) != 0);
        engine.computeCorrections(markers[0], null, 0, (ICorrectionRequestor)requestor);
        String src = cu.getSource();
        String error = "dddz";
        int start = src.indexOf(error);
        int end = start + error.length();
        CodeCorrectionTests.assertEquals((String)"should have two suggestions", (String)"ddd\nddd.eee", (String)requestor.getSuggestions());
        CodeCorrectionTests.assertEquals((String)"a start of a suggestion is not correct", (String)(String.valueOf(start) + "\n" + start), (String)requestor.getStarts());
        CodeCorrectionTests.assertEquals((String)"a end of a suggestion is not correct", (String)(String.valueOf(end) + "\n" + end), (String)requestor.getEnds());
    }

    public void testCorrectImport2() throws JavaScriptModelException {
        CorrectionEngine engine = new CorrectionEngine((Map)JavaScriptCore.getOptions());
        CodeCorrectionTestsRequestor requestor = new CodeCorrectionTestsRequestor();
        IJavaScriptUnit cu = this.getCompilationUnit("CodeCorrection", "src", "", "CorrectImport2.js");
        IMarker[] markers = this.getMarkers(cu);
        CodeCorrectionTests.assertTrue((String)"should have one problem", (markers.length == 1 ? 1 : 0) != 0);
        engine.computeCorrections(markers[0], null, 0, (ICorrectionRequestor)requestor);
        String src = cu.getSource();
        String error = "dddz";
        int start = src.indexOf(error);
        int end = start + error.length();
        CodeCorrectionTests.assertEquals((String)"should have two suggestions", (String)"ddd\nddd.eee", (String)requestor.getSuggestions());
        CodeCorrectionTests.assertEquals((String)"a start of a suggestion is not correct", (String)(String.valueOf(start) + "\n" + start), (String)requestor.getStarts());
        CodeCorrectionTests.assertEquals((String)"a end of a suggestion is not correct", (String)(String.valueOf(end) + "\n" + end), (String)requestor.getEnds());
    }

    public void testCorrectImport3() throws JavaScriptModelException {
        CorrectionEngine engine = new CorrectionEngine((Map)JavaScriptCore.getOptions());
        CodeCorrectionTestsRequestor requestor = new CodeCorrectionTestsRequestor();
        IJavaScriptUnit cu = this.getCompilationUnit("CodeCorrection", "src", "", "CorrectImport3.js");
        IMarker[] markers = this.getMarkers(cu);
        CodeCorrectionTests.assertTrue((String)"should have one problem", (markers.length == 1 ? 1 : 0) != 0);
        engine.computeCorrections(markers[0], null, 0, (ICorrectionRequestor)requestor);
        String src = cu.getSource();
        String error = "AClassz";
        int start = src.indexOf(error);
        int end = start + error.length();
        CodeCorrectionTests.assertEquals((String)"should have two suggestions", (String)"AClass\nAClass2", (String)requestor.getSuggestions());
        CodeCorrectionTests.assertEquals((String)"a start of a suggestion is not correct", (String)(String.valueOf(start) + "\n" + start), (String)requestor.getStarts());
        CodeCorrectionTests.assertEquals((String)"a end of a suggestion is not correct", (String)(String.valueOf(end) + "\n" + end), (String)requestor.getEnds());
    }

    public void testCorrectSuperClass1() throws JavaScriptModelException {
        CorrectionEngine engine = new CorrectionEngine((Map)JavaScriptCore.getOptions());
        CodeCorrectionTestsRequestor requestor = new CodeCorrectionTestsRequestor();
        IJavaScriptUnit cu = this.getCompilationUnit("CodeCorrection", "src", "", "CorrectSuperClass1.js");
        IMarker[] markers = this.getMarkers(cu);
        CodeCorrectionTests.assertTrue((String)"should have one problem", (markers.length == 1 ? 1 : 0) != 0);
        engine.computeCorrections(markers[0], null, 0, (ICorrectionRequestor)requestor);
        String src = cu.getSource();
        String error = "dddz";
        int start = src.indexOf(error);
        int end = start + error.length();
        CodeCorrectionTests.assertEquals((String)"should have two suggestions", (String)"ddd\nddd.eee", (String)requestor.getSuggestions());
        CodeCorrectionTests.assertEquals((String)"a start of a suggestion is not correct", (String)(String.valueOf(start) + "\n" + start), (String)requestor.getStarts());
        CodeCorrectionTests.assertEquals((String)"a end of a suggestion is not correct", (String)(String.valueOf(end) + "\n" + end), (String)requestor.getEnds());
    }

    public void testCorrectSuperClass2() throws JavaScriptModelException {
        CorrectionEngine engine = new CorrectionEngine((Map)JavaScriptCore.getOptions());
        CodeCorrectionTestsRequestor requestor = new CodeCorrectionTestsRequestor();
        IJavaScriptUnit cu = this.getCompilationUnit("CodeCorrection", "src", "", "CorrectSuperClass2.js");
        IMarker[] markers = this.getMarkers(cu);
        CodeCorrectionTests.assertTrue((String)"should have one problem", (markers.length == 1 ? 1 : 0) != 0);
        engine.computeCorrections(markers[0], null, 0, (ICorrectionRequestor)requestor);
        String src = cu.getSource();
        String error = "AClassz";
        int start = src.indexOf(error);
        int end = start + error.length();
        CodeCorrectionTests.assertEquals((String)"should have two suggestions", (String)"AClass\nAClass2", (String)requestor.getSuggestions());
        CodeCorrectionTests.assertEquals((String)"a start of a suggestion is not correct", (String)(String.valueOf(start) + "\n" + start), (String)requestor.getStarts());
        CodeCorrectionTests.assertEquals((String)"a end of a suggestion is not correct", (String)(String.valueOf(end) + "\n" + end), (String)requestor.getEnds());
    }

    public void testCorrectSuperInterface1() throws JavaScriptModelException {
        CorrectionEngine engine = new CorrectionEngine((Map)JavaScriptCore.getOptions());
        CodeCorrectionTestsRequestor requestor = new CodeCorrectionTestsRequestor();
        IJavaScriptUnit cu = this.getCompilationUnit("CodeCorrection", "src", "", "CorrectSuperInterface1.js");
        IMarker[] markers = this.getMarkers(cu);
        CodeCorrectionTests.assertTrue((String)"should have one problem", (markers.length == 1 ? 1 : 0) != 0);
        engine.computeCorrections(markers[0], null, 0, (ICorrectionRequestor)requestor);
        String src = cu.getSource();
        String error = "cccz";
        int start = src.indexOf(error);
        int end = start + error.length();
        CodeCorrectionTests.assertEquals((String)"should have two suggestions", (String)"ccc\ncccInterface", (String)requestor.getSuggestions());
        CodeCorrectionTests.assertEquals((String)"a start of a suggestion is not correct", (String)(String.valueOf(start) + "\n" + start), (String)requestor.getStarts());
        CodeCorrectionTests.assertEquals((String)"a end of a suggestion is not correct", (String)(String.valueOf(end) + "\n" + end), (String)requestor.getEnds());
    }

    public void testCorrectSuperInterface2() throws JavaScriptModelException {
        CorrectionEngine engine = new CorrectionEngine((Map)JavaScriptCore.getOptions());
        CodeCorrectionTestsRequestor requestor = new CodeCorrectionTestsRequestor();
        IJavaScriptUnit cu = this.getCompilationUnit("CodeCorrection", "src", "", "CorrectSuperInterface2.js");
        IMarker[] markers = this.getMarkers(cu);
        CodeCorrectionTests.assertTrue((String)"should have one problem", (markers.length == 1 ? 1 : 0) != 0);
        engine.computeCorrections(markers[0], null, 0, (ICorrectionRequestor)requestor);
        String src = cu.getSource();
        String error = "AListenerz";
        int start = src.indexOf(error);
        int end = start + error.length();
        CodeCorrectionTests.assertEquals((String)"should have two suggestions", (String)"AListener", (String)requestor.getSuggestions());
        CodeCorrectionTests.assertEquals((String)"a start of a suggestion is not correct", (String)("" + start), (String)requestor.getStarts());
        CodeCorrectionTests.assertEquals((String)"a end of a suggestion is not correct", (String)("" + end), (String)requestor.getEnds());
    }

    public void testCorrectException1() throws JavaScriptModelException {
        CorrectionEngine engine = new CorrectionEngine((Map)JavaScriptCore.getOptions());
        CodeCorrectionTestsRequestor requestor = new CodeCorrectionTestsRequestor();
        IJavaScriptUnit cu = this.getCompilationUnit("CodeCorrection", "src", "", "CorrectException1.js");
        IMarker[] markers = this.getMarkers(cu);
        CodeCorrectionTests.assertTrue((String)"should have one problem", (markers.length == 1 ? 1 : 0) != 0);
        engine.computeCorrections(markers[0], null, 0, (ICorrectionRequestor)requestor);
        String src = cu.getSource();
        String error = "bbbz";
        int start = src.indexOf(error);
        int end = start + error.length();
        CodeCorrectionTests.assertEquals((String)"should have two suggestions", (String)"bbb\nbbb.ccc", (String)requestor.getSuggestions());
        CodeCorrectionTests.assertEquals((String)"a start of a suggestion is not correct", (String)(String.valueOf(start) + "\n" + start), (String)requestor.getStarts());
        CodeCorrectionTests.assertEquals((String)"a end of a suggestion is not correct", (String)(String.valueOf(end) + "\n" + end), (String)requestor.getEnds());
    }

    public void testCorrectException2() throws JavaScriptModelException {
        CorrectionEngine engine = new CorrectionEngine((Map)JavaScriptCore.getOptions());
        CodeCorrectionTestsRequestor requestor = new CodeCorrectionTestsRequestor();
        IJavaScriptUnit cu = this.getCompilationUnit("CodeCorrection", "src", "", "CorrectException2.js");
        IMarker[] markers = this.getMarkers(cu);
        CodeCorrectionTests.assertTrue((String)"should have one problem", (markers.length == 1 ? 1 : 0) != 0);
        engine.computeCorrections(markers[0], null, 0, (ICorrectionRequestor)requestor);
        String src = cu.getSource();
        String error = "AnExceptionz";
        int start = src.indexOf(error);
        int end = start + error.length();
        CodeCorrectionTests.assertEquals((String)"should have two suggestions", (String)"AnException", (String)requestor.getSuggestions());
        CodeCorrectionTests.assertEquals((String)"a start of a suggestion is not correct", (String)("" + start), (String)requestor.getStarts());
        CodeCorrectionTests.assertEquals((String)"a end of a suggestion is not correct", (String)("" + end), (String)requestor.getEnds());
    }

    public void testCorrectMethod1() throws JavaScriptModelException {
        CorrectionEngine engine = new CorrectionEngine((Map)JavaScriptCore.getOptions());
        CodeCorrectionTestsRequestor requestor = new CodeCorrectionTestsRequestor();
        IJavaScriptUnit cu = this.getCompilationUnit("CodeCorrection", "src", "", "CorrectMethod1.js");
        IMarker[] markers = this.getMarkers(cu);
        CodeCorrectionTests.assertTrue((String)"should have one problem", (markers.length == 1 ? 1 : 0) != 0);
        engine.computeCorrections(markers[0], null, 0, (ICorrectionRequestor)requestor);
        String src = cu.getSource();
        String error = "bar";
        int start = src.lastIndexOf(error);
        int end = start + error.length();
        CodeCorrectionTests.assertEquals((String)"should have one suggestion", (String)"bar0", (String)requestor.getSuggestions());
        CodeCorrectionTests.assertEquals((String)"a start of a suggestion is not correct", (String)("" + start), (String)requestor.getStarts());
        CodeCorrectionTests.assertEquals((String)"a end of a suggestion is not correct", (String)("" + end), (String)requestor.getEnds());
    }

    public void testCorrectMethod2() throws JavaScriptModelException {
        CorrectionEngine engine = new CorrectionEngine((Map)JavaScriptCore.getOptions());
        CodeCorrectionTestsRequestor requestor = new CodeCorrectionTestsRequestor();
        IJavaScriptUnit cu = this.getCompilationUnit("CodeCorrection", "src", "", "CorrectMethod2.js");
        IMarker[] markers = this.getMarkers(cu);
        CodeCorrectionTests.assertTrue((String)"should have one problem", (markers.length == 1 ? 1 : 0) != 0);
        engine.computeCorrections(markers[0], null, 0, (ICorrectionRequestor)requestor);
        String src = cu.getSource();
        String error = "bar";
        int start = src.lastIndexOf(error);
        int end = start + error.length();
        CodeCorrectionTests.assertEquals((String)"should have one suggestion", (String)"bar0", (String)requestor.getSuggestions());
        CodeCorrectionTests.assertEquals((String)"a start of a suggestion is not correct", (String)("" + start), (String)requestor.getStarts());
        CodeCorrectionTests.assertEquals((String)"a end of a suggestion is not correct", (String)("" + end), (String)requestor.getEnds());
    }

    public void testCorrectField1() throws JavaScriptModelException {
        CorrectionEngine engine = new CorrectionEngine((Map)JavaScriptCore.getOptions());
        CodeCorrectionTestsRequestor requestor = new CodeCorrectionTestsRequestor();
        IJavaScriptUnit cu = this.getCompilationUnit("CodeCorrection", "src", "", "CorrectField1.js");
        IMarker[] markers = this.getMarkers(cu);
        CodeCorrectionTests.assertTrue((String)"should have one problem", (markers.length == 1 ? 1 : 0) != 0);
        engine.computeCorrections(markers[0], null, 0, (ICorrectionRequestor)requestor);
        String src = cu.getSource();
        String error = "bar";
        int start = src.lastIndexOf(error);
        int end = start + error.length();
        CodeCorrectionTests.assertEquals((String)"should have one suggestion", (String)"bar0", (String)requestor.getSuggestions());
        CodeCorrectionTests.assertEquals((String)"a start of a suggestion is not correct", (String)("" + start), (String)requestor.getStarts());
        CodeCorrectionTests.assertEquals((String)"a end of a suggestion is not correct", (String)("" + end), (String)requestor.getEnds());
    }

    public void testCorrectField2() throws JavaScriptModelException {
        CorrectionEngine engine = new CorrectionEngine((Map)JavaScriptCore.getOptions());
        CodeCorrectionTestsRequestor requestor = new CodeCorrectionTestsRequestor();
        IJavaScriptUnit cu = this.getCompilationUnit("CodeCorrection", "src", "", "CorrectField2.js");
        IMarker[] markers = this.getMarkers(cu);
        CodeCorrectionTests.assertTrue((String)"should have one problem", (markers.length == 1 ? 1 : 0) != 0);
        engine.computeCorrections(markers[0], null, 0, (ICorrectionRequestor)requestor);
        String src = cu.getSource();
        String error = "bar";
        int start = src.lastIndexOf(error);
        int end = start + error.length();
        CodeCorrectionTests.assertEquals((String)"should have one suggestion", (String)"bar0", (String)requestor.getSuggestions());
        CodeCorrectionTests.assertEquals((String)"a start of a suggestion is not correct", (String)("" + start), (String)requestor.getStarts());
        CodeCorrectionTests.assertEquals((String)"a end of a suggestion is not correct", (String)("" + end), (String)requestor.getEnds());
    }

    public void testCorrectLocalVariable1() throws JavaScriptModelException {
        CorrectionEngine engine = new CorrectionEngine((Map)JavaScriptCore.getOptions());
        CodeCorrectionTestsRequestor requestor = new CodeCorrectionTestsRequestor();
        IJavaScriptUnit cu = this.getCompilationUnit("CodeCorrection", "src", "", "CorrectLocalVariable1.js");
        IMarker[] markers = this.getMarkers(cu);
        CodeCorrectionTests.assertTrue((String)"should have one problem", (markers.length == 1 ? 1 : 0) != 0);
        engine.computeCorrections(markers[0], null, 0, (ICorrectionRequestor)requestor);
        String src = cu.getSource();
        String error = "bar";
        int start = src.lastIndexOf(error);
        int end = start + error.length();
        CodeCorrectionTests.assertEquals((String)"should have one suggestion", (String)"bar0", (String)requestor.getSuggestions());
        CodeCorrectionTests.assertEquals((String)"a start of a suggestion is not correct", (String)("" + start), (String)requestor.getStarts());
        CodeCorrectionTests.assertEquals((String)"a end of a suggestion is not correct", (String)("" + end), (String)requestor.getEnds());
    }

    public void testCorrectArgument1() throws JavaScriptModelException {
        CorrectionEngine engine = new CorrectionEngine((Map)JavaScriptCore.getOptions());
        CodeCorrectionTestsRequestor requestor = new CodeCorrectionTestsRequestor();
        IJavaScriptUnit cu = this.getCompilationUnit("CodeCorrection", "src", "", "CorrectArgument1.js");
        IMarker[] markers = this.getMarkers(cu);
        CodeCorrectionTests.assertTrue((String)"should have one problem", (markers.length == 1 ? 1 : 0) != 0);
        engine.computeCorrections(markers[0], null, 0, (ICorrectionRequestor)requestor);
        String src = cu.getSource();
        String error = "bar";
        int start = src.lastIndexOf(error);
        int end = start + error.length();
        CodeCorrectionTests.assertEquals((String)"should have one suggestion", (String)"bar0", (String)requestor.getSuggestions());
        CodeCorrectionTests.assertEquals((String)"a start of a suggestion is not correct", (String)("" + start), (String)requestor.getStarts());
        CodeCorrectionTests.assertEquals((String)"a end of a suggestion is not correct", (String)("" + end), (String)requestor.getEnds());
    }

    public void testCorrectReturnType1() throws JavaScriptModelException {
        CorrectionEngine engine = new CorrectionEngine((Map)JavaScriptCore.getOptions());
        CodeCorrectionTestsRequestor requestor = new CodeCorrectionTestsRequestor();
        IJavaScriptUnit cu = this.getCompilationUnit("CodeCorrection", "src", "", "CorrectReturnType1.js");
        IMarker[] markers = this.getMarkers(cu);
        CodeCorrectionTests.assertTrue((String)"should have one problem", (markers.length == 1 ? 1 : 0) != 0);
        engine.computeCorrections(markers[0], null, 0, (ICorrectionRequestor)requestor);
        String src = cu.getSource();
        String error = "dddz";
        int start = src.indexOf(error);
        int end = start + error.length();
        CodeCorrectionTests.assertEquals((String)"should have two suggestions", (String)"ddd\nddd.eee", (String)requestor.getSuggestions());
        CodeCorrectionTests.assertEquals((String)"a start of a suggestion is not correct", (String)(String.valueOf(start) + "\n" + start), (String)requestor.getStarts());
        CodeCorrectionTests.assertEquals((String)"a end of a suggestion is not correct", (String)(String.valueOf(end) + "\n" + end), (String)requestor.getEnds());
    }

    public void testCorrectReturnType2() throws JavaScriptModelException {
        CorrectionEngine engine = new CorrectionEngine((Map)JavaScriptCore.getOptions());
        CodeCorrectionTestsRequestor requestor = new CodeCorrectionTestsRequestor();
        IJavaScriptUnit cu = this.getCompilationUnit("CodeCorrection", "src", "", "CorrectReturnType2.js");
        IMarker[] markers = this.getMarkers(cu);
        CodeCorrectionTests.assertTrue((String)"should have one problem", (markers.length == 1 ? 1 : 0) != 0);
        engine.computeCorrections(markers[0], null, 0, (ICorrectionRequestor)requestor);
        String src = cu.getSource();
        String error = "AClassz";
        int start = src.indexOf(error);
        int end = start + error.length();
        CodeCorrectionTests.assertEquals((String)"should have two suggestions", (String)"AClass\nAClass2", (String)requestor.getSuggestions());
        CodeCorrectionTests.assertEquals((String)"a start of a suggestion is not correct", (String)(String.valueOf(start) + "\n" + start), (String)requestor.getStarts());
        CodeCorrectionTests.assertEquals((String)"a end of a suggestion is not correct", (String)(String.valueOf(end) + "\n" + end), (String)requestor.getEnds());
    }

    public void testWarningTokens() {
        CodeCorrectionTests.assertNull((String)"assertIdentifier is a valid token for @SuppressWarnings", (Object)CorrectionEngine.getWarningToken((int)536871352));
        CodeCorrectionTests.assertEquals((String)"wrong token", (String)"deprecation", (String)CorrectionEngine.getWarningToken((int)0x8000085));
        CodeCorrectionTests.assertEquals((String)"wrong token", (String)"deprecation", (String)CorrectionEngine.getWarningToken((int)67109276));
        CodeCorrectionTests.assertEquals((String)"wrong token", (String)"deprecation", (String)CorrectionEngine.getWarningToken((int)0x1000005));
        CodeCorrectionTests.assertEquals((String)"wrong token", (String)"deprecation", (String)CorrectionEngine.getWarningToken((int)67108967));
        CodeCorrectionTests.assertEquals((String)"wrong token", (String)"deprecation", (String)CorrectionEngine.getWarningToken((int)33554505));
        CodeCorrectionTests.assertEquals((String)"wrong token", (String)"finally", (String)CorrectionEngine.getWarningToken((int)536871096));
        CodeCorrectionTests.assertEquals((String)"wrong token", (String)"hiding", (String)CorrectionEngine.getWarningToken((int)570425436));
        CodeCorrectionTests.assertEquals((String)"wrong token", (String)"hiding", (String)CorrectionEngine.getWarningToken((int)570425437));
        CodeCorrectionTests.assertEquals((String)"wrong token", (String)"hiding", (String)CorrectionEngine.getWarningToken((int)536871002));
        CodeCorrectionTests.assertEquals((String)"wrong token", (String)"hiding", (String)CorrectionEngine.getWarningToken((int)570425435));
        CodeCorrectionTests.assertEquals((String)"wrong token", (String)"hiding", (String)CorrectionEngine.getWarningToken((int)536871006));
        CodeCorrectionTests.assertEquals((String)"wrong token", (String)"hiding", (String)CorrectionEngine.getWarningToken((int)536871007));
        CodeCorrectionTests.assertEquals((String)"wrong token", (String)"hiding", (String)CorrectionEngine.getWarningToken((int)16777381));
        CodeCorrectionTests.assertEquals((String)"wrong token", (String)"nls", (String)CorrectionEngine.getWarningToken((int)536871173));
        CodeCorrectionTests.assertEquals((String)"wrong token", (String)"unused", (String)CorrectionEngine.getWarningToken((int)536870973));
        CodeCorrectionTests.assertEquals((String)"wrong token", (String)"unused", (String)CorrectionEngine.getWarningToken((int)536870974));
        CodeCorrectionTests.assertEquals((String)"wrong token", (String)"unused", (String)CorrectionEngine.getWarningToken((int)603979910));
        CodeCorrectionTests.assertEquals((String)"wrong token", (String)"unused", (String)CorrectionEngine.getWarningToken((int)603979894));
        CodeCorrectionTests.assertEquals((String)"wrong token", (String)"unused", (String)CorrectionEngine.getWarningToken((int)570425421));
        CodeCorrectionTests.assertEquals((String)"wrong token", (String)"unused", (String)CorrectionEngine.getWarningToken((int)553648135));
        CodeCorrectionTests.assertEquals((String)"wrong token", (String)"unused", (String)CorrectionEngine.getWarningToken((int)536871097));
        CodeCorrectionTests.assertEquals((String)"wrong token", (String)"unused", (String)CorrectionEngine.getWarningToken((int)536871098));
        CodeCorrectionTests.assertEquals((String)"wrong token", (String)"static-access", (String)CorrectionEngine.getWarningToken((int)603979895));
        CodeCorrectionTests.assertEquals((String)"wrong token", (String)"static-access", (String)CorrectionEngine.getWarningToken((int)570425422));
        CodeCorrectionTests.assertEquals((String)"wrong token", (String)"static-access", (String)CorrectionEngine.getWarningToken((int)0x21000012));
        CodeCorrectionTests.assertEquals((String)"wrong token", (String)"static-access", (String)CorrectionEngine.getWarningToken((int)603979893));
        CodeCorrectionTests.assertEquals((String)"wrong token", (String)"static-access", (String)CorrectionEngine.getWarningToken((int)570425420));
        CodeCorrectionTests.assertEquals((String)"wrong token", (String)"synthetic-access", (String)CorrectionEngine.getWarningToken((int)33554622));
        CodeCorrectionTests.assertEquals((String)"wrong token", (String)"synthetic-access", (String)CorrectionEngine.getWarningToken((int)33554623));
        CodeCorrectionTests.assertEquals((String)"wrong token", (String)"synthetic-access", (String)CorrectionEngine.getWarningToken((int)0x40000C0));
        CodeCorrectionTests.assertEquals((String)"wrong token", (String)"synthetic-access", (String)CorrectionEngine.getWarningToken((int)67109057));
        CodeCorrectionTests.assertEquals((String)"wrong token", (String)"unqualified-field-access", (String)CorrectionEngine.getWarningToken((int)570425423));
    }
}

