/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.regression;

import java.util.Map;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.AbstractRegressionTest;

public class AssignmentTest
extends AbstractRegressionTest {
    public AssignmentTest(String name) {
        super(name);
    }

    @Override
    protected Map getCompilerOptions() {
        Map options = super.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.nullReference", "error");
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.noEffectAssignment", "error");
        return options;
    }

    public void test002() {
        this.runNegativeTest(new String[]{"X.js", "\tvar a;\t\n\tvar next;\t\n\t function foo( arg){\t\n\t\n\t\tzork = zork;\t\n\t\targ = zork;\t\n\t\n\t\targ = arg;  // noop\t\n\t\ta = a;  // noop\t\n\t\tthis.next = this.next; // noop\t\n\t\tthis.next = next; // noop\t\n\t\n\t\tnext.a = next.a; // could raise NPE\t\n\t\tthis.next.next.a = next.next.a; // could raise NPE\t\n\t\ta = next.a; // could raise NPE\t\n\t\tthis. a = next.a; \t\n\t}\t\n\n"}, "----------\n1. ERROR in X.js (at line 8)\n\targ = arg;  // noop\t\n\t^^^^^^^^^\nThe assignment to variable arg has no effect\n----------\n2. ERROR in X.js (at line 9)\n\ta = a;  // noop\t\n\t^^^^^\nThe assignment to variable a has no effect\n----------\n3. ERROR in X.js (at line 10)\n\tthis.next = this.next; // noop\t\n\t^^^^^^^^^^^^^^^^^^^^^\nThe assignment to variable next has no effect\n----------\n4. ERROR in X.js (at line 11)\n\tthis.next = next; // noop\t\n\t^^^^^^^^^^^^^^^^\nThe assignment to variable next has no effect\n----------\n");
    }

    public void test033() {
        this.runNegativeTest(new String[]{"X.js", "\t\n\tfunction foo() {\n\t\tvar a,b;\n\t\tdo{\n\t\t   a=\"Hello \";\n\t\t}while(a!=null);\n\t\t\t\t\n\t\tif(a!=null)\n\t\t{\n\t\t   b=\"World!\";\n\t\t}\n\t\tprintln(a+b);\n\t}\n\n"}, "----------\n1. WARNING in X.js (at line 12)\n\tprintln(a+b);\n\t          ^\nThe local variable b may not have been initialized\n----------\n");
    }

    public void test035() {
        this.runNegativeTest(new String[]{"X.js", "\tvar f;\n\tfunction foo( i) {\n\t\ti = i++;\n\t\ti = ++i;\n\t\tf = f++;\n\t\tf = ++f;\n\t\tvar z;\t}\n\n"}, "----------\n1. ERROR in X.js (at line 4)\n\ti = ++i;\n\t^^^^^^^\nThe assignment to variable i has no effect\n----------\n2. ERROR in X.js (at line 6)\n\tf = ++f;\n\t^^^^^^^\nThe assignment to variable f has no effect\n----------\n");
    }

    public void test040() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.parameterAssignment", "error");
        this.runNegativeTest(new String[]{"X.js", "  function foo(b) {\n    b = false;\n  }\n\n"}, "----------\n1. ERROR in X.js (at line 2)\n\tb = false;\n\t^\nThe parameter b should not be assigned\n----------\n", null, true, options);
    }

    public void test041() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.parameterAssignment", "error");
        this.runNegativeTest(new String[]{"X.js", "  function foo(b) {\n    if (false) {\n      b = false;\n    }\n  }\n\n"}, "----------\n1. ERROR in X.js (at line 3)\n\tb = false;\n\t^\nThe parameter b should not be assigned\n----------\n", null, true, options);
    }

    public void test042() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.parameterAssignment", "error");
        this.runNegativeTest(new String[]{"X.js", "  function foo(b) {\n    if (true) {\n      return;\n    }\n    b = false;\n  }\n\n"}, "----------\n1. ERROR in X.js (at line 5)\n\tb = false;\n\t^\nThe parameter b should not be assigned\n----------\n", null, true, options);
    }

    public void test044() {
        this.runNegativeTest(new String[]{"X.js", "\tvar length1 = 0;\n\t{\n\t\tlength1 = length1; // already detected\n\t}\n\tvar length2 = length2 = 0; // not detected\n\tvar length3 = 0;\n\t{\n\t\tlength3 = length3 = 0; // not detected\n\t}\n\t function foo() {\n\t\tvar length1 = 0;\n\t\tlength1 = length1; // already detected\n\t\tvar length2 = length2 = 0; // not detected\n\t\tvar length3 = 0;\n\t\tlength3 = length3 = 0; // not detected\n\t}\n\n"}, "----------\n1. ERROR in X.js (at line 3)\n\tlength1 = length1; // already detected\n\t^^^^^^^^^^^^^^^^^\nThe assignment to variable length1 has no effect\n----------\n2. ERROR in X.js (at line 5)\n\tvar length2 = length2 = 0; // not detected\n\t    ^^^^^^^^^^^^^^^^^^^^^\nThe assignment to variable length2 has no effect\n----------\n3. ERROR in X.js (at line 8)\n\tlength3 = length3 = 0; // not detected\n\t^^^^^^^^^^^^^^^^^^^^^\nThe assignment to variable length3 has no effect\n----------\n4. WARNING in X.js (at line 11)\n\tvar length1 = 0;\n\t    ^^^^^^^\nThe local variable length1 is hiding a global variable\n----------\n5. ERROR in X.js (at line 12)\n\tlength1 = length1; // already detected\n\t^^^^^^^^^^^^^^^^^\nThe assignment to variable length1 has no effect\n----------\n6. WARNING in X.js (at line 13)\n\tvar length2 = length2 = 0; // not detected\n\t    ^^^^^^^\nThe local variable length2 is hiding a global variable\n----------\n7. ERROR in X.js (at line 13)\n\tvar length2 = length2 = 0; // not detected\n\t    ^^^^^^^^^^^^^^^^^^^^^\nThe assignment to variable length2 has no effect\n----------\n8. WARNING in X.js (at line 14)\n\tvar length3 = 0;\n\t    ^^^^^^^\nThe local variable length3 is hiding a global variable\n----------\n9. ERROR in X.js (at line 15)\n\tlength3 = length3 = 0; // not detected\n\t^^^^^^^^^^^^^^^^^^^^^\nThe assignment to variable length3 has no effect\n----------\n");
    }

    public void test045() {
        this.runNegativeTest(new String[]{"X.js", "\tfunction foo() {\n\t\tvar length2 = length2 = 0; // first problem\n\t\tvar length3 = 0;\n\t\tlength3 = length3 = 0; // second problem\n\t}\n\n"}, "----------\n1. ERROR in X.js (at line 2)\n\tvar length2 = length2 = 0; // first problem\n\t    ^^^^^^^^^^^^^^^^^^^^^\nThe assignment to variable length2 has no effect\n----------\n2. ERROR in X.js (at line 4)\n\tlength3 = length3 = 0; // second problem\n\t^^^^^^^^^^^^^^^^^^^^^\nThe assignment to variable length3 has no effect\n----------\n");
    }

    public static Class testClass() {
        return AssignmentTest.class;
    }
}

