/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.v8native.value;

import java.util.EnumSet;
import java.util.Set;
import org.eclipse.wst.jsdt.chromium.JsValue;
import org.eclipse.wst.jsdt.chromium.internal.v8native.V8Helper;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.data.FunctionValueHandle;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.data.ObjectValueHandle;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.data.RefWithDisplayData;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.data.ValueHandle;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.LoadableString;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.SubpropertiesMirror;
import org.json.simple.JSONValue;

public abstract class ValueMirror {
    private static final Set<JsValue.Type> TYPES_WITH_ACCURATE_DISPLAY = EnumSet.of(JsValue.Type.TYPE_NUMBER, JsValue.Type.TYPE_BOOLEAN, JsValue.Type.TYPE_NULL, JsValue.Type.TYPE_UNDEFINED);
    private final Long ref;

    static ValueMirror merge(ValueMirror base, ValueMirror alternative) {
        int lenDiff;
        if (base.hasProperties()) {
            if (!alternative.hasProperties()) {
                return base;
            }
        } else if (alternative.hasProperties()) {
            return alternative;
        }
        if ((lenDiff = base.getStringLength() - alternative.getStringLength()) < 0) {
            return alternative;
        }
        return base;
    }

    public static ValueMirror createIfSure(final RefWithDisplayData refWithDisplayData) {
        long ref = refWithDisplayData.ref();
        final JsValue.Type type = V8Helper.calculateType(refWithDisplayData.type(), refWithDisplayData.className(), false);
        if (!TYPES_WITH_ACCURATE_DISPLAY.contains((Object)type)) {
            return null;
        }
        return new ValueMirror(ref){

            @Override
            public JsValue.Type getType() {
                return type;
            }

            @Override
            public String getClassName() {
                return refWithDisplayData.className();
            }

            @Override
            public LoadableString getStringValue() {
                String valueStr;
                Object valueObj = refWithDisplayData.value();
                if (valueObj == null) {
                    valueStr = refWithDisplayData.type();
                } else {
                    valueStr = JSONValue.toJSONString((Object)valueObj);
                    if (type == JsValue.Type.TYPE_NUMBER && valueStr.lastIndexOf(69) != -1) {
                        valueStr = valueStr.toLowerCase();
                    }
                }
                return new LoadableString.Immutable(valueStr);
            }

            @Override
            public boolean hasProperties() {
                return false;
            }

            @Override
            public SubpropertiesMirror getProperties() {
                return null;
            }
        };
    }

    public static ValueMirror create(final ValueHandle valueHandle, final LoadableString.Factory factory) {
        Long ref = valueHandle.handle();
        final JsValue.Type type = V8Helper.calculateType(valueHandle.type(), valueHandle.className(), true);
        return new ValueMirror(ref){

            @Override
            public JsValue.Type getType() {
                return type;
            }

            @Override
            public LoadableString getStringValue() {
                return V8Helper.createLoadableString(valueHandle, factory);
            }

            @Override
            public SubpropertiesMirror getProperties() {
                SubpropertiesMirror.JsonBased subpropertiesMirror;
                ObjectValueHandle objectValueHandle = valueHandle.asObject();
                if (objectValueHandle == null) {
                    return SubpropertiesMirror.EMPTY;
                }
                valueHandle.handle();
                if (type == JsValue.Type.TYPE_FUNCTION) {
                    FunctionValueHandle functionValueHandle = objectValueHandle.asFunction();
                    subpropertiesMirror = new SubpropertiesMirror.FunctionValueBased(functionValueHandle);
                } else {
                    subpropertiesMirror = new SubpropertiesMirror.ObjectValueBased(objectValueHandle);
                }
                return subpropertiesMirror;
            }

            @Override
            public boolean hasProperties() {
                return true;
            }

            @Override
            public String getClassName() {
                return valueHandle.className();
            }
        };
    }

    public static ValueMirror create(Long ref, final JsValue.Type type, final String className, final LoadableString loadableString, final SubpropertiesMirror subpropertiesMirror) {
        return new ValueMirror(ref){

            @Override
            public JsValue.Type getType() {
                return type;
            }

            @Override
            public String getClassName() {
                return className;
            }

            @Override
            public LoadableString getStringValue() {
                return loadableString;
            }

            @Override
            public SubpropertiesMirror getProperties() {
                return subpropertiesMirror;
            }

            @Override
            public boolean hasProperties() {
                return this.getProperties() != null;
            }
        };
    }

    protected ValueMirror(Long ref) {
        assert (ref != null);
        this.ref = ref;
    }

    public abstract JsValue.Type getType();

    public abstract SubpropertiesMirror getProperties();

    public Long getRef() {
        return this.ref;
    }

    public abstract LoadableString getStringValue();

    public abstract String getClassName();

    public abstract boolean hasProperties();

    int getStringLength() {
        LoadableString loadableString = this.getStringValue();
        if (loadableString == null) {
            return 0;
        }
        return loadableString.getCurrentString().length();
    }
}

