/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.v8native.value;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.wst.jsdt.chromium.JsDeclarativeVariable;
import org.eclipse.wst.jsdt.chromium.JsObject;
import org.eclipse.wst.jsdt.chromium.JsScope;
import org.eclipse.wst.jsdt.chromium.JsValue;
import org.eclipse.wst.jsdt.chromium.internal.v8native.CallFrameImpl;
import org.eclipse.wst.jsdt.chromium.internal.v8native.InternalContext;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.V8ProtocolUtil;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.ScopeRef;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.data.ObjectValueHandle;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.data.ValueHandle;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.output.ScopeMessage;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.JsFunctionImpl;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.JsValueBase;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.JsVariableBase;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.PropertyReference;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.ValueLoaderImpl;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.ValueMirror;
import org.eclipse.wst.jsdt.chromium.util.AsyncFuture;
import org.eclipse.wst.jsdt.chromium.util.MethodIsBlockingException;

public abstract class JsScopeImpl<D extends DataBase>
implements JsScope {
    private final Host host;
    private final int scopeIndex;
    private final JsScope.Type type;
    private final AtomicReference<AsyncFuture<D>> deferredDataRef = new AtomicReference<Object>(null);
    private static final Map<Integer, JsScope.Type> CODE_TO_TYPE = new HashMap<Integer, JsScope.Type>();

    static {
        CODE_TO_TYPE.put(0, JsScope.Type.GLOBAL);
        CODE_TO_TYPE.put(1, JsScope.Type.LOCAL);
        CODE_TO_TYPE.put(2, JsScope.Type.WITH);
        CODE_TO_TYPE.put(3, JsScope.Type.CLOSURE);
        CODE_TO_TYPE.put(4, JsScope.Type.CATCH);
    }

    public static JsScopeImpl<?> create(Host host, ScopeRef scopeRef) {
        JsScope.Type type = JsScopeImpl.convertType((int)scopeRef.type());
        if (type == JsScope.Type.WITH || type == JsScope.Type.GLOBAL) {
            return new ObjectBasedImpl(host, type, (int)scopeRef.index());
        }
        return new DeclarativeImpl(host, type, (int)scopeRef.index());
    }

    protected JsScopeImpl(Host host, JsScope.Type type, int scopeIndex) {
        this.host = host;
        this.type = type;
        this.scopeIndex = scopeIndex;
    }

    @Override
    public JsScope.Type getType() {
        return this.type;
    }

    protected int getScopeIndex() {
        return this.scopeIndex;
    }

    protected Host getScopeHost() {
        return this.host;
    }

    protected D getDeferredData() throws MethodIsBlockingException {
        boolean restartOperation;
        AsyncFuture<D> future = this.deferredDataRef.get();
        ValueLoaderImpl valueLoader = this.host.getInternalContext().getValueLoader();
        int cacheState = valueLoader.getCurrentCacheState();
        if (future == null) {
            restartOperation = false;
        } else {
            DataBase result = (DataBase)future.getSync();
            if (!result.isCacheObsolete(cacheState)) {
                return (D)result;
            }
            restartOperation = true;
        }
        AsyncFuture.SyncOperation<D> loadOperation = this.createLoadDataOperation(valueLoader, cacheState);
        AsyncFuture.initializeReference(this.deferredDataRef, loadOperation.asAsyncOperation(), restartOperation);
        loadOperation.execute();
        return (D)((DataBase)this.deferredDataRef.get().getSync());
    }

    protected abstract AsyncFuture.SyncOperation<D> createLoadDataOperation(ValueLoaderImpl var1, int var2);

    protected ObjectValueHandle loadScopeObject(ValueLoaderImpl valueLoader) throws MethodIsBlockingException {
        ScopeMessage.Ref ref = new ScopeMessage.Ref(this.scopeIndex, this.host.getProtocolParameter());
        return valueLoader.loadScopeFields(ref);
    }

    public static JsScope.Type convertType(int typeCode) {
        JsScope.Type type = CODE_TO_TYPE.get(typeCode);
        if (type == null) {
            type = JsScope.Type.UNKNOWN;
        }
        return type;
    }

    static abstract class DataBase {
        DataBase() {
        }

        abstract boolean isCacheObsolete(int var1);
    }

    private static class DeclarativeImpl
    extends JsScopeImpl<DeferredData>
    implements JsScope.Declarative {
        DeclarativeImpl(Host host, JsScope.Type type, int scopeIndex) {
            super(host, type, scopeIndex);
        }

        @Override
        public JsScope.Declarative asDeclarativeScope() {
            return this;
        }

        @Override
        public JsScope.ObjectBased asObjectBased() {
            return null;
        }

        @Override
        public <R> R accept(JsScope.Visitor<R> visitor) {
            return visitor.visitDeclarative(this);
        }

        @Override
        public List<? extends JsDeclarativeVariable> getVariables() throws MethodIsBlockingException {
            return ((DeferredData)this.getDeferredData()).variables;
        }

        @Override
        protected AsyncFuture.SyncOperation<DeferredData> createLoadDataOperation(final ValueLoaderImpl valueLoader, final int cacheState) {
            return new AsyncFuture.SyncOperation<DeferredData>(){

                @Override
                protected DeferredData runSync() throws MethodIsBlockingException {
                    List list = this.load(valueLoader);
                    return new DeferredData(list, cacheState);
                }
            };
        }

        private List<JsDeclarativeVariable> load(ValueLoaderImpl valueLoader) throws MethodIsBlockingException {
            ObjectValueHandle scopeObject = this.loadScopeObject(valueLoader);
            if (scopeObject == null) {
                return Collections.emptyList();
            }
            List<? extends PropertyReference> propertyRefs = V8ProtocolUtil.extractObjectProperties(scopeObject);
            List<ValueMirror> propertyMirrors = valueLoader.getOrLoadValueFromRefs(propertyRefs);
            ScopeMessage.Ref scopeRef = new ScopeMessage.Ref(this.getScopeIndex(), this.getScopeHost().getProtocolParameter());
            JsVariableBase.VariableChanger variableHost = new JsVariableBase.VariableChanger(this.getScopeHost().getInternalContext(), scopeRef);
            ArrayList<JsDeclarativeVariable> properties = new ArrayList<JsDeclarativeVariable>(propertyMirrors.size());
            int i = 0;
            while (i < propertyMirrors.size()) {
                String varNameStr = propertyRefs.get(i).getName().toString();
                properties.add(new JsVariableBase.Declarative(valueLoader, propertyMirrors.get(i), varNameStr, variableHost));
                ++i;
            }
            return properties;
        }

        static class DeferredData
        extends DataBase {
            final List<? extends JsDeclarativeVariable> variables;
            private final int cacheState;

            DeferredData(List<? extends JsDeclarativeVariable> variables, int cacheState) {
                this.variables = variables;
                this.cacheState = cacheState;
            }

            @Override
            boolean isCacheObsolete(int newCacheState) {
                return this.cacheState != newCacheState;
            }
        }
    }

    public static abstract class Host {
        public static Host create(final CallFrameImpl callFrameImpl) {
            return new Host(){

                @Override
                InternalContext getInternalContext() {
                    return callFrameImpl.getInternalContext();
                }

                @Override
                ScopeMessage.Host getProtocolParameter() {
                    return ScopeMessage.Host.createFrame(callFrameImpl.getIdentifier());
                }
            };
        }

        public static Host create(final JsFunctionImpl jsFunctionImpl) {
            return new Host(){

                @Override
                InternalContext getInternalContext() {
                    return jsFunctionImpl.getInternalContext();
                }

                @Override
                ScopeMessage.Host getProtocolParameter() {
                    return ScopeMessage.Host.createFunction(jsFunctionImpl.getRef());
                }
            };
        }

        abstract InternalContext getInternalContext();

        abstract ScopeMessage.Host getProtocolParameter();
    }

    private static class ObjectBasedImpl
    extends JsScopeImpl<DeferredData>
    implements JsScope.ObjectBased {
        ObjectBasedImpl(Host host, JsScope.Type type, int scopeIndex) {
            super(host, type, scopeIndex);
        }

        @Override
        public JsScope.Declarative asDeclarativeScope() {
            return null;
        }

        @Override
        public JsScope.ObjectBased asObjectBased() {
            return this;
        }

        @Override
        public <R> R accept(JsScope.Visitor<R> visitor) {
            return visitor.visitObject(this);
        }

        @Override
        protected AsyncFuture.SyncOperation<DeferredData> createLoadDataOperation(final ValueLoaderImpl valueLoader, final int cacheState) {
            return new AsyncFuture.SyncOperation<DeferredData>(){

                @Override
                protected DeferredData runSync() throws MethodIsBlockingException {
                    return this.load(valueLoader, cacheState);
                }
            };
        }

        private DeferredData load(ValueLoaderImpl valueLoader, int cacheState) throws MethodIsBlockingException {
            ObjectValueHandle scopeObject = this.loadScopeObject(valueLoader);
            ValueMirror mirror = valueLoader.addDataToMap((ValueHandle)scopeObject.getSuper());
            JsValueBase jsValue = JsVariableBase.createValue(valueLoader, mirror);
            return new DeferredData(jsValue);
        }

        @Override
        public JsObject getScopeObject() throws MethodIsBlockingException {
            JsObject asObject = ((DeferredData)this.getDeferredData()).jsValue.asObject();
            if (asObject == null) {
                throw new RuntimeException("Received scope object value is not an object");
            }
            return asObject;
        }

        static class DeferredData
        extends DataBase {
            final JsValue jsValue;

            DeferredData(JsValue jsValue) {
                this.jsValue = jsValue;
            }

            @Override
            boolean isCacheObsolete(int newCacheState) {
                return false;
            }
        }
    }
}

