/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.v8native.value;

import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.wst.jsdt.chromium.JsArray;
import org.eclipse.wst.jsdt.chromium.JsFunction;
import org.eclipse.wst.jsdt.chromium.JsVariable;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.JsObjectBase;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.JsVariableBase;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.ValueLoader;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.ValueMirror;
import org.eclipse.wst.jsdt.chromium.util.BasicUtil;
import org.eclipse.wst.jsdt.chromium.util.JavaScriptExpressionBuilder;
import org.eclipse.wst.jsdt.chromium.util.MethodIsBlockingException;

class JsArrayImpl
extends JsObjectBase<ArrayPropertyData>
implements JsArray {
    JsArrayImpl(ValueLoader valueLoader, ValueMirror valueState) {
        super(valueLoader, valueState);
    }

    @Override
    public JsVariable get(long index) throws MethodIsBlockingException {
        return (JsVariable)BasicUtil.getSafe(((ArrayPropertyData)this.getPropertyData(true)).ensureElementsMap(), index);
    }

    @Override
    public SortedMap<Long, ? extends JsVariable> toSparseArray() throws MethodIsBlockingException {
        return ((ArrayPropertyData)this.getPropertyData(true)).ensureElementsMap();
    }

    @Override
    public long getLength() throws MethodIsBlockingException {
        SortedMap map = ((ArrayPropertyData)this.getPropertyData(true)).ensureElementsMap();
        if (map.isEmpty()) {
            return 0L;
        }
        return (Long)map.lastKey() + 1L;
    }

    @Override
    public String toString() {
        SortedMap<Long, ? extends JsVariable> elements;
        try {
            elements = this.toSparseArray();
        }
        catch (MethodIsBlockingException methodIsBlockingException) {
            return "[JsArray: Exception in retrieving data]";
        }
        StringBuilder result = new StringBuilder();
        result.append("[JsArray: length=").append(elements.size());
        for (Map.Entry<Long, ? extends JsVariable> entry : elements.entrySet()) {
            result.append(',').append(entry.getKey()).append('=').append(entry.getValue());
        }
        result.append(']');
        return result.toString();
    }

    @Override
    public JsArrayImpl asArray() {
        return this;
    }

    @Override
    public JsFunction asFunction() {
        return null;
    }

    @Override
    protected ArrayPropertyData wrapBasicData(JsObjectBase.BasicPropertyData basicPropertyData) {
        return new ArrayPropertyData(basicPropertyData);
    }

    @Override
    protected JsObjectBase.BasicPropertyData unwrapBasicData(ArrayPropertyData wrappedBasicData) {
        return wrappedBasicData.getBasicPropertyData();
    }

    static class ArrayPropertyData {
        private final JsObjectBase.BasicPropertyData basicPropertyData;
        private SortedMap<Long, JsVariableBase> indexToElementMap = null;

        ArrayPropertyData(JsObjectBase.BasicPropertyData basicPropertyData) {
            this.basicPropertyData = basicPropertyData;
        }

        JsObjectBase.BasicPropertyData getBasicPropertyData() {
            return this.basicPropertyData;
        }

        private synchronized SortedMap<Long, JsVariableBase> ensureElementsMap() {
            if (this.indexToElementMap == null) {
                TreeMap<Long, JsVariableBase> map = new TreeMap<Long, JsVariableBase>();
                for (JsVariableBase jsVariableBase : this.basicPropertyData.getPropertyList()) {
                    Long key;
                    Object name = jsVariableBase.getRawNameAsObject();
                    if (name instanceof Long) {
                        Long index = (Long)name;
                        if (!JavaScriptExpressionBuilder.checkArrayIndexValue(index)) continue;
                        key = index;
                    } else {
                        key = JavaScriptExpressionBuilder.parsePropertyNameAsArrayIndex(name.toString());
                        if (key == null) continue;
                    }
                    map.put(key, jsVariableBase);
                }
                this.indexToElementMap = Collections.unmodifiableSortedMap(Collections.synchronizedSortedMap(map));
            }
            return this.indexToElementMap;
        }
    }
}

