/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.DynamicParserImpl;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.GeneratedCodeMap;

public class ParserGeneratorBase {
    protected static void mainImpl(String[] args, GenerateConfiguration configuration) {
        Params params = ParserGeneratorBase.parseArgs(args);
        StringBuilder stringBuilder = new StringBuilder();
        ParserGeneratorBase.generateImpl(configuration, stringBuilder);
        String path = configuration.getPackageName().replace('.', '/');
        File directory = new File(String.valueOf(params.outputDirectory()) + "/" + path);
        directory.mkdirs();
        File output = new File(directory, String.valueOf(configuration.getClassName()) + ".java");
        try {
            OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(output));
            ((Writer)writer).append(stringBuilder);
            ((Writer)writer).close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Params parseArgs(String[] args) {
        final StringParam outputDirParam = new StringParam();
        HashMap<String, StringParam> paramMap = new HashMap<String, StringParam>(3);
        paramMap.put("output-dir", outputDirParam);
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String value;
            String key;
            String arg = stringArray[n2];
            if (!arg.startsWith("--")) {
                throw new IllegalArgumentException("Unrecognized param: " + arg);
            }
            int equalsPos = arg.indexOf(61, 2);
            if (equalsPos == -1) {
                key = arg.substring(2).trim();
                value = null;
            } else {
                key = arg.substring(2, equalsPos).trim();
                value = arg.substring(equalsPos + 1).trim();
            }
            ParamListener paramListener = (ParamListener)paramMap.get(key);
            if (paramListener == null) {
                throw new IllegalArgumentException("Unrecognized param name: " + key);
            }
            try {
                paramListener.setValue(value);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Failed to set value of " + key, e);
            }
            ++n2;
        }
        for (Map.Entry en : paramMap.entrySet()) {
            if (((StringParam)en.getValue()).getValue() != null) continue;
            throw new IllegalArgumentException("Parameter " + (String)en.getKey() + " should be set");
        }
        return new Params(){

            @Override
            public String outputDirectory() {
                return outputDirParam.getValue();
            }
        };
    }

    protected static GeneratedCodeMap buildParserMap(GenerateConfiguration configuration) {
        return ParserGeneratorBase.generateImpl(configuration, new StringBuilder());
    }

    private static GeneratedCodeMap generateImpl(GenerateConfiguration configuration, StringBuilder stringBuilder) {
        return configuration.getParserImpl().generateStaticParser(stringBuilder, configuration.getPackageName(), configuration.getClassName(), configuration.getBasePackagesMap());
    }

    protected static class GenerateConfiguration {
        private final String packageName;
        private final String className;
        private final DynamicParserImpl parserImpl;
        private final Collection<GeneratedCodeMap> basePackagesMap;

        public GenerateConfiguration(String packageName, String className, DynamicParserImpl parserImpl) {
            this(packageName, className, parserImpl, Collections.emptyList());
        }

        public GenerateConfiguration(String packageName, String className, DynamicParserImpl parserImpl, Collection<GeneratedCodeMap> basePackagesMap) {
            this.packageName = packageName;
            this.className = className;
            this.parserImpl = parserImpl;
            this.basePackagesMap = basePackagesMap;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public String getClassName() {
            return this.className;
        }

        public DynamicParserImpl getParserImpl() {
            return this.parserImpl;
        }

        public Collection<GeneratedCodeMap> getBasePackagesMap() {
            return this.basePackagesMap;
        }
    }

    private static interface ParamListener {
        public void setValue(String var1);
    }

    private static interface Params {
        public String outputDirectory();
    }

    private static class StringParam
    implements ParamListener {
        private String value = null;

        private StringParam() {
        }

        @Override
        public void setValue(String value) {
            if (value == null) {
                throw new IllegalArgumentException("Argument with value expected");
            }
            if (this.value != null) {
                throw new IllegalArgumentException("Argument value already set");
            }
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

