/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.taglib;

import java.io.File;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsp.core.internal.JSPCorePlugin;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TLDCMDocumentManager;
import org.eclipse.jst.jsp.core.internal.util.FacetModuleCoreSupport;
import org.eclipse.jst.jsp.core.taglib.IJarRecord;
import org.eclipse.jst.jsp.core.taglib.ITLDRecord;
import org.eclipse.jst.jsp.core.taglib.ITagDirRecord;
import org.eclipse.jst.jsp.core.taglib.ITaglibIndexDelta;
import org.eclipse.jst.jsp.core.taglib.ITaglibIndexListener;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecord;
import org.eclipse.jst.jsp.core.taglib.IURLRecord;
import org.eclipse.jst.jsp.core.taglib.ProjectDescription;
import org.eclipse.jst.jsp.core.taglib.TaglibIndexDelta;
import org.eclipse.wst.sse.core.internal.util.AbstractMemoryListener;
import org.osgi.service.event.Event;

public final class TaglibIndex {
    static final boolean _debugChangeListener = false;
    static boolean _debugEvents = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/taglib/events"));
    static boolean _debugIndexCreation = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/taglib/indexcreation"));
    static final boolean _debugResolution = "true".equals(Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/taglib/resolve"));
    static TaglibIndex _instance = new TaglibIndex();
    private boolean initialized;
    private static final CRC32 checksumCalculator = new CRC32();
    private static final String CLEAN = "CLEAN";
    private static final String DIRTY = "DIRTY";
    static boolean ENABLED = false;
    static final ILock LOCK = Job.getJobManager().newLock();
    private ClasspathChangeListener fClasspathChangeListener = null;
    private TaglibIndexDelta fCurrentTopLevelDelta = null;
    Map<IProject, ProjectDescription> fProjectDescriptions = null;
    private ResourceChangeListener fResourceChangeListener;
    private ITaglibIndexListener[] fTaglibIndexListeners = null;
    private MemoryListener fMemoryListener;
    private static final String OSGI_FRAMEWORK_ID = "org.eclipse.osgi";
    private static final QualifiedName STATE_NAME = new QualifiedName("org.eclipse.jst.jsp.core", TaglibIndex.class.getName());

    public static void addTaglibIndexListener(ITaglibIndexListener listener) {
        if (TaglibIndex.getInstance().isInitialized()) {
            TaglibIndex.getInstance().internalAddTaglibIndexListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void fireTaglibDelta(ITaglibIndexDelta delta) {
        ITaglibIndexListener[] listeners;
        if (_debugEvents) {
            Logger.log(1, "TaglibIndex fired delta:" + String.valueOf(delta) + " [" + delta.getAffectedChildren().length + "]\n" + String.valueOf(((TaglibIndexDelta)delta).trigger));
        }
        ITaglibIndexDelta[] deltas = delta.getAffectedChildren();
        int i22 = 0;
        while (i22 < deltas.length) {
            ITaglibRecord taglibRecord = deltas[i22].getTaglibRecord();
            if (taglibRecord != null) {
                Object uniqueIdentifier = TLDCMDocumentManager.getUniqueIdentifier(taglibRecord);
                if (uniqueIdentifier != null) {
                    TLDCMDocumentManager.getSharedDocumentCache().remove(uniqueIdentifier);
                } else {
                    Logger.log(4, "identifier for " + String.valueOf(taglibRecord) + " was null");
                }
            }
            ++i22;
        }
        Map i22 = TLDCMDocumentManager.getSharedDocumentCache();
        synchronized (i22) {
            Iterator values = TLDCMDocumentManager.getSharedDocumentCache().values().iterator();
            while (values.hasNext()) {
                Object o = values.next();
                if (!(o instanceof Reference)) continue;
                values.remove();
            }
        }
        if (_instance.isInitialized() && (listeners = TaglibIndex._instance.fTaglibIndexListeners) != null) {
            int j = 0;
            while (j < listeners.length) {
                try {
                    listeners[j].indexChanged(delta);
                }
                catch (Exception e) {
                    Logger.log(2, e.getMessage());
                }
                ++j;
            }
        }
    }

    public static ITaglibRecord[] getAvailableTaglibRecords(IPath fullPath) {
        if (!_instance.isInitialized()) {
            return new ITaglibRecord[0];
        }
        ITaglibRecord[] records = null;
        records = TaglibIndex.getInstance().isInitialized() ? TaglibIndex.getInstance().internalGetAvailableTaglibRecords(fullPath) : new ITaglibRecord[]{};
        TaglibIndex.getInstance().fireCurrentDelta("enumerate: " + String.valueOf(fullPath));
        return records;
    }

    public static IPath getContextRoot(IPath path) {
        try {
            LOCK.acquire();
            if (TaglibIndex.getInstance().isInitialized()) {
                IPath iPath = TaglibIndex.getInstance().internalGetContextRoot(path);
                return iPath;
            }
        }
        finally {
            LOCK.release();
        }
        return null;
    }

    public static TaglibIndex getInstance() {
        return _instance;
    }

    public static void removeTaglibIndexListener(ITaglibIndexListener listener) {
        if (!TaglibIndex.getInstance().isInitialized()) {
            return;
        }
        if (TaglibIndex.getInstance().isInitialized()) {
            TaglibIndex.getInstance().internalRemoveTaglibIndexListener(listener);
        }
    }

    public static ITaglibRecord resolve(String basePath, String reference, boolean crossProjects) {
        ITaglibRecord result = null;
        if (TaglibIndex.getInstance().isInitialized()) {
            result = TaglibIndex.getInstance().internalResolve(basePath, reference, crossProjects);
        }
        TaglibIndex.getInstance().fireCurrentDelta("resolve: " + reference);
        if (_debugResolution) {
            if (result == null) {
                Logger.log(1, "TaglibIndex could not resolve \"" + reference + "\" from " + basePath);
            } else {
                switch (result.getRecordType()) {
                    case 1: {
                        ITLDRecord record = (ITLDRecord)result;
                        Logger.log(1, "TaglibIndex resolved " + basePath + ":" + reference + " = " + String.valueOf(record.getPath()));
                        break;
                    }
                    case 2: {
                        IJarRecord record = (IJarRecord)result;
                        Logger.log(1, "TaglibIndex resolved " + basePath + ":" + reference + " = " + String.valueOf(record.getLocation()));
                        break;
                    }
                    case 8: {
                        ITagDirRecord record = (ITagDirRecord)result;
                        Logger.log(1, "TaglibIndex resolved " + basePath + ":" + reference + " = " + String.valueOf(record.getPath()));
                        break;
                    }
                    case 4: {
                        IURLRecord record = (IURLRecord)result;
                        Logger.log(1, "TaglibIndex resolved " + basePath + ":" + reference + " = " + String.valueOf(record.getURL()));
                    }
                }
            }
        }
        return result;
    }

    public static void shutdown() {
        try {
            LOCK.acquire();
            if (TaglibIndex.getInstance().isInitialized()) {
                TaglibIndex.getInstance().stop();
            }
        }
        finally {
            LOCK.release();
        }
    }

    public static void startup() {
        boolean shuttingDown;
        boolean bl = shuttingDown = !Platform.isRunning() || Platform.getBundle((String)OSGI_FRAMEWORK_ID).getState() == 16;
        if (!shuttingDown) {
            try {
                LOCK.acquire();
                ENABLED = !"false".equalsIgnoreCase(System.getProperty(TaglibIndex.class.getName()));
                TaglibIndex.getInstance().initializeInstance();
            }
            finally {
                LOCK.release();
            }
        }
    }

    private TaglibIndex() {
    }

    private void initializeInstance() {
        if (this.isInitialized()) {
            return;
        }
        try {
            LOCK.acquire();
            if (!this.isInitialized()) {
                this.getWorkingLocation();
                String savedState = this.getState();
                if (savedState == null) {
                    this.removeIndexes(false);
                } else if (DIRTY.equalsIgnoreCase(savedState)) {
                    Logger.log(4, "A workspace crash was detected. The previous session did not exit normally. Not using saved taglib indexes.");
                    this.removeIndexes(false);
                }
                this.fProjectDescriptions = new Hashtable<IProject, ProjectDescription>();
                this.fResourceChangeListener = new ResourceChangeListener();
                this.fClasspathChangeListener = new ClasspathChangeListener();
                this.fMemoryListener = new MemoryListener();
                if (ENABLED) {
                    ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fResourceChangeListener, 1);
                    JavaCore.addElementChangedListener((IElementChangedListener)this.fClasspathChangeListener);
                    this.fMemoryListener.connect();
                }
                this.setIntialized(true);
            }
        }
        finally {
            LOCK.release();
        }
    }

    synchronized void addDelta(ITaglibIndexDelta delta) {
        this.ensureDelta(delta.getProject()).addChildDelta(delta);
    }

    String computeIndexLocation(IPath containerPath) {
        String fileName = this.computeIndexName(containerPath);
        if (_debugIndexCreation) {
            Logger.log(1, "-> index name for " + String.valueOf(containerPath) + " is " + fileName);
        }
        String indexLocation = this.getTaglibIndexStateLocation().append(fileName).toOSString();
        return indexLocation;
    }

    String computeIndexName(IPath containerPath) {
        checksumCalculator.reset();
        checksumCalculator.update(containerPath.toOSString().getBytes());
        String fileName = Long.toString(checksumCalculator.getValue()) + ".dat";
        return fileName;
    }

    ProjectDescription createDescription(IProject project) {
        if (this.fProjectDescriptions == null) {
            return null;
        }
        ProjectDescription description = null;
        try {
            LOCK.acquire();
            description = this.fProjectDescriptions.get(project);
            if (description == null) {
                if (this.fProjectDescriptions.isEmpty()) {
                    this.setState(DIRTY);
                }
                description = new ProjectDescription(project, this.computeIndexLocation(project.getFullPath()));
                this.fProjectDescriptions.put(project, description);
            }
        }
        finally {
            LOCK.release();
        }
        return description;
    }

    private TaglibIndexDelta ensureDelta(IProject project) {
        if (this.fCurrentTopLevelDelta == null) {
            this.fCurrentTopLevelDelta = new TaglibIndexDelta(project, null, 4);
        }
        return this.fCurrentTopLevelDelta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireCurrentDelta(Object trigger) {
        LOCK.acquire();
        try {
            TaglibIndex taglibIndex = this;
            synchronized (taglibIndex) {
                if (this.fCurrentTopLevelDelta != null) {
                    this.fCurrentTopLevelDelta.trigger = trigger;
                    TaglibIndexDelta delta = this.fCurrentTopLevelDelta;
                    this.fCurrentTopLevelDelta = null;
                    TaglibIndex.fireTaglibDelta(delta);
                }
            }
        }
        finally {
            LOCK.release();
        }
    }

    boolean frameworkIsShuttingDown() {
        boolean shuttingDown = !Platform.isRunning() || Platform.getBundle((String)OSGI_FRAMEWORK_ID).getState() == 16;
        return shuttingDown;
    }

    ProjectDescription getDescription(IProject project) {
        ProjectDescription description = null;
        if (this.isInitialized()) {
            description = this.fProjectDescriptions.get(project);
        }
        return description;
    }

    private String getState() {
        try {
            String state = ResourcesPlugin.getWorkspace().getRoot().getPersistentProperty(STATE_NAME);
            return state;
        }
        catch (CoreException e) {
            Logger.logException(e);
            return DIRTY;
        }
    }

    private IPath getTaglibIndexStateLocation() {
        return JSPCorePlugin.getDefault().getStateLocation().append("taglibindex/");
    }

    private void internalAddTaglibIndexListener(ITaglibIndexListener listener) {
        try {
            LOCK.acquire();
            if (this.fTaglibIndexListeners == null) {
                this.fTaglibIndexListeners = new ITaglibIndexListener[]{listener};
            } else {
                ArrayList<ITaglibIndexListener> listeners = new ArrayList<ITaglibIndexListener>(Arrays.asList(this.fTaglibIndexListeners));
                if (!listeners.contains(listener)) {
                    listeners.add(listener);
                }
                this.fTaglibIndexListeners = listeners.toArray(new ITaglibIndexListener[0]);
            }
        }
        finally {
            LOCK.release();
        }
    }

    private ITaglibRecord[] internalGetAvailableTaglibRecords(IPath path) {
        IProject project;
        ITaglibRecord[] records = new ITaglibRecord[]{};
        if (path.segmentCount() > 0 && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0))).isAccessible()) {
            ProjectDescription description = this.createDescription(project);
            List<ITaglibRecord> availableRecords = description.getAvailableTaglibRecords(path);
            IProject[] projects = FacetModuleCoreSupport.getReferenced(project);
            if (projects != null) {
                int i = 0;
                while (i < projects.length) {
                    if (projects[i].isAccessible()) {
                        ProjectDescription required = this.createDescription(projects[i]);
                        availableRecords.addAll(required.getAvailableTaglibRecords(FacetModuleCoreSupport.getDefaultRootContainer(projects[i])));
                    }
                    ++i;
                }
            }
            records = availableRecords.toArray(records);
        }
        return records;
    }

    private IPath internalGetContextRoot(IPath path) {
        IFile baseResource = FileBuffers.getWorkspaceFileAtLocation((IPath)path);
        if (baseResource != null && baseResource.getProject().isAccessible()) {
            IProject project = baseResource.getProject();
            ProjectDescription description = TaglibIndex.getInstance().createDescription(project);
            IPath rootPath = description.getLocalRoot(baseResource.getFullPath());
            return rootPath;
        }
        IPath root = path.makeAbsolute();
        while (root.segmentCount() > 0 && !root.isRoot()) {
            root = root.removeLastSegments(1);
        }
        return root;
    }

    private void internalRemoveTaglibIndexListener(ITaglibIndexListener listener) {
        try {
            LOCK.acquire();
            if (this.fTaglibIndexListeners != null) {
                ArrayList<ITaglibIndexListener> listeners = new ArrayList<ITaglibIndexListener>(Arrays.asList(this.fTaglibIndexListeners));
                listeners.remove(listener);
                this.fTaglibIndexListeners = listeners.toArray(new ITaglibIndexListener[0]);
            }
        }
        finally {
            LOCK.release();
        }
    }

    private ITaglibRecord internalResolve(String basePath, String reference, boolean crossProjects) {
        IFile[] files;
        IProject project = null;
        ITaglibRecord resolved = null;
        Path baseIPath = new Path(basePath);
        IFile baseResource = FileBuffers.getWorkspaceFileAtLocation((IPath)baseIPath);
        if (baseResource == null) {
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            if (baseIPath.segmentCount() > 1) {
                baseResource = workspaceRoot.getFolder((IPath)baseIPath);
            }
            if (baseResource != null && !baseResource.exists() && baseIPath.segmentCount() > 1) {
                baseResource = workspaceRoot.getFile((IPath)baseIPath);
            }
            if (baseResource == null && baseIPath.segmentCount() == 1) {
                baseResource = workspaceRoot.getProject(baseIPath.segment(0));
            }
        }
        if (baseResource == null && (files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)baseIPath)).length > 0) {
            baseResource = files[0];
        }
        if (baseResource != null) {
            IProject[] projects;
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(baseIPath.segment(0));
            if (project.isAccessible()) {
                ProjectDescription description = this.createDescription(project);
                resolved = description.resolve(basePath, reference);
            }
            if (resolved == null && (projects = FacetModuleCoreSupport.getReferenced(project)) != null) {
                int i = 0;
                while (i < projects.length && resolved == null) {
                    if (projects[i].isAccessible()) {
                        ProjectDescription description = this.createDescription(projects[i]);
                        resolved = description.resolve(basePath, reference);
                    }
                    ++i;
                }
            }
        }
        return resolved;
    }

    boolean isIndexAvailable() {
        return _instance.isInitialized() && ENABLED;
    }

    void removeIndexFile(IProject project) {
        File indexFile = new File(this.computeIndexLocation(project.getFullPath()));
        if (indexFile.exists()) {
            indexFile.delete();
        }
    }

    private void removeIndexes(boolean staleOnly) {
        File folder = this.getWorkingLocation();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<String> indexNames = new ArrayList<String>(projects.length);
        if (staleOnly) {
            int i = 0;
            while (i < projects.length) {
                if (projects[i].isAccessible()) {
                    indexNames.add(this.computeIndexName(projects[i].getFullPath()));
                }
                ++i;
            }
        }
        if (folder.isDirectory()) {
            File[] files = folder.listFiles();
            int i = 0;
            while (files != null && i < files.length) {
                if (!indexNames.contains(files[i].getName())) {
                    files[i].delete();
                }
                ++i;
            }
        }
    }

    private void setState(String state) {
        if (!state.equals(this.getState())) {
            try {
                ResourcesPlugin.getWorkspace().getRoot().setPersistentProperty(STATE_NAME, state);
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        }
    }

    private void stop() {
        if (this.isInitialized()) {
            this.setIntialized(false);
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fResourceChangeListener);
            JavaCore.removeElementChangedListener((IElementChangedListener)this.fClasspathChangeListener);
            this.fMemoryListener.disconnect();
            this.removeIndexes(true);
            this.clearProjectDescriptions();
            this.setState(CLEAN);
            this.fProjectDescriptions = null;
            this.fResourceChangeListener = null;
            this.fClasspathChangeListener = null;
            this.fMemoryListener = null;
        }
    }

    private File getWorkingLocation() {
        File folder = new File(this.getTaglibIndexStateLocation().toOSString());
        if (!folder.isDirectory()) {
            try {
                folder.mkdir();
            }
            catch (SecurityException securityException) {}
        }
        return folder;
    }

    void clearProjectDescriptions() {
        try {
            LOCK.acquire();
            for (ProjectDescription description : this.fProjectDescriptions.values()) {
                description.saveReferences();
            }
            this.fProjectDescriptions.clear();
        }
        finally {
            LOCK.release();
        }
    }

    private boolean isInitialized() {
        return this.initialized;
    }

    private void setIntialized(boolean intialized) {
        this.initialized = intialized;
    }

    class ClasspathChangeListener
    implements IElementChangedListener {
        List<IProject> projectsIndexed = new ArrayList<IProject>(1);

        ClasspathChangeListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            if (!TaglibIndex.this.isIndexAvailable()) {
                return;
            }
            if (_debugEvents) {
                Logger.log(1, "TaglibIndex responding to:" + String.valueOf(event));
            }
            DeltaRunner runner = new DeltaRunner(event);
            this.elementChanged(runner, event.getDelta(), true);
        }

        private void elementChanged(DeltaRunner runner, final IJavaElementDelta delta, final boolean forceUpdate) {
            if (TaglibIndex.this.frameworkIsShuttingDown()) {
                return;
            }
            final IJavaElement element = delta.getElement();
            if (element.getElementType() == 1) {
                IJavaElementDelta[] changed = delta.getAffectedChildren();
                int i = 0;
                while (i < changed.length) {
                    this.elementChanged(runner, changed[i], forceUpdate);
                    ++i;
                }
            } else if (element.getElementType() == 2) {
                if ((delta.getFlags() & 0x20000) != 0) {
                    runner.run(new Runnable(){

                        @Override
                        public void run() {
                            IJavaElement proj = element;
                            ClasspathChangeListener.this.handleClasspathChange((IJavaProject)proj, delta, forceUpdate);
                        }
                    });
                } else {
                    IJavaElementDelta[] deltas = delta.getAffectedChildren();
                    if (deltas.length == 0) {
                        if (delta.getKind() == 2 || (delta.getFlags() & 0x400) != 0) {
                            runner.run(new Runnable(){

                                @Override
                                public void run() {
                                    IJavaProject proj = (IJavaProject)element;
                                    ProjectDescription description = ((ClasspathChangeListener)ClasspathChangeListener.this).TaglibIndex.this.fProjectDescriptions.remove(proj.getProject());
                                    if (description != null) {
                                        if (_debugIndexCreation) {
                                            Logger.log(1, "removing index of " + description.fProject.getName());
                                        }
                                        TaglibIndex.this.removeIndexFile(proj.getProject());
                                    }
                                }
                            });
                        }
                    } else {
                        int i = 0;
                        while (i < deltas.length) {
                            this.elementChanged(runner, deltas[i], false);
                            ++i;
                        }
                    }
                }
            } else if ((delta.getFlags() & 0x40) != 0 || (delta.getFlags() & 0x80) != 0) {
                runner.run(new Runnable(){

                    @Override
                    public void run() {
                        IJavaProject affectedProject = element.getJavaProject();
                        if (affectedProject != null) {
                            ProjectDescription affectedDescription;
                            File indexFile = new File(TaglibIndex.this.computeIndexLocation(affectedProject.getProject().getFullPath()));
                            if (indexFile.exists() && (affectedDescription = TaglibIndex.this.createDescription(affectedProject.getProject())) != null) {
                                affectedDescription.handleElementChanged(delta);
                            }
                            ClasspathChangeListener.this.projectsIndexed.add(affectedProject.getProject());
                        }
                    }
                });
            }
        }

        private void handleClasspathChange(IJavaProject project, IJavaElementDelta delta, boolean forceUpdate) {
            if (TaglibIndex.this.frameworkIsShuttingDown()) {
                return;
            }
            try {
                IResource resource = project.getCorrespondingResource();
                if (resource.getType() == 4 && !this.projectsIndexed.contains(resource)) {
                    ProjectDescription description = null;
                    description = forceUpdate ? TaglibIndex.this.createDescription((IProject)resource) : TaglibIndex.this.getDescription((IProject)resource);
                    if (description != null && !TaglibIndex.this.frameworkIsShuttingDown()) {
                        this.projectsIndexed.add((IProject)resource);
                        description.queueElementChanged(delta);
                    }
                }
            }
            catch (JavaModelException e) {
                Logger.logException(e);
            }
        }

        class DeltaRunner {
            private ElementChangedEvent event;

            public DeltaRunner(ElementChangedEvent event) {
                this.event = event;
            }

            public void run(Runnable runnable) {
                LOCK.acquire();
                try {
                    ClasspathChangeListener.this.projectsIndexed.clear();
                    runnable.run();
                    TaglibIndex.this.fireCurrentDelta(this.event);
                }
                finally {
                    LOCK.release();
                }
            }
        }
    }

    private class MemoryListener
    extends AbstractMemoryListener {
        MemoryListener() {
            super(new String[]{"org/eclipse/equinox/events/MemoryEvent/SERIOUS", "org/eclipse/equinox/events/MemoryEvent/CRITICAL"});
        }

        protected void handleMemoryEvent(Event event) {
            TaglibIndex.this.clearProjectDescriptions();
        }
    }

    class ResourceChangeListener
    implements IResourceChangeListener {
        ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (!TaglibIndex.this.isIndexAvailable()) {
                return;
            }
            try {
                LOCK.acquire();
                if (_debugEvents) {
                    Logger.log(1, "TaglibIndex responding to:" + String.valueOf(event) + "\n" + String.valueOf(event.getDelta()));
                }
                switch (event.getType()) {
                    case 2: 
                    case 4: {
                        ProjectDescription description;
                        int i;
                        IResource resource;
                        IProject[] projects;
                        IResourceDelta[] deltas;
                        try {
                            deltas = new IResourceDelta[]{event.getDelta()};
                            projects = null;
                            if (deltas.length > 0) {
                                resource = null;
                                resource = deltas[0] != null ? deltas[0].getResource() : event.getResource();
                                if (resource != null) {
                                    if (resource.getType() == 8) {
                                        deltas = deltas[0].getAffectedChildren();
                                        projects = new IProject[deltas.length];
                                        i = 0;
                                        while (i < deltas.length) {
                                            if (deltas[i].getResource().getType() == 4) {
                                                projects[i] = (IProject)deltas[i].getResource();
                                            }
                                            ++i;
                                        }
                                    } else {
                                        projects = new IProject[]{resource.getType() != 4 ? resource.getProject() : (IProject)resource};
                                    }
                                }
                                if (projects != null) {
                                    i = 0;
                                    while (i < projects.length) {
                                        if (_debugIndexCreation) {
                                            Logger.log(1, "TaglibIndex noticed " + projects[i].getName() + " is about to be deleted/closed");
                                        }
                                        if ((description = TaglibIndex.this.fProjectDescriptions.remove(projects[i])) != null) {
                                            if (_debugIndexCreation) {
                                                Logger.log(1, "removing index of " + description.fProject.getName());
                                            }
                                            description.clear();
                                        }
                                        ++i;
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            Logger.logException("Exception while processing resource deletion", e);
                        }
                    }
                    case 1: {
                        ProjectDescription description;
                        int i;
                        IResource resource;
                        IProject[] projects;
                        IResourceDelta[] deltas;
                        try {
                            deltas = new IResourceDelta[]{event.getDelta()};
                            projects = null;
                            if (deltas.length <= 0) break;
                            resource = null;
                            resource = deltas[0] != null ? deltas[0].getResource() : event.getResource();
                            if (resource != null) {
                                if (resource.getType() == 8) {
                                    deltas = deltas[0].getAffectedChildren();
                                    projects = new IProject[deltas.length];
                                    i = 0;
                                    while (i < deltas.length) {
                                        if (deltas[i].getResource().getType() == 4) {
                                            projects[i] = (IProject)deltas[i].getResource();
                                        }
                                        ++i;
                                    }
                                } else {
                                    projects = new IProject[]{resource.getType() != 4 ? resource.getProject() : (IProject)resource};
                                }
                            }
                            if (projects == null) break;
                            i = 0;
                            while (i < projects.length) {
                                try {
                                    if (deltas[i] != null && deltas[i].getKind() != 2 && projects[i].isAccessible() && (description = TaglibIndex.this.getDescription(projects[i])) != null && !TaglibIndex.this.frameworkIsShuttingDown()) {
                                        deltas[i].accept(description.getVisitor());
                                    }
                                    if (!projects[i].isAccessible() || deltas[i] != null && deltas[i].getKind() == 2) {
                                        if (_debugIndexCreation) {
                                            Logger.log(1, "TaglibIndex noticed " + projects[i].getName() + " was removed or is no longer accessible");
                                        }
                                        if ((description = TaglibIndex.this.fProjectDescriptions.remove(projects[i])) != null) {
                                            if (_debugIndexCreation) {
                                                Logger.log(1, "removing index of " + description.fProject.getName());
                                            }
                                            description.clear();
                                        }
                                    }
                                }
                                catch (CoreException e) {
                                    Logger.logException(e);
                                }
                                ++i;
                            }
                            break;
                        }
                        catch (Exception e) {
                            Logger.logException("Exception while processing resource change", e);
                        }
                    }
                }
                TaglibIndex.this.fireCurrentDelta(event);
            }
            finally {
                LOCK.release();
            }
        }
    }
}

