/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.java.search;

import java.io.IOException;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jface.text.Position;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.java.IJSPTranslation;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslation;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslationAdapter;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslationExtension;
import org.eclipse.jst.jsp.core.internal.java.search.JSPSearchSupport;
import org.eclipse.jst.jsp.core.internal.modelhandler.ModelHandlerForJSP;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.exceptions.UnsupportedCharsetExceptionWithDetail;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class JSPSearchDocument {
    private String fJSPPathString = null;
    private String fCUPath = null;
    private SearchParticipant fParticipant = null;
    private long fLastModifiedStamp;
    private char[] fCachedCharContents;

    public JSPSearchDocument(String filePath, SearchParticipant participant) {
        this.fJSPPathString = filePath;
        this.fParticipant = participant;
    }

    public SearchParticipant getParticipant() {
        return this.fParticipant;
    }

    public char[] getCharContents() {
        if (this.fCachedCharContents == null || this.isDirty()) {
            JSPTranslationExtension trans = this.getJSPTranslation();
            this.fCachedCharContents = trans != null ? ((JSPTranslation)trans).getJavaText().toCharArray() : new char[]{};
            this.fCUPath = trans.getJavaPath();
        }
        return this.fCachedCharContents;
    }

    public String getJavaText() {
        return new String(this.getCharContents());
    }

    private IModelManager getModelManager() {
        return StructuredModelManager.getModelManager();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final JSPTranslationExtension getJSPTranslation() {
        JSPTranslationExtension translation = null;
        IFile jspFile = this.getFile();
        if (!JSPSearchSupport.isJsp(jspFile)) {
            return translation;
        }
        IStructuredModel model = null;
        try {
            try {
                IModelManager modelManager = this.getModelManager();
                if (modelManager != null) {
                    jspFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                    model = modelManager.getModelForRead(jspFile);
                }
                if (!(model instanceof IDOMModel)) return translation;
                IDOMModel xmlModel = (IDOMModel)model;
                this.setupAdapterFactory((IStructuredModel)xmlModel);
                IDOMDocument doc = xmlModel.getDocument();
                JSPTranslationAdapter adapter = (JSPTranslationAdapter)doc.getAdapterFor(IJSPTranslation.class);
                translation = adapter.getJSPTranslation();
                return translation;
            }
            catch (IOException e) {
                Logger.logException(e);
                if (model == null) return translation;
                model.releaseFromRead();
                return translation;
            }
            catch (CoreException e) {
                Logger.logException(e);
                if (model == null) return translation;
                model.releaseFromRead();
                return translation;
            }
            catch (UnsupportedCharsetExceptionWithDetail unsupportedCharsetExceptionWithDetail) {
                if (model == null) return translation;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                model.releaseFromRead();
                return translation;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    private void setupAdapterFactory(IStructuredModel sm) {
        ModelHandlerForJSP.ensureTranslationAdapterFactory(sm);
    }

    public String getPath() {
        JSPTranslationExtension trans;
        if ((this.fCUPath == null || this.isDirty()) && (trans = this.getJSPTranslation()) != null) {
            this.fCUPath = trans.getJavaPath();
            this.fCachedCharContents = ((JSPTranslation)trans).getJavaText().toCharArray();
        }
        return this.fCUPath;
    }

    public int getJspOffset(int javaOffset) {
        int result = -1;
        int offsetInRange = 0;
        Position javaPos2 = null;
        JSPTranslationExtension trans = this.getJSPTranslation();
        if (trans != null) {
            Map<Position, Position> java2jspMap = trans.getJava2JspMap();
            for (Position javaPos2 : java2jspMap.keySet()) {
                if (!javaPos2.includes(javaOffset) && javaPos2.offset + javaPos2.length != javaOffset) continue;
                offsetInRange = javaOffset - javaPos2.offset;
                Position jspPos = java2jspMap.get(javaPos2);
                if (jspPos != null) {
                    result = jspPos.offset + offsetInRange;
                    break;
                }
                Logger.log(4, "jspPosition was null!" + javaOffset);
                break;
            }
        }
        return result;
    }

    public IFile getFile() {
        Path jspPath;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile jspFile = root.getFile((IPath)(jspPath = new Path(this.fJSPPathString)));
        if (!jspFile.exists()) {
            jspFile = root.getFileForLocation((IPath)jspPath);
        }
        return jspFile;
    }

    private boolean isDirty() {
        boolean modified = false;
        IFile f = this.getFile();
        if (f != null) {
            long currentStamp = f.getModificationStamp();
            if (currentStamp != this.fLastModifiedStamp) {
                modified = true;
            }
            this.fLastModifiedStamp = currentStamp;
        }
        return modified;
    }

    public void release() {
    }

    public String toString() {
        return "[JSPSearchDocument:" + this.fJSPPathString + "]";
    }

    public String getEncoding() {
        return null;
    }

    public byte[] getByteContents() {
        return null;
    }
}

