/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.core.internal;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.server.core.IJavaRuntime;
import org.eclipse.jst.server.generic.core.internal.CorePlugin;
import org.eclipse.jst.server.generic.core.internal.GenericServerCoreMessages;
import org.eclipse.jst.server.generic.servertype.definition.ArchiveType;
import org.eclipse.jst.server.generic.servertype.definition.Classpath;
import org.eclipse.jst.server.generic.servertype.definition.Property;
import org.eclipse.jst.server.generic.servertype.definition.ServerRuntime;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.model.RuntimeDelegate;

public class GenericServerRuntime
extends RuntimeDelegate
implements IJavaRuntime {
    public static final String SERVER_DEFINITION_ID = "server_definition_id";
    public static final String SERVER_INSTANCE_PROPERTIES = "generic_server_instance_properties";
    private static final String PROP_VM_INSTALL_TYPE_ID = "vm-install-type-id";
    private static final String PROP_VM_INSTALL_ID = "vm-install-id";

    public String getVMInstallTypeId() {
        return this.getAttribute(PROP_VM_INSTALL_TYPE_ID, null);
    }

    public boolean isUsingDefaultJRE() {
        return this.getVMInstallTypeId() == null;
    }

    public String getVMInstallId() {
        return this.getAttribute(PROP_VM_INSTALL_ID, null);
    }

    public IVMInstall getVMInstall() {
        if (this.getVMInstallTypeId() == null) {
            return JavaRuntime.getDefaultVMInstall();
        }
        try {
            IVMInstallType vmInstallType = JavaRuntime.getVMInstallType((String)this.getVMInstallTypeId());
            IVMInstall[] vmInstalls = vmInstallType.getVMInstalls();
            int size = vmInstalls.length;
            String id = this.getVMInstallId();
            int i = 0;
            while (i < size) {
                if (id.equals(vmInstalls[i].getId())) {
                    return vmInstalls[i];
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public IStatus validate() {
        if (this.getVMInstall() == null) {
            return new Status(4, "org.eclipse.jst.server.generic.core", 0, GenericServerCoreMessages.errorJRE, null);
        }
        ServerRuntime serverTypeDefinition = this.getServerTypeDefinition();
        if (serverTypeDefinition == null) {
            return new Status(4, "org.eclipse.jst.server.generic.core", 0, GenericServerCoreMessages.errorNoServerType, null);
        }
        if (serverTypeDefinition.getClasspath() == null || serverTypeDefinition.getClasspath().size() < 1) {
            return new Status(4, "org.eclipse.jst.server.generic.core", 0, GenericServerCoreMessages.errorNoClasspath, null);
        }
        return this.validateClasspaths(serverTypeDefinition);
    }

    protected IStatus validateClasspaths(ServerRuntime serverTypeDefinition) {
        for (Classpath cpth : serverTypeDefinition.getClasspath()) {
            if (cpth.getArchive() == null || cpth.getArchive().size() < 1) {
                return new Status(4, "org.eclipse.jst.server.generic.core", 0, GenericServerCoreMessages.errorNoClasspath, null);
            }
            for (ArchiveType arch : cpth.getArchive()) {
                String arcPath = serverTypeDefinition.getResolver().resolveProperties(arch.getPath());
                File f = new File(arcPath);
                if (f.exists()) continue;
                return new Status(4, "org.eclipse.jst.server.generic.core", 0, NLS.bind((String)GenericServerCoreMessages.errorMissingClasspathEntry, (Object)f.getPath()), null);
            }
        }
        return new Status(0, "org.eclipse.jst.server.generic.core", 0, "", null);
    }

    public ServerRuntime getServerTypeDefinition() {
        String id = this.getRuntime().getRuntimeType().getId();
        Map properties = this.getAttribute(SERVER_INSTANCE_PROPERTIES, null);
        if (id == null) {
            return null;
        }
        return CorePlugin.getDefault().getServerTypeDefinitionManager().getServerRuntimeDefinition(id, properties);
    }

    public void setVMInstall(IVMInstall vmInstall) {
        if (vmInstall == null) {
            this.setVMInstall(null, null);
        } else {
            this.setVMInstall(vmInstall.getVMInstallType().getId(), vmInstall.getId());
        }
    }

    private void setVMInstall(String typeId, String id) {
        if (typeId == null) {
            this.setAttribute(PROP_VM_INSTALL_TYPE_ID, null);
        } else {
            this.setAttribute(PROP_VM_INSTALL_TYPE_ID, typeId);
        }
        if (id == null) {
            this.setAttribute(PROP_VM_INSTALL_ID, null);
        } else {
            this.setAttribute(PROP_VM_INSTALL_ID, id);
        }
    }

    public Map getServerInstanceProperties() {
        return this.getAttribute(SERVER_INSTANCE_PROPERTIES, new HashMap());
    }

    public String getServerDefinitionId() {
        return this.getAttribute(SERVER_DEFINITION_ID, null);
    }

    public void setServerInstanceProperties(Map map) {
        this.setAttribute(SERVER_INSTANCE_PROPERTIES, map);
    }

    public void setServerDefinitionId(String s) {
        this.setAttribute(SERVER_DEFINITION_ID, s);
    }

    public void setDefaults(IProgressMonitor monitor) {
        EList<Property> props = this.getServerTypeDefinition().getProperty();
        HashMap<String, String> instancePropsMap = new HashMap<String, String>();
        for (Property element : props) {
            if (!"runtime".equalsIgnoreCase(element.getContext())) continue;
            instancePropsMap.put(element.getId(), element.getDefault());
        }
        this.setServerInstanceProperties(instancePropsMap);
    }
}

