/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.ui.internal.preferences;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.jsf.common.internal.policy.OrderedListProvider;
import org.eclipse.jst.jsf.common.ui.internal.preferences.OrderingMessages;
import org.eclipse.jst.jsf.common.ui.internal.utils.PixelConverter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class StrategyOrderingPanel {
    private CheckboxTableViewer _viewer;
    private Button fUpButton;
    private Button fDownButton;
    private final OrderedListProvider _provider;
    private final ITableLabelProvider _labelProvider;
    private final String _title;

    public StrategyOrderingPanel(OrderedListProvider provider, ITableLabelProvider labelProvider, String title) {
        this._provider = provider;
        this._labelProvider = labelProvider;
        this._title = title;
    }

    public Control createContents(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        panel.setLayout((Layout)layout);
        Label titleLabel = new Label(panel, 0);
        titleLabel.setText(this._title);
        GridData gridData = new GridData(4, 1, true, false, 2, 1);
        titleLabel.setLayoutData((Object)gridData);
        this.createTableViewer(panel);
        this.createButtonList(panel);
        return panel;
    }

    public void refresh() {
        this._provider.resetOrderedObjects();
        this._viewer.refresh();
        for (OrderedListProvider.OrderableObject object : this._provider.getOrderedObjects()) {
            this._viewer.setChecked((Object)object, object.isEnabled());
        }
    }

    private void createTableViewer(Composite parent) {
        this._viewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2052);
        Table table = this._viewer.getTable();
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
        table.setLayoutData((Object)new GridData(4, 1, true, false, 1, 1));
        TableColumn nameColumn = new TableColumn(table, 0);
        nameColumn.setResizable(false);
        this._viewer.setContentProvider((IContentProvider)new ContentProvider());
        this._viewer.setLabelProvider((IBaseLabelProvider)this._labelProvider);
        this._viewer.setInput((Object)this._provider);
        int minNameWidth = this.computeWidth((Control)table, nameColumn.getText()) + 20;
        int i = 0;
        while (i < this._provider.getOrderedObjects().size()) {
            minNameWidth = Math.max(minNameWidth, this.computeWidth((Control)table, this._labelProvider.getColumnText(this._provider.getOrderedObjects().get(i), 0)) + 50);
            ++i;
        }
        nameColumn.setWidth(minNameWidth);
        this._viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                boolean checked = event.getChecked();
                OrderedListProvider.OrderableObject element = (OrderedListProvider.OrderableObject)event.getElement();
                element.setEnabled(checked);
            }
        });
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StrategyOrderingPanel.this.handleTableSelection();
            }
        });
    }

    private void createButtonList(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1, 1, false, false));
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.fUpButton = new Button(composite, 0x1000008);
        this.fUpButton.setText(OrderingMessages.Ordering_Up);
        this.fUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = StrategyOrderingPanel.this.getSelectionIndex();
                if (index != -1) {
                    OrderedListProvider.OrderableObject object = (OrderedListProvider.OrderableObject)StrategyOrderingPanel.this._provider.getOrderedObjects().get(index);
                    StrategyOrderingPanel.this._provider.moveUp(object);
                    StrategyOrderingPanel.this._viewer.refresh();
                    StrategyOrderingPanel.this.handleTableSelection();
                }
            }
        });
        this.fUpButton.setLayoutData((Object)new GridData());
        StrategyOrderingPanel.setButtonDimensionHint(this.fUpButton);
        this.fDownButton = new Button(composite, 0x1000008);
        this.fDownButton.setText(OrderingMessages.Ordering_Down);
        this.fDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = StrategyOrderingPanel.this.getSelectionIndex();
                if (index != -1) {
                    OrderedListProvider.OrderableObject object = (OrderedListProvider.OrderableObject)StrategyOrderingPanel.this._provider.getOrderedObjects().get(index);
                    StrategyOrderingPanel.this._provider.moveDown(object);
                    StrategyOrderingPanel.this._viewer.refresh();
                    StrategyOrderingPanel.this.handleTableSelection();
                }
            }
        });
        this.fDownButton.setLayoutData((Object)new GridData());
        StrategyOrderingPanel.setButtonDimensionHint(this.fDownButton);
    }

    private int computeWidth(Control control, String name) {
        if (name == null) {
            return 0;
        }
        GC gc = new GC((Drawable)control);
        try {
            gc.setFont(JFaceResources.getDialogFont());
            int n = gc.stringExtent((String)name).x + 10;
            return n;
        }
        finally {
            gc.dispose();
        }
    }

    private void handleTableSelection() {
        OrderedListProvider.OrderableObject item = this.getSelectedItem();
        if (item != null) {
            int index = this.getSelectionIndex();
            this.fUpButton.setEnabled(index > 0);
            this.fDownButton.setEnabled(index < this._provider.getOrderedObjects().size() - 1);
        } else {
            this.fUpButton.setEnabled(false);
            this.fDownButton.setEnabled(false);
        }
    }

    private OrderedListProvider.OrderableObject getSelectedItem() {
        return (OrderedListProvider.OrderableObject)((IStructuredSelection)this._viewer.getSelection()).getFirstElement();
    }

    private int getSelectionIndex() {
        return this._viewer.getTable().getSelectionIndex();
    }

    private static int getButtonWidthHint(Button button) {
        button.setFont(JFaceResources.getDialogFont());
        PixelConverter converter = new PixelConverter((Control)button);
        int widthHint = converter.convertHorizontalDLUsToPixels(61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    private static void setButtonDimensionHint(Button button) {
        Assert.isNotNull((Object)button);
        Object gd = button.getLayoutData();
        if (gd instanceof GridData) {
            ((GridData)gd).widthHint = StrategyOrderingPanel.getButtonWidthHint(button);
            ((GridData)gd).horizontalAlignment = 4;
        }
    }

    private static class ContentProvider
    implements IStructuredContentProvider {
        private ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof OrderedListProvider) {
                return ((OrderedListProvider)inputElement).getOrderedObjects().toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

