/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DOMUtil {
    public static List getChildElementsByTagIgnoreCase(Element parent, String tag) {
        ArrayList<Node> ret = new ArrayList<Node>();
        NodeList nodeList = parent.getChildNodes();
        int i = 0;
        int size = nodeList.getLength();
        while (i < size) {
            String t;
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1 && tag.equalsIgnoreCase(t = node.getNodeName())) {
                ret.add(node);
            }
            ++i;
        }
        return ret;
    }

    public static String getTextElementValue(Element ele) {
        StringBuffer buffer = new StringBuffer();
        Node node = ele.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 3) {
                buffer.append(node.getNodeValue());
            } else if (node.getNodeType() == 4) {
                buffer.append(node.getNodeValue());
            }
            node = node.getNextSibling();
        }
        return buffer.toString();
    }

    public static String getAttributeIgnoreCase(Element element, String string) {
        NamedNodeMap map = element.getAttributes();
        int i = 0;
        while (i < map.getLength()) {
            Node attr = map.item(i);
            if (string.equalsIgnoreCase(attr.getNodeName())) {
                return attr.getNodeValue();
            }
            ++i;
        }
        return null;
    }

    public static List getChildrenByTagsIgnoreCase(Element parent, String[] tags) {
        ArrayList<Node> result = new ArrayList<Node>();
        NodeList nodeList = parent.getChildNodes();
        int i = 0;
        int size = nodeList.getLength();
        while (i < size) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                String t = node.getNodeName();
                int k = 0;
                while (k < tags.length) {
                    if (tags[k].equalsIgnoreCase(t)) {
                        result.add(node);
                        break;
                    }
                    ++k;
                }
            }
            ++i;
        }
        return result;
    }

    public static void removeAllChildren(Element ele) {
        ((ElementImpl)ele).removeChildNodes();
    }

    public static void setTextElementValue(Element ele, String value) {
        DOMUtil.removeAllChildren(ele);
        Text txt = ele.getOwnerDocument().createTextNode(value);
        ele.appendChild(txt);
    }

    public static int getIntAttributeIgnoreCase(Element ele, String attr, int defaultvalue) {
        if (ele == null) {
            return defaultvalue;
        }
        String attrvalue = DOMUtil.getAttributeIgnoreCase(ele, attr);
        if (attrvalue == null) {
            return defaultvalue;
        }
        try {
            return Integer.parseInt(attrvalue);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultvalue;
        }
    }

    public static List getElementChildren(Element ele) {
        ArrayList<Node> ret = new ArrayList<Node>();
        NodeList nodeList = ele.getChildNodes();
        int i = 0;
        int size = nodeList.getLength();
        while (i < size) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                ret.add(node);
            }
            ++i;
        }
        return ret;
    }

    public static boolean hasAttribute(Element ele, String attrName) {
        NamedNodeMap map = ele.getAttributes();
        int i = 0;
        while (i < map.getLength()) {
            Node attr = map.item(i);
            if (attr.getNodeName().equalsIgnoreCase(attrName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void nodeToString(Node node, StringBuffer sb) {
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                sb.append("<?xml version=\"1.0\" ?>");
                DOMUtil.nodeToString(((Document)node).getDocumentElement(), sb);
                break;
            }
            case 1: {
                sb.append("<");
                sb.append(node.getNodeName());
                NamedNodeMap attrs = node.getAttributes();
                int i = 0;
                while (i < attrs.getLength()) {
                    Node attr = attrs.item(i);
                    sb.append(" " + attr.getNodeName() + "=\"" + attr.getNodeValue() + "\"");
                    ++i;
                }
                NodeList children = node.getChildNodes();
                if (children == null) break;
                int len = children.getLength();
                if (len != 0) {
                    sb.append(">");
                }
                int i2 = 0;
                while (i2 < len) {
                    DOMUtil.nodeToString(children.item(i2), sb);
                    ++i2;
                }
                break;
            }
            case 5: {
                sb.append("&");
                sb.append(node.getNodeName());
                sb.append(";");
                break;
            }
            case 4: {
                sb.append("<![CDATA[");
                sb.append(node.getNodeValue());
                sb.append("]]>");
                break;
            }
            case 3: {
                sb.append(node.getNodeValue());
                break;
            }
            case 7: {
                sb.append("<?");
                sb.append(node.getNodeName());
                String data = node.getNodeValue();
                sb.append(" ");
                sb.append(data);
                sb.append("?>");
            }
        }
        if (type == 1) {
            if (node.getFirstChild() != null) {
                sb.append("</");
                sb.append(node.getNodeName());
                sb.append(">");
            } else {
                sb.append("/>");
            }
        }
    }
}

