/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.layout;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jst.pagedesigner.css2.layout.CSSBlockFlowLayout;
import org.eclipse.jst.pagedesigner.css2.layout.CSSFigure;
import org.eclipse.jst.pagedesigner.css2.layout.ICSSPainter;
import org.eclipse.jst.pagedesigner.css2.layout.WidgetBox;
import org.eclipse.jst.pagedesigner.css2.provider.DimensionInfo;
import org.eclipse.jst.pagedesigner.css2.provider.ICSSWidgetProvider;

public class CSSWidgetLayout
extends CSSBlockFlowLayout
implements ICSSPainter {
    private WidgetBox _widgetBox;
    private ICSSWidgetProvider _provider;

    public CSSWidgetLayout(CSSFigure flowfigure, ICSSWidgetProvider provider) {
        super(flowfigure);
        this._provider = provider;
    }

    public void setProvider(ICSSWidgetProvider provider) {
        this._provider = provider;
    }

    public ICSSWidgetProvider getProvider() {
        return this._provider;
    }

    @Override
    public boolean isInlineBlock() {
        ICSSWidgetProvider provider = this.getProvider();
        return provider.isInline();
    }

    @Override
    protected void layoutChildren() {
        ICSSWidgetProvider provider = this.getProvider();
        int suggestedWith = this._blockBox.getContentWidth();
        int suggestedHeight = this._blockBox.getContentHeight();
        DimensionInfo resultInfo = provider.getPreferredDimension(suggestedWith, suggestedHeight);
        Dimension resultSize = resultInfo.getDimension();
        this._widgetBox = new WidgetBox();
        this._widgetBox.setWidth(resultSize.width);
        this._widgetBox.setHeight(resultSize.height);
        this._widgetBox.setAscent(resultInfo.getAscent());
        this.addToCurrentLine(this._widgetBox);
    }

    @Override
    public void dispose() {
    }

    @Override
    public void paintFigure(Graphics g) {
        ICSSWidgetProvider provider = this.getProvider();
        if (provider != null && this._widgetBox != null) {
            provider.paintFigure(g, new Rectangle(this._widgetBox._x, this._widgetBox._y, this._widgetBox.getWidth(), this._widgetBox.getHeight()));
        }
    }

    @Override
    public boolean handlingBorderForBlock() {
        ICSSWidgetProvider provider = this.getProvider();
        if (provider != null) {
            return provider.isHandlingBorder();
        }
        return super.handlingBorderForBlock();
    }
}

