/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.internal.contentassist.CustomCompletionProposal;
import org.eclipse.wst.xsl.core.XSLCore;
import org.eclipse.wst.xsl.core.model.StylesheetModel;
import org.eclipse.wst.xsl.core.model.Template;
import org.eclipse.wst.xsl.core.model.XSLAttribute;
import org.eclipse.wst.xsl.ui.internal.Messages;
import org.eclipse.wst.xsl.ui.internal.util.XSLPluginImageHelper;
import org.eclipse.wst.xsl.ui.provisional.contentassist.AbstractXSLContentAssistRequest;
import org.w3c.dom.Node;

public class CallTemplateContentAssistRequest
extends AbstractXSLContentAssistRequest {
    private static final String ATTR_MODE = "mode";
    private static final String ATTR_NAME = "name";

    public CallTemplateContentAssistRequest(Node node, IStructuredDocumentRegion documentRegion, ITextRegion completionRegion, int begin, int length, String filter, ITextViewer textViewer) {
        super(node, documentRegion, completionRegion, begin, length, filter, textViewer);
    }

    @Override
    public ArrayList<ICompletionProposal> getCompletionProposals() {
        this.proposals.clear();
        IFile editorFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.getLocation()));
        StylesheetModel model = XSLCore.getInstance().getStylesheet(editorFile);
        List templates = model.getTemplates();
        for (Template template : templates) {
            XSLAttribute attribute = template.getAttribute(ATTR_NAME);
            if (attribute == null) continue;
            String proposalInfo = this.getAdditionalInfo(template);
            CustomCompletionProposal proposal = new CustomCompletionProposal(attribute.getValue(), this.getStartOffset() + 1, 0, attribute.getValue().length(), XSLPluginImageHelper.getInstance().getImage("icons/full/template.gif"), attribute.getValue(), null, proposalInfo, 0);
            this.addProposal((ICompletionProposal)proposal);
        }
        return this.getAllCompletionProposals();
    }

    protected String getAdditionalInfo(Template template) {
        XSLAttribute nameAttribute = template.getAttribute(ATTR_NAME);
        String proposalInfo = String.valueOf(Messages.CallTemplateContentAssistTemplateName) + nameAttribute.getValue() + "\r\n" + Messages.CallTemplateContentAssistTemplateNameFile + template.getStylesheet().getFile().getName();
        return proposalInfo;
    }
}

