/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.internal.contentassist;

import java.util.ArrayList;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xsl.ui.internal.contentassist.SelectAttributeContentAssist;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AttributeContentAssist
extends SelectAttributeContentAssist {
    public AttributeContentAssist(Node node, IStructuredDocumentRegion documentRegion, ITextRegion completionRegion, int begin, int length, String filter, ITextViewer textViewer) {
        super(node, documentRegion, completionRegion, begin, length, filter, textViewer);
    }

    @Override
    public ArrayList<ICompletionProposal> getCompletionProposals() {
        int offset = this.getReplacementBeginPosition();
        IDOMAttr attrNode = this.getAttributeAtOffset(offset);
        if (attrNode == null || !this.matchString.contains("{")) {
            return this.getAllCompletionProposals();
        }
        this.adjustXPathStart(attrNode.getLocalName());
        offset = this.getReplacementBeginPosition();
        this.matchString = this.extractXPathMatchString(attrNode, this.getRegion(), this.getReplacementBeginPosition());
        this.addSelectProposals((Element)this.getNode().getParentNode(), offset);
        return this.getAllCompletionProposals();
    }

    private IDOMAttr getAttributeAtOffset(int offset) {
        Node node = this.getNode();
        if (node == null) {
            return null;
        }
        NamedNodeMap nodeMap = node.getAttributes();
        IDOMAttr attrNode = null;
        int i = 0;
        while (i < nodeMap.getLength()) {
            IDOMAttr tmpAttr = (IDOMAttr)nodeMap.item(i);
            int start = tmpAttr.getStartOffset();
            int end = tmpAttr.getEndOffset();
            if (start <= offset || end > offset) {
                attrNode = tmpAttr;
                break;
            }
            ++i;
        }
        return attrNode;
    }
}

