/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.project.facet.core.libprov.osgi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderOperationConfig;
import org.eclipse.jst.common.project.facet.core.libprov.osgi.BundleReference;
import org.eclipse.jst.common.project.facet.core.libprov.osgi.OsgiBundlesContainer;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class OsgiBundlesLibraryProviderInstallOperationConfig
extends LibraryProviderOperationConfig {
    private static final String PARAM_CONTAINER_LABEL = "container.label";
    private static final String PARAM_BUNDLE = "bundle.";
    private String containerLabelOverride = null;
    private List<BundleReference> bundleReferences = new ArrayList<BundleReference>();
    private List<BundleReference> bundleReferencesReadOnly = Collections.unmodifiableList(this.bundleReferences);

    @Override
    public synchronized void init(IFacetedProjectBase fproj, IProjectFacetVersion fv, ILibraryProvider provider) {
        super.init(fproj, fv, provider);
        this.containerLabelOverride = provider.getParams().get(PARAM_CONTAINER_LABEL);
        this.bundleReferences.addAll(OsgiBundlesLibraryProviderInstallOperationConfig.getBundleReferences(provider));
    }

    public List<BundleReference> getBundleReferences() {
        return this.bundleReferencesReadOnly;
    }

    public static List<BundleReference> getBundleReferences(ILibraryProvider provider) {
        String unparsedBundleReference;
        ArrayList<BundleReference> bundleReferences = new ArrayList<BundleReference>();
        Map<String, String> params = provider.getParams();
        int i = 0;
        while ((unparsedBundleReference = params.get(PARAM_BUNDLE + String.valueOf(i))) != null) {
            bundleReferences.add(OsgiBundlesContainer.parseBundleReference(unparsedBundleReference));
            ++i;
        }
        return bundleReferences;
    }

    public IClasspathAttribute[] getClasspathAttributes() {
        return null;
    }

    public String getContainerLabel() {
        return this.containerLabelOverride;
    }

    @Override
    public IStatus validate() {
        IStatus status = super.validate();
        for (BundleReference bundleReference : this.bundleReferences) {
            if (bundleReference.isResolvable()) continue;
            String bundleId = bundleReference.getBundleId();
            VersionRange versionRange = bundleReference.getVersionRange();
            String msg = versionRange == null ? NLS.bind((String)Resources.bunldeCannotBeResolvedNoVersion, (Object)bundleId) : NLS.bind((String)Resources.bundleCannotBeResolved, (Object)bundleId, (Object)versionRange.toString());
            status = new Status(4, "org.eclipse.jst.common.project.facet.core", msg);
            break;
        }
        return status;
    }

    private static final class Resources
    extends NLS {
        public static String bundleCannotBeResolved;
        public static String bunldeCannotBeResolvedNoVersion;

        static {
            Resources.initializeMessages((String)OsgiBundlesLibraryProviderInstallOperationConfig.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

