/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.extensions.ExtensibilityElement;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcessVisitor;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversal;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversalContext;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.w3c.dom.Element;

public class BP2123
extends AssertionProcessVisitor
implements WSITag {
    private final WSDLValidatorImpl validator;
    private boolean claimFound = false;
    private static final String PORT_KEY = "port";
    private static final String BINDING_KEY = "binding";
    private static final String PORT_TYPE_KEY = "port type";
    private static final String OPERATION_KEY = "operation";
    private static final String MESSAGE_KEY = "message";

    public BP2123(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    @Override
    public void visit(Port port, Object parent, WSDLTraversalContext ctx) {
        if (port != null) {
            if (this.containsLegalClaim(port.getDocumentationElement())) {
                this.claimFound = true;
                ctx.addParameter(PORT_KEY, Boolean.TRUE);
            } else {
                ctx.addParameter(PORT_KEY, Boolean.FALSE);
            }
        }
    }

    @Override
    public void visit(Binding binding, Object parent, WSDLTraversalContext ctx) {
        if (binding != null) {
            Boolean port = (Boolean)ctx.getParameter(PORT_KEY);
            if (port.booleanValue()) {
                ctx.addParameter(BINDING_KEY, Boolean.TRUE);
            } else {
                this.claimFound = this.containsClaim(binding.getDocumentationElement());
                ctx.addParameter(BINDING_KEY, new Boolean(this.containsLegalClaim(binding.getDocumentationElement())));
            }
        }
    }

    @Override
    public void visit(PortType type, Object parent, WSDLTraversalContext ctx) {
        if (type != null) {
            Boolean binding = (Boolean)ctx.getParameter(BINDING_KEY);
            if (binding.booleanValue()) {
                ctx.addParameter(PORT_TYPE_KEY, Boolean.TRUE);
            } else {
                this.claimFound = this.containsClaim(type.getDocumentationElement());
                ctx.addParameter(PORT_TYPE_KEY, new Boolean(this.containsLegalClaim(type.getDocumentationElement())));
            }
        }
    }

    @Override
    public void visit(Operation operation, Object parent, WSDLTraversalContext ctx) {
        if (operation != null) {
            Boolean type = (Boolean)ctx.getParameter(PORT_TYPE_KEY);
            if (type.booleanValue()) {
                ctx.addParameter(OPERATION_KEY, Boolean.TRUE);
            } else {
                this.claimFound = this.containsClaim(operation.getDocumentationElement());
                ctx.addParameter(OPERATION_KEY, new Boolean(this.containsLegalClaim(operation.getDocumentationElement())));
            }
        }
    }

    @Override
    public void visit(Message message, Object parent, WSDLTraversalContext ctx) {
        if (message != null) {
            Boolean operation = (Boolean)ctx.getParameter(OPERATION_KEY);
            if (operation.booleanValue()) {
                ctx.addParameter(MESSAGE_KEY, Boolean.TRUE);
            } else {
                this.claimFound = this.containsClaim(message.getDocumentationElement());
                ctx.addParameter(MESSAGE_KEY, new Boolean(this.containsLegalClaim(message.getDocumentationElement())));
            }
        }
    }

    @Override
    public void visit(ExtensibilityElement el, Object parent, WSDLTraversalContext ctx) {
        boolean required;
        boolean bl = required = el != null && el.getRequired() != null && el.getRequired() != false;
        if (this.isParentConforms(parent, ctx) && required) {
            this.result = "warning";
            this.failureDetailMessage = el.toString();
        }
    }

    private boolean isParentConforms(Object parent, WSDLTraversalContext ctx) {
        boolean result = false;
        if (parent instanceof Port) {
            result = (Boolean)ctx.getParameter(PORT_KEY);
        } else if (parent instanceof Binding || parent instanceof BindingOperation || parent instanceof BindingInput || parent instanceof BindingOutput || parent instanceof BindingFault) {
            result = (Boolean)ctx.getParameter(BINDING_KEY);
        } else if (parent instanceof PortType) {
            result = (Boolean)ctx.getParameter(PORT_TYPE_KEY);
        } else if (parent instanceof Operation || parent instanceof Input || parent instanceof Output || parent instanceof Fault) {
            result = (Boolean)ctx.getParameter(OPERATION_KEY);
        } else if (parent instanceof Message || parent instanceof Part) {
            result = (Boolean)ctx.getParameter(MESSAGE_KEY);
        }
        return result;
    }

    @Override
    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "passed";
        Definition def = (Definition)entryContext.getEntry().getEntryDetail();
        WSDLTraversal traversal = new WSDLTraversal();
        traversal.setVisitor(this);
        traversal.visitOperation(true);
        traversal.visitBinding(true);
        traversal.visitMessage(true);
        traversal.visitPort(true);
        traversal.visitPortType(true);
        traversal.visitExtensibilityElement(true);
        traversal.ignoreImport();
        traversal.ignoreDefinition2Binding();
        traversal.ignoreDefinition2Element();
        traversal.ignoreDefinition2ExtensibilityElement();
        traversal.ignoreDefinition2Message();
        traversal.ignoreDefinition2PortType();
        traversal.ignoreDefinition2Types();
        traversal.traverse(def);
        if (!this.claimFound) {
            this.result = "notApplicable";
        } else if (this.result.equals("warning")) {
            this.failureDetail = this.validator.createFailureDetail(this.failureDetailMessage, entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private boolean containsClaim(Element el) {
        if (el == null) {
            return false;
        }
        return (el = XMLUtils.findChildElement(el, WSI_CLAIM)) != null;
    }

    private boolean containsLegalClaim(Element el) {
        if (el == null) {
            return false;
        }
        el = XMLUtils.findChildElement(el, WSI_CLAIM);
        while (el != null) {
            String value = el.getAttribute(ATTR_CLAIM_CONFORMSTO.getLocalPart());
            if (value != null && value.equalsIgnoreCase("http://ws-i.org/profiles/basic/1.0")) {
                return true;
            }
            el = XMLUtils.findElement(el, WSI_CLAIM);
        }
        return false;
    }
}

