/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.message;

import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.Utils;

public class BP1101
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1101(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    @Override
    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        if (entryContext.getMessageEntry().getMessage() == null || "".equals(entryContext.getMessageEntry().getMessage())) {
            String httpStatus = Utils.getHTTPStatusCode(entryContext.getMessageEntry().getHTTPHeaders());
            if (!"200".equals(httpStatus) && !"202".equals(httpStatus)) {
                if (httpStatus.startsWith("4")) {
                    this.result = "notApplicable";
                } else {
                    this.result = "warning";
                    this.failureDetail = this.validator.createFailureDetail("\nResponse message:\nHeaders:\n" + entryContext.getMessageEntry().getHTTPHeaders() + "Message:\n" + entryContext.getMessageEntry().getMessage(), entryContext);
                }
            }
        } else {
            this.result = "notApplicable";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

