/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.message;

import java.util.Collection;
import java.util.List;
import javax.wsdl.BindingOperation;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionNotApplicableException;
import org.eclipse.wst.wsi.internal.core.log.MimePart;
import org.eclipse.wst.wsi.internal.core.log.MimeParts;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.MIMEUtils;

public class AP1926
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public AP1926(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    @Override
    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            if (!entryContext.getMessageEntry().isMimeContent()) {
                throw new AssertionNotApplicableException();
            }
            MimeParts mimeParts = entryContext.getMessageEntry().getMimeParts();
            BindingOperation bindingOperation = this.validator.getOperationMatch(entryContext.getEntry().getEntryType(), entryContext.getMessageEntryDocument());
            if (bindingOperation == null) {
                throw new AssertionNotApplicableException();
            }
            List extElems = null;
            if (entryContext.getMessageEntry().getType().equals("request") && bindingOperation.getBindingInput() != null) {
                extElems = bindingOperation.getBindingInput().getExtensibilityElements();
            } else if (entryContext.getMessageEntry().getType().equals("response") && bindingOperation.getBindingOutput() != null) {
                extElems = bindingOperation.getBindingOutput().getExtensibilityElements();
            }
            if (extElems == null || extElems.size() == 0 || !(extElems.get(0) instanceof MIMEMultipartRelated)) {
                throw new AssertionNotApplicableException();
            }
            MIMEMultipartRelated mime = (MIMEMultipartRelated)extElems.get(0);
            List parts = mime.getMIMEParts();
            if (mimeParts.getRootPart() == null || mimeParts.count() == 0) {
                throw new AssertionNotApplicableException();
            }
            int i = 1;
            while (i < parts.size()) {
                String partName = this.getMIMEContentPart((MIMEPart)parts.get(i));
                if (this.findMIMEPart(mimeParts.getParts(), partName) == null) {
                    throw new AssertionFailException("The corresponding binding operation \"" + bindingOperation.getName() + "\" does not contain part \"" + partName + "\"");
                }
                ++i;
            }
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        catch (AssertionFailException e) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(e.getMessage(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private String findMIMEPart(Collection parts, String partName) throws WSIException {
        if (partName == null) {
            return null;
        }
        for (MimePart part : parts) {
            String m_partName = MIMEUtils.getMimeHeaderAttribute(part.getHeaders(), "Content-ID");
            if (m_partName == null || !m_partName.startsWith("<") || m_partName.indexOf("=") == -1 || !this.encodePartName(m_partName.substring(1, m_partName.indexOf("="))).equals(partName)) continue;
            return m_partName;
        }
        return null;
    }

    private String getMIMEContentPart(MIMEPart part) {
        List list = part.getExtensibilityElements();
        if (list.size() == 0) {
            return null;
        }
        return ((MIMEContent)list.get(0)).getPart();
    }

    private String encodePartName(String str) {
        StringBuffer res = new StringBuffer("");
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) == '%' && str.length() > i + 2) {
                try {
                    int value = Integer.parseInt(String.valueOf(String.valueOf(str.charAt(i + 1))) + String.valueOf(str.charAt(i + 2)), 16);
                    res.append((char)value);
                    i += 2;
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                res.append(str.charAt(i));
            }
            ++i;
        }
        return res.toString();
    }
}

