/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IProjectProperties;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeLifecycleListener;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.internal.ModuleProperties;
import org.eclipse.wst.server.core.internal.PublishController;
import org.eclipse.wst.server.core.internal.ResourceManager;
import org.eclipse.wst.server.core.internal.RuntimeType;
import org.eclipse.wst.server.core.internal.RuntimeTypeWithServerProxy;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.internal.ServerPreferences;
import org.eclipse.wst.server.core.internal.ServerType;
import org.eclipse.wst.server.core.internal.ServerTypeProxy;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.discovery.Discovery;
import org.eclipse.wst.server.discovery.ServerProxy;

public final class ServerCore {
    private static final String EXTENSION_SERVER_TYPE = "serverTypes";
    private static final String EXTENSION_RUNTIME_TYPE = "runtimeTypes";
    private static List<IRuntimeType> runtimeTypes;
    private static List<IServerType> serverTypes;
    private static List<IServerType> DAServerTypes;
    private static List<IRuntimeType> DARuntimeTypes;
    private static IRegistryChangeListener registryListener;

    private ServerCore() {
    }

    private static final ResourceManager getResourceManager() {
        return ResourceManager.getInstance();
    }

    public static IProjectProperties getProjectProperties(IProject project) {
        if (project == null) {
            throw new IllegalArgumentException();
        }
        return new IProjectProperties(){

            @Override
            public IRuntime getRuntimeTarget() {
                return null;
            }
        };
    }

    public static IRuntimeType[] getRuntimeTypes() {
        if (runtimeTypes == null) {
            ServerCore.loadRuntimeTypes();
        }
        IRuntimeType[] rt = new IRuntimeType[runtimeTypes.size()];
        runtimeTypes.toArray(rt);
        return rt;
    }

    public static IRuntimeType findRuntimeType(String id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        if (runtimeTypes == null) {
            ServerCore.loadRuntimeTypes();
        }
        for (IRuntimeType runtimeType : runtimeTypes) {
            if (!id.equals(runtimeType.getId())) continue;
            return runtimeType;
        }
        return null;
    }

    public static IServerType[] getServerTypes() {
        if (serverTypes == null) {
            ServerCore.loadServerTypes();
        }
        IServerType[] st = new IServerType[serverTypes.size()];
        serverTypes.toArray(st);
        return st;
    }

    public static IServerType[] getDownloadableServers(IProgressMonitor monitor) {
        if (DAServerTypes == null || DAServerTypes.isEmpty()) {
            ServerCore.loadDAServerTypes(monitor);
        }
        IServerType[] servers2 = new IServerType[DAServerTypes.size()];
        DAServerTypes.toArray(servers2);
        return servers2;
    }

    public static IRuntimeType[] getDownloadableRuntimeTypes(IProgressMonitor monitor) {
        if (DARuntimeTypes == null || DARuntimeTypes.isEmpty()) {
            ServerCore.loadDARuntimeTypes(monitor);
        }
        IRuntimeType[] runtimesTypes2 = new IRuntimeType[DARuntimeTypes.size()];
        DARuntimeTypes.toArray(runtimesTypes2);
        return runtimesTypes2;
    }

    public static void resetDownloadableServers() {
        DAServerTypes = null;
        DARuntimeTypes = null;
    }

    public static boolean isDownloadableServerLoaded() {
        return DAServerTypes != null && !DAServerTypes.isEmpty();
    }

    public static IServerType findServerType(String id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        if (serverTypes == null) {
            ServerCore.loadServerTypes();
        }
        for (IServerType serverType : serverTypes) {
            if (!id.equals(serverType.getId())) continue;
            return serverType;
        }
        return null;
    }

    private static synchronized void loadRuntimeTypes() {
        if (runtimeTypes != null) {
            return;
        }
        if (Trace.EXTENSION_POINT) {
            Trace.trace("/extension_point", "->- Loading .runtimeTypes extension point ->-");
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.server.core", EXTENSION_RUNTIME_TYPE);
        ArrayList<IRuntimeType> list = new ArrayList<IRuntimeType>(cf.length);
        ServerCore.addRuntimeTypes(cf, list);
        ServerCore.addRegistryListener();
        runtimeTypes = list;
        if (Trace.EXTENSION_POINT) {
            Trace.trace("/extension_point", "-<- Done loading .runtimeTypes extension point -<-");
        }
    }

    private static synchronized void addRuntimeTypes(IConfigurationElement[] cf, List<IRuntimeType> list) {
        IConfigurationElement[] iConfigurationElementArray = cf;
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                IConfigurationElement ce = iConfigurationElementArray[n2];
                try {
                    if (!ServerPlugin.contains(ServerPlugin.getExcludedServerAdapters(), ce.getAttribute("id"))) {
                        list.add(new RuntimeType(ce));
                    }
                    if (Trace.EXTENSION_POINT) {
                        Trace.trace("/extension_point", "  Loaded runtimeType: " + ce.getAttribute("id"));
                    }
                }
                catch (Throwable t) {
                    if (!Trace.SEVERE) break block5;
                    Trace.trace("/severe", "  Could not load runtimeType: " + ce.getAttribute("id"), t);
                }
            }
            ++n2;
        }
    }

    private static synchronized void loadServerTypes() {
        if (serverTypes != null) {
            return;
        }
        if (Trace.EXTENSION_POINT) {
            Trace.trace("/extension_point", "->- Loading .serverTypes extension point ->-");
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.server.core", EXTENSION_SERVER_TYPE);
        ArrayList<IServerType> list = new ArrayList<IServerType>(cf.length);
        ServerCore.addServerTypes(cf, list);
        ServerCore.addRegistryListener();
        serverTypes = list;
        if (Trace.EXTENSION_POINT) {
            Trace.trace("/extension_point", "-<- Done loading .serverTypes extension point -<-");
        }
    }

    private static synchronized void loadDAServerTypes(IProgressMonitor monitor) {
        DAServerTypes = new ArrayList<IServerType>();
        DAServerTypes.addAll(ServerCore.createProxyServers(monitor));
    }

    private static synchronized void loadDARuntimeTypes(IProgressMonitor monitor) {
        DARuntimeTypes = new ArrayList<IRuntimeType>();
        DARuntimeTypes.addAll(ServerCore.createProxyRuntimeTypes(monitor));
    }

    private static List<RuntimeTypeWithServerProxy> createProxyRuntimeTypes(IProgressMonitor monitor) {
        List serverProxyList = Discovery.getExtensionsWithServer((IProgressMonitor)monitor);
        ArrayList<RuntimeTypeWithServerProxy> serverTypeProxyList = new ArrayList<RuntimeTypeWithServerProxy>();
        int i = 0;
        while (i < serverProxyList.size()) {
            ServerProxy serverProxy = (ServerProxy)serverProxyList.get(i);
            serverTypeProxyList.add(new RuntimeTypeWithServerProxy(serverProxy.getRuntimeType(), new ServerTypeProxy(serverProxy)));
            ++i;
        }
        return serverTypeProxyList;
    }

    private static List<ServerTypeProxy> createProxyServers(IProgressMonitor monitor) {
        List serverProxyList = Discovery.getExtensionsWithServer((IProgressMonitor)monitor);
        ArrayList<ServerTypeProxy> serverTypeProxyList = new ArrayList<ServerTypeProxy>();
        Iterator iterator = serverProxyList.iterator();
        while (iterator.hasNext()) {
            serverTypeProxyList.add(new ServerTypeProxy((ServerProxy)iterator.next()));
        }
        return serverTypeProxyList;
    }

    private static synchronized void addServerTypes(IConfigurationElement[] cf, List<IServerType> list) {
        IConfigurationElement[] iConfigurationElementArray = cf;
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                IConfigurationElement ce = iConfigurationElementArray[n2];
                try {
                    if (!ServerPlugin.contains(ServerPlugin.getExcludedServerAdapters(), ce.getAttribute("id"))) {
                        list.add(new ServerType(ce));
                    }
                    if (Trace.EXTENSION_POINT) {
                        Trace.trace("/extension_point", "  Loaded serverType: " + ce.getAttribute("id"));
                    }
                }
                catch (Throwable t) {
                    if (!Trace.SEVERE) break block5;
                    Trace.trace("/severe", "  Could not load serverType: " + ce.getAttribute("id"), t);
                }
            }
            ++n2;
        }
    }

    public static IRuntime findRuntime(String id) {
        return ServerCore.getResourceManager().getRuntime(id);
    }

    public static IRuntime[] getRuntimes() {
        return ServerCore.getResourceManager().getRuntimes();
    }

    public static IServer findServer(String id) {
        return ServerCore.getResourceManager().getServer(id);
    }

    public static IServer[] getServers() {
        return ServerCore.getResourceManager().getServers();
    }

    public static void addRuntimeLifecycleListener(IRuntimeLifecycleListener listener) {
        ServerCore.getResourceManager().addRuntimeLifecycleListener(listener);
    }

    public static void removeRuntimeLifecycleListener(IRuntimeLifecycleListener listener) {
        ServerCore.getResourceManager().removeRuntimeLifecycleListener(listener);
    }

    public static void addServerLifecycleListener(IServerLifecycleListener listener) {
        ServerCore.getResourceManager().addServerLifecycleListener(listener);
    }

    public static void removeServerLifecycleListener(IServerLifecycleListener listener) {
        ServerCore.getResourceManager().removeServerLifecycleListener(listener);
    }

    public static IServer getDefaultServer(IModule module) {
        return ModuleProperties.getInstance().getDefaultServer(module);
    }

    public static void setDefaultServer(IModule module, IServer server, IProgressMonitor monitor) throws CoreException {
        ModuleProperties.getInstance().setDefaultServer(module, server, monitor);
    }

    protected static void handleServerTypeDelta(IExtensionDelta delta) {
        if (serverTypes == null) {
            return;
        }
        IConfigurationElement[] cf = delta.getExtension().getConfigurationElements();
        ArrayList<IServerType> list = new ArrayList<IServerType>(serverTypes);
        if (delta.getKind() == 1) {
            ServerCore.addServerTypes(cf, list);
        } else {
            int size = list.size();
            ServerType[] st = new ServerType[size];
            list.toArray(st);
            int size2 = cf.length;
            int i = 0;
            while (i < size) {
                int j = 0;
                while (j < size2) {
                    if (st[i].getId().equals(cf[j].getAttribute("id"))) {
                        st[i].dispose();
                        list.remove(st[i]);
                    }
                    ++j;
                }
                ++i;
            }
        }
        serverTypes = list;
        ServerCore.getResourceManager().resolveServers();
    }

    protected static void handleRuntimeTypeDelta(IExtensionDelta delta) {
        if (runtimeTypes == null) {
            return;
        }
        IConfigurationElement[] cf = delta.getExtension().getConfigurationElements();
        ArrayList<IRuntimeType> list = new ArrayList<IRuntimeType>(runtimeTypes);
        if (delta.getKind() == 1) {
            ServerCore.addRuntimeTypes(cf, list);
        } else {
            int size = list.size();
            RuntimeType[] rt = new RuntimeType[size];
            list.toArray(rt);
            int size2 = cf.length;
            int i = 0;
            while (i < size) {
                int j = 0;
                while (j < size2) {
                    if (rt[i].getId().equals(cf[j].getAttribute("id"))) {
                        rt[i].dispose();
                        list.remove(rt[i]);
                    }
                    ++j;
                }
                ++i;
            }
        }
        runtimeTypes = list;
        ServerCore.getResourceManager().resolveRuntimes();
        ServerCore.getResourceManager().resolveServers();
    }

    private static void addRegistryListener() {
        if (registryListener != null) {
            return;
        }
        registryListener = new RegistryChangeListener();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.addRegistryChangeListener(registryListener, "org.eclipse.wst.server.core");
        ServerPlugin.setRegistryListener(registryListener);
    }

    public static boolean isAutoPublishing() {
        return ServerPreferences.getInstance().isAutoPublishing();
    }

    public static boolean isPublishRequired(IServer server, IResourceDelta delta2) {
        PublishController[] controllers = ServerPlugin.getPublishController();
        if (controllers.length > 0) {
            PublishController[] publishControllerArray = controllers;
            int n = controllers.length;
            int n2 = 0;
            while (n2 < n) {
                PublishController controller = publishControllerArray[n2];
                if (server.getServerType() != null && controller.supportsType(server.getServerType().getId())) {
                    return controller.isPublishRequired(server, delta2);
                }
                ++n2;
            }
        }
        return true;
    }

    protected static class RegistryChangeListener
    implements IRegistryChangeListener {
        protected RegistryChangeListener() {
        }

        public void registryChanged(IRegistryChangeEvent event) {
            IExtensionDelta delta;
            int n;
            int n2;
            IExtensionDelta[] iExtensionDeltaArray;
            IExtensionDelta[] deltas = event.getExtensionDeltas("org.eclipse.wst.server.core", ServerCore.EXTENSION_RUNTIME_TYPE);
            if (deltas != null) {
                iExtensionDeltaArray = deltas;
                n2 = deltas.length;
                n = 0;
                while (n < n2) {
                    delta = iExtensionDeltaArray[n];
                    ServerCore.handleRuntimeTypeDelta(delta);
                    ++n;
                }
            }
            if ((deltas = event.getExtensionDeltas("org.eclipse.wst.server.core", ServerCore.EXTENSION_SERVER_TYPE)) != null) {
                iExtensionDeltaArray = deltas;
                n2 = deltas.length;
                n = 0;
                while (n < n2) {
                    delta = iExtensionDeltaArray[n];
                    ServerCore.handleServerTypeDelta(delta);
                    ++n;
                }
            }
        }
    }
}

