/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.core.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.ws.internal.jaxws.core.JAXWSCorePlugin;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.xml.sax.InputSource;

public final class WSDLUtils {
    private static final String WSDL_FILE_NAME_PATTERN = "[a-zA-Z0-9_\\-]+.wsdl";
    private static final String WSDL_QUERY = "?wsdl";
    private static final IPath WSDL_FOLDER_PATH = new Path("wsdl/");
    private static final int TIMEOUT = 30000;
    public static final String WSDL_FILE_EXTENSION = ".wsdl";

    private WSDLUtils() {
    }

    public static Definition readWSDL(URL wsdlURL) throws IOException {
        URLConnection urlConnection = wsdlURL.openConnection();
        urlConnection.setConnectTimeout(30000);
        urlConnection.setReadTimeout(30000);
        try (InputStream inputStream = null;){
            Definition definition;
            inputStream = urlConnection.getInputStream();
            InputSource inputSource = new InputSource(inputStream);
            WSDLFactory wsdlFactory = WSDLFactory.newInstance();
            WSDLReader wsdlReader = wsdlFactory.newWSDLReader();
            Definition definition2 = definition = wsdlReader.readWSDL(wsdlURL.getPath(), inputSource);
            return definition2;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeWSDL(URL wsdlURL, Definition definition) throws IOException, CoreException {
        URI wsdlURI = null;
        OutputStream wsdlOutputStream = null;
        try {
            try {
                wsdlURI = wsdlURL.toURI();
                File wsdlFile = new File(wsdlURI);
                wsdlOutputStream = new FileOutputStream(wsdlFile);
                WSDLFactory wsdlFactory = WSDLFactory.newInstance();
                WSDLWriter wsdlWriter = wsdlFactory.newWSDLWriter();
                wsdlWriter.writeWSDL(definition, wsdlOutputStream);
                return;
            }
            catch (WSDLException wsdle) {
                JAXWSCorePlugin.log(wsdle);
                if (wsdlOutputStream == null) return;
                wsdlOutputStream.close();
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(URIUtil.toPath((URI)wsdlURI));
                if (file == null || !file.exists()) return;
                file.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                return;
            }
            catch (URISyntaxException urise) {
                JAXWSCorePlugin.log(urise);
                if (wsdlOutputStream == null) return;
                wsdlOutputStream.close();
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(URIUtil.toPath((URI)wsdlURI));
                if (file == null || !file.exists()) return;
                file.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                return;
            }
        }
        finally {
            if (wsdlOutputStream != null) {
                wsdlOutputStream.close();
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(URIUtil.toPath((URI)wsdlURI));
                if (file != null && file.exists()) {
                    file.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                }
            }
        }
    }

    public static boolean isValidWSDLFileName(String wsdlFileName) {
        return wsdlFileName != null && wsdlFileName.matches(WSDL_FILE_NAME_PATTERN);
    }

    private static IProject getProject(String projectName) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    public static IFolder getWebContentFolder(IProject project) {
        return ResourcesPlugin.getWorkspace().getRoot().getFolder(WSDLUtils.getWebContentPath(project));
    }

    public static IFolder getWSDLFolder(String projectName) {
        return WSDLUtils.getWSDLFolder(WSDLUtils.getProject(projectName));
    }

    public static IFolder getWSDLFolder(IProject project) {
        IPath wsdlFolderPath = WSDLUtils.getWebContentPath(project).append(WSDL_FOLDER_PATH);
        IFolder wsdlFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(wsdlFolderPath);
        if (!wsdlFolder.exists()) {
            try {
                wsdlFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException ce) {
                JAXWSCorePlugin.log(ce.getStatus());
            }
        }
        return wsdlFolder;
    }

    private static IPath getWebContentPath(IProject project) {
        IVirtualComponent virtualComponent = ComponentCore.createComponent((IProject)project);
        return virtualComponent.getRootFolder().getWorkspaceRelativePath();
    }

    public static ExtensibilityElement getEndpointAddress(Definition definition) {
        if (definition != null) {
            Map servicesMap = definition.getServices();
            Set servicesSet = servicesMap.entrySet();
            for (Map.Entry serviceEntry : servicesSet) {
                Service service = (Service)serviceEntry.getValue();
                Map portsMap = service.getPorts();
                Set portsSet = portsMap.entrySet();
                for (Map.Entry portEntry : portsSet) {
                    Port port = (Port)portEntry.getValue();
                    List extensibilityElements = port.getExtensibilityElements();
                    for (Object object : extensibilityElements) {
                        if (!(object instanceof SOAPAddress) && !(object instanceof SOAP12Address)) continue;
                        return (ExtensibilityElement)object;
                    }
                }
            }
        }
        return null;
    }

    public static String getWSDLLocation(Definition definition) throws MalformedURLException {
        String locationURI;
        ExtensibilityElement extensibilityElement = WSDLUtils.getEndpointAddress(definition);
        if (extensibilityElement != null && (locationURI = WSDLUtils.getLocationURI(extensibilityElement)).length() > 0) {
            URL endpointURL = new URL(locationURI);
            if (endpointURL.getQuery() == null) {
                locationURI = String.valueOf(locationURI) + WSDL_QUERY;
            }
            return locationURI;
        }
        return null;
    }

    private static String getLocationURI(ExtensibilityElement extensibilityElement) {
        if (extensibilityElement instanceof SOAPAddress) {
            return ((SOAPAddress)extensibilityElement).getLocationURI();
        }
        if (extensibilityElement instanceof SOAP12Address) {
            return ((SOAP12Address)extensibilityElement).getLocationURI();
        }
        return "";
    }

    public static String getPackageNameFromNamespace(String namespace) {
        String packageName = "";
        try {
            ArrayList<String> packageNameElements = new ArrayList<String>();
            URL namespaceURL = new URL(namespace);
            String authority = namespaceURL.getAuthority();
            if (authority.indexOf("www") != -1) {
                authority = authority.substring(authority.indexOf(".") + 1, authority.length());
            }
            List<String> authorityElements = Arrays.asList(authority.split("\\."));
            Collections.reverse(authorityElements);
            packageNameElements.addAll(authorityElements);
            String path = namespaceURL.getPath();
            List<String> pathElements = Arrays.asList(path.split("[/\\\\]"));
            packageNameElements.addAll(pathElements);
            Iterator packageIterator = packageNameElements.iterator();
            while (packageIterator.hasNext()) {
                String element = (String)packageIterator.next();
                if (element.trim().length() <= 0) continue;
                packageName = String.valueOf(packageName) + element;
                if (!packageIterator.hasNext()) continue;
                packageName = String.valueOf(packageName) + ".";
            }
        }
        catch (MalformedURLException murle) {
            JAXWSCorePlugin.log(murle);
        }
        return packageName.toLowerCase();
    }
}

