/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.ui.wizards;

import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPageExtension;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jst.ws.internal.cxf.core.CXFCorePlugin;
import org.eclipse.jst.ws.internal.cxf.core.model.CXFContext;
import org.eclipse.jst.ws.internal.cxf.core.model.CXFInstall;
import org.eclipse.jst.ws.internal.cxf.ui.CXFUIMessages;
import org.eclipse.jst.ws.internal.cxf.ui.CXFUIPlugin;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class CXFClasspathContainerPage
extends WizardPage
implements IClasspathContainerPage,
IClasspathContainerPageExtension {
    private IProject project;
    private ComboViewer installationsComboViewer;
    private Link link;
    private CXFContext context;
    private CXFInstall defaultInstall;
    private String intalledVersion;

    public CXFClasspathContainerPage() {
        super("cxf.classpath.container.page");
        this.setTitle(CXFUIMessages.CXF_INSTALL_WIZARD_PAGE_TITLE);
        this.setDescription(CXFUIMessages.CXF_INSTALL_WIZARD_PAGE_DESCRIPTION);
        this.setImageDescriptor(CXFUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.jst.ws.cxf.ui", (String)"icons/wizban/library_wiz.png"));
        this.context = CXFCorePlugin.getDefault().getJava2WSContext();
    }

    public boolean finish() {
        return true;
    }

    public IClasspathEntry getSelection() {
        CXFInstall selectedInstall = this.getSelectedInstall();
        if (selectedInstall != null) {
            IClasspathAttribute[] iClasspathAttributeArray;
            CXFCorePlugin.getDefault().setCXFRuntimeVersion(this.project, selectedInstall.getVersion());
            IClasspathAttribute jstComponentDependency = JavaCore.newClasspathAttribute((String)"org.eclipse.jst.component.dependency", (String)"/WEB-INF/lib");
            Path path = new Path("org.eclipse.jst.ws.cxf.core.CXF_CLASSPATH_CONTAINER");
            path = path.append(selectedInstall.getType());
            path = path.append(selectedInstall.getVersion());
            IAccessRule[] iAccessRuleArray = new IAccessRule[]{};
            if (CXFCorePlugin.getDefault().getJava2WSContext().isExportCXFClasspathContainer()) {
                IClasspathAttribute[] iClasspathAttributeArray2 = new IClasspathAttribute[1];
                iClasspathAttributeArray = iClasspathAttributeArray2;
                iClasspathAttributeArray2[0] = jstComponentDependency;
            } else {
                iClasspathAttributeArray = new IClasspathAttribute[]{};
            }
            return JavaCore.newContainerEntry((IPath)path, (IAccessRule[])iAccessRuleArray, (IClasspathAttribute[])iClasspathAttributeArray, (boolean)true);
        }
        return null;
    }

    public void setSelection(IClasspathEntry containerEntry) {
        if (this.project != null) {
            this.intalledVersion = CXFCorePlugin.getDefault().getCXFRuntimeVersion(this.project);
            this.defaultInstall = (CXFInstall)this.context.getInstallations().get(this.intalledVersion);
            if (this.defaultInstall != null && this.installationsComboViewer != null) {
                this.installationsComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.defaultInstall), true);
            }
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        composite.setLayout((Layout)gridLayout);
        this.link = new Link(composite, 0);
        this.link.setText(CXFUIMessages.CXF_CONFIGURE_INSTALLED_RUNTIMES_LABEL);
        this.link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectedIndex = CXFClasspathContainerPage.this.installationsComboViewer.getCombo().getSelectionIndex();
                int result = PreferencesUtil.createPreferenceDialogOn((Shell)CXFClasspathContainerPage.this.getShell(), (String)"org.eclipse.jst.ws.cxf.ui.CXFRuntimePreferencesPage", (String[])new String[]{"org.eclipse.jst.ws.cxf.ui.CXFRuntimePreferencesPage"}, null).open();
                if (result == 0) {
                    CXFClasspathContainerPage.this.installationsComboViewer.refresh();
                    CXFClasspathContainerPage.this.installationsComboViewer.getCombo().select(selectedIndex);
                }
            }
        });
        GridData gridData = new GridData(0x1000008, 4, true, false);
        gridData.horizontalSpan = 2;
        this.link.setLayoutData((Object)gridData);
        Label label = new Label(composite, 0);
        label.setText(CXFUIMessages.CXF_PROPERTY_PAGE_RUNTIME_LABEL);
        this.installationsComboViewer = new ComboViewer(composite, 2056);
        gridData = new GridData(4, 4, true, false);
        this.installationsComboViewer.getCombo().setLayoutData((Object)gridData);
        this.installationsComboViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Collection) {
                    return ((Collection)inputElement).toArray();
                }
                return new Object[0];
            }
        });
        this.installationsComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof CXFInstall) {
                    CXFInstall cxfInstall = (CXFInstall)element;
                    return String.valueOf(cxfInstall.getType()) + " " + cxfInstall.getVersion();
                }
                return "";
            }
        });
        Collection installations = this.context.getInstallations().values();
        this.installationsComboViewer.setInput(installations);
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
        this.setSelection(null);
    }

    public void initialize(IJavaProject javaProject, IClasspathEntry[] currentEntries) {
        if (javaProject != null) {
            this.project = javaProject.getProject();
        }
    }

    private CXFInstall getSelectedInstall() {
        StructuredSelection structuredSelection = (StructuredSelection)this.installationsComboViewer.getSelection();
        if (!structuredSelection.isEmpty()) {
            CXFInstall selectedInstall = (CXFInstall)structuredSelection.getFirstElement();
            return selectedInstall;
        }
        return null;
    }
}

