/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal;

import java.math.BigInteger;
import java.util.ListIterator;
import org.eclipse.wst.xml.xpath2.api.typesystem.ItemType;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.SimpleAtomicItemTypeImpl;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSInteger;
import org.eclipse.wst.xml.xpath2.processor.internal.types.builtin.BuiltinTypeLibrary;

public class RangeResultSequence
extends ResultSequence {
    private int _start;
    private int _end;
    private int _size;
    private ResultSequence _tail;

    public RangeResultSequence(int start, int end) {
        this._size = end - start + 1;
        assert (this._size >= 0);
        this._start = start;
        this._end = end;
        this._tail = ResultSequenceFactory.create_new();
    }

    @Override
    public void add(AnyType item) {
        this._tail.add(item);
    }

    @Override
    public void concat(ResultSequence rs) {
        this._tail.concat(rs);
    }

    @Override
    public ListIterator iterator() {
        if (this._size != 0) {
            ResultSequence newtail = ResultSequenceFactory.create_new();
            while (this._start <= this._end) {
                newtail.add(new XSInteger(BigInteger.valueOf(this._start)));
                ++this._start;
            }
            newtail.concat(this._tail);
            this._tail.release();
            this._tail = newtail;
            this._size = 0;
            this._start = 0;
            this._end = 0;
        }
        return this._tail.iterator();
    }

    @Override
    public AnyType get(int i) {
        if (i < this._size) {
            return new XSInteger(BigInteger.valueOf(this._start + i));
        }
        return this._tail.get(i - this._size);
    }

    @Override
    public int size() {
        return this._size + this._tail.size();
    }

    @Override
    public void clear() {
        this._size = 0;
        this._tail.clear();
    }

    @Override
    public ResultSequence create_new() {
        assert (false);
        return null;
    }

    @Override
    public AnyType first() {
        return this.get(0);
    }

    @Override
    public Object firstValue() {
        return this.get(0).getNativeValue();
    }

    @Override
    public boolean empty() {
        return this.size() == 0;
    }

    @Override
    public ItemType sequenceType() {
        return new SimpleAtomicItemTypeImpl(BuiltinTypeLibrary.XS_INTEGER, 2);
    }

    @Override
    public void release() {
    }
}

