/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.xsd;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.predicate.CriterionPredicate;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jaxb.core.xsd.XSDNodeVisitor;
import org.eclipse.jpt.jaxb.core.xsd.XsdAttributeUse;
import org.eclipse.jpt.jaxb.core.xsd.XsdElementDeclaration;
import org.eclipse.jpt.jaxb.core.xsd.XsdTypeDefinition;
import org.eclipse.jpt.jaxb.core.xsd.XsdUtil;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDContentTypeCategory;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDNamedComponent;

public class XsdComplexTypeDefinition
extends XsdTypeDefinition<XSDComplexTypeDefinition> {
    protected static final Transformer<XsdAttributeUse, String> XSD_ATTRIBUTE_USE_TRANSFORMER = new XsdAttributeUseTransformer();
    protected static final Transformer<XsdElementDeclaration, String> XSD_ELEMENT_DECLARATION_TRANSFORMER = new XsdElementDeclarationTransformer();

    XsdComplexTypeDefinition(XSDComplexTypeDefinition xsdComplexTypeDefinition) {
        super(xsdComplexTypeDefinition);
    }

    @Override
    public XsdTypeDefinition.Kind getKind() {
        return XsdTypeDefinition.Kind.COMPLEX;
    }

    @Override
    public boolean hasTextContent() {
        return ((XSDComplexTypeDefinition)this.getXSDComponent()).getContentTypeCategory() == XSDContentTypeCategory.SIMPLE_LITERAL;
    }

    @Override
    public XsdAttributeUse getAttribute(String namespace, String name) {
        for (XsdAttributeUse attrUse : this.getAttributeUses(namespace)) {
            if (!((XSDAttributeUse)attrUse.getXSDComponent()).getAttributeDeclaration().getName().equals(name)) continue;
            return attrUse;
        }
        return null;
    }

    @Override
    public Iterable<String> getAttributeNames(String namespace) {
        return IterableTools.transform(this.getAttributeUses(namespace), XSD_ATTRIBUTE_USE_TRANSFORMER);
    }

    protected Iterable<XsdAttributeUse> getAttributeUses(String namespace) {
        return IterableTools.transform((Iterable)IterableTools.filter((Iterable)((XSDComplexTypeDefinition)this.getXSDComponent()).getAttributeUses(), (Predicate)new AttributeUsesNamespace(namespace)), XsdUtil.adapterTransformer());
    }

    @Override
    public XsdElementDeclaration getElement(String namespace, String name, boolean recurseChildren) {
        for (XsdElementDeclaration element : this.getElementDeclarations(namespace, recurseChildren)) {
            if (!((XSDElementDeclaration)element.getXSDComponent()).getName().equals(name)) continue;
            return element;
        }
        return null;
    }

    @Override
    public Iterable<String> getElementNames(String namespace, boolean recurseChildren) {
        return IterableTools.transform(this.getElementDeclarations(namespace, recurseChildren), XSD_ELEMENT_DECLARATION_TRANSFORMER);
    }

    protected Iterable<XsdElementDeclaration> getElementDeclarations(String namespace, boolean recurseChildren) {
        return IterableTools.transform((Iterable)IterableTools.filter(this.getXSDElementDeclarations(recurseChildren), (Predicate)new XsdUtil.NamespaceEquals(namespace)), XsdUtil.adapterTransformer());
    }

    protected Iterable<XSDElementDeclaration> getXSDElementDeclarations(boolean recurseChildren) {
        ElementFinder elementFinder = new ElementFinder(recurseChildren);
        elementFinder.visitNode((XSDComponent)this.getXSDComponent());
        return elementFinder.getElements();
    }

    public static class AttributeUsesNamespace
    extends CriterionPredicate<XSDAttributeUse, String> {
        public AttributeUsesNamespace(String namespace) {
            super((Object)namespace);
        }

        public boolean evaluate(XSDAttributeUse attrUse) {
            return XsdUtil.namespaceEquals((XSDNamedComponent)attrUse.getAttributeDeclaration(), (String)this.criterion);
        }
    }

    class ElementFinder
    extends XSDNodeVisitor {
        private boolean recurseChildren;
        private List<XSDElementDeclaration> elements = new ArrayList<XSDElementDeclaration>();

        ElementFinder(boolean recurseChildren) {
            this.recurseChildren = recurseChildren;
        }

        @Override
        protected boolean visitChildren() {
            return super.visitChildren() || this.recurseChildren;
        }

        @Override
        public void visitXSDElementDeclaration(XSDElementDeclaration node) {
            boolean cachedVisitChildren = this.visitChildren;
            this.visitChildren = false;
            super.visitXSDElementDeclaration(node);
            if (!this.elements.contains(node)) {
                this.elements.add(node);
            }
            this.visitChildren = cachedVisitChildren;
        }

        public Iterable<XSDElementDeclaration> getElements() {
            return this.elements;
        }
    }

    public static class XsdAttributeUseTransformer
    extends TransformerAdapter<XsdAttributeUse, String> {
        public String transform(XsdAttributeUse attrUse) {
            return ((XSDAttributeUse)attrUse.getXSDComponent()).getAttributeDeclaration().getName();
        }
    }

    public static class XsdElementDeclarationTransformer
    extends TransformerAdapter<XsdElementDeclaration, String> {
        public String transform(XsdElementDeclaration element) {
            return ((XSDElementDeclaration)element.getXSDComponent()).getName();
        }
    }
}

