/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.resource.java.source;

import java.util.Arrays;
import java.util.Vector;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotationStringArrayExpressionConverter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.ExpressionConverter;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.collection.ListTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.SingleElementIterable;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jaxb.core.resource.java.XmlSeeAlsoAnnotation;

public final class SourceXmlSeeAlsoAnnotation
extends SourceAnnotation
implements XmlSeeAlsoAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.xml.bind.annotation.XmlSeeAlso");
    private final DeclarationAnnotationElementAdapter<String[]> valueDeclarationAdapter = SourceXmlSeeAlsoAnnotation.buildArrayAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "value");
    private final AnnotationElementAdapter<String[]> valueAdapter = this.buildArrayAnnotationElementAdapter(this.valueDeclarationAdapter);
    private final Vector<String> classes = new Vector();
    private boolean suppressFQClassesEventNotification = false;
    private final Vector<String> fullyQualifiedClasses = new Vector();

    public SourceXmlSeeAlsoAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement annotatedElement) {
        super((JavaResourceModel)parent, annotatedElement, DECLARATION_ANNOTATION_ADAPTER);
    }

    private AnnotationElementAdapter<String[]> buildArrayAnnotationElementAdapter(DeclarationAnnotationElementAdapter<String[]> daea) {
        return new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, daea);
    }

    public String getAnnotationName() {
        return "javax.xml.bind.annotation.XmlSeeAlso";
    }

    public void initialize(Annotation astAnnotation) {
        super.initialize(astAnnotation);
        String[] stringArray = (String[])this.valueAdapter.getValue(astAnnotation);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String astClass = stringArray[n2];
            this.classes.add(astClass);
            ++n2;
        }
        CollectionTools.addAll(this.fullyQualifiedClasses, this.buildFullyQualifiedClasses(astAnnotation));
    }

    public void synchronizeWith(Annotation astAnnotation) {
        super.synchronizeWith(astAnnotation);
        String[] astClasses = (String[])this.valueAdapter.getValue(astAnnotation);
        this.synchronizeList(Arrays.asList(astClasses), this.classes, "classes");
        if (this.suppressFQClassesEventNotification) {
            this.fullyQualifiedClasses.clear();
            CollectionTools.addAll(this.fullyQualifiedClasses, this.buildFullyQualifiedClasses(astAnnotation));
            this.suppressFQClassesEventNotification = false;
        } else {
            this.synchronizeList(this.buildFullyQualifiedClasses(astAnnotation), this.fullyQualifiedClasses, "fullyQualifiedClasses");
        }
    }

    protected Iterable<String> buildFullyQualifiedClasses(Annotation astAnnotation) {
        Expression expression = this.valueAdapter.getExpression(astAnnotation);
        if (expression == null) {
            return EmptyIterable.instance();
        }
        if (expression.getNodeType() == 57) {
            return new SingleElementIterable((Object)ASTTools.resolveFullyQualifiedName((Expression)expression));
        }
        return ASTTools.resolveFullyQualifiedNames((Expression)expression);
    }

    public void toString(StringBuilder sb) {
        sb.append(this.classes);
    }

    @Override
    public ListIterable<String> getClasses() {
        return IterableTools.cloneLive(this.classes);
    }

    @Override
    public int getClassesSize() {
        return this.classes.size();
    }

    @Override
    public void addClass(String clazz) {
        this.addClass(this.classes.size(), clazz);
    }

    @Override
    public void addClass(int index, String clazz) {
        this.classes.add(index, clazz);
        this.suppressFQClassesEventNotification = true;
        this.writeClasses();
    }

    @Override
    public void moveClass(int targetIndex, int sourceIndex) {
        ListTools.move(this.classes, (int)targetIndex, (int)sourceIndex);
        this.suppressFQClassesEventNotification = true;
        this.writeClasses();
    }

    @Override
    public void removeClass(int index) {
        this.classes.remove(index);
        this.suppressFQClassesEventNotification = true;
        this.writeClasses();
    }

    @Override
    public ListIterable<String> getFullyQualifiedClasses() {
        return IterableTools.cloneLive(this.fullyQualifiedClasses);
    }

    private void writeClasses() {
        this.valueAdapter.setValue((Object)this.classes.toArray(new String[this.classes.size()]));
    }

    private static DeclarationAnnotationElementAdapter<String[]> buildArrayAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return SourceXmlSeeAlsoAnnotation.buildArrayAnnotationElementAdapter(annotationAdapter, elementName, (ExpressionConverter<String[]>)AnnotationStringArrayExpressionConverter.forTypes());
    }

    private static DeclarationAnnotationElementAdapter<String[]> buildArrayAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName, ExpressionConverter<String[]> converter) {
        return new ConversionDeclarationAnnotationElementAdapter(annotationAdapter, elementName, converter);
    }
}

