/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.websocket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import javax.xml.bind.DatatypeConverter;
import org.eclipse.wst.jsdt.chromium.internal.websocket.HandshakeUtil;
import org.eclipse.wst.jsdt.chromium.internal.websocket.ManualLoggingSocketWrapper;
import org.eclipse.wst.jsdt.chromium.util.BasicUtil;

class Hybi17Handshake {
    private static final Result CONNECTED_RESULT = new Result(){

        @Override
        <R> R accept(Result.Visitor<R> visitor) {
            return visitor.visitConnected();
        }
    };
    private static final String GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";

    Hybi17Handshake() {
    }

    static Result performHandshake(ManualLoggingSocketWrapper socket, InetSocketAddress endpoint, String resourceName, Random random) throws IOException {
        MessageDigest digest;
        final ManualLoggingSocketWrapper.LoggableInput input = (ManualLoggingSocketWrapper.LoggableInput)socket.getLoggableInput();
        ManualLoggingSocketWrapper.LoggableOutput output = (ManualLoggingSocketWrapper.LoggableOutput)socket.getLoggableOutput();
        Hybi17Handshake.writeHttpLine(output, "GET " + resourceName + " HTTP/1.1");
        ArrayList<String> headerFields = HandshakeUtil.createHttpFields(endpoint);
        headerFields.add("Upgrade: websocket");
        headerFields.add("Host: " + endpoint.getHostName());
        byte[] secKeyBytes = new byte[16];
        random.nextBytes(secKeyBytes);
        String secKeyString = DatatypeConverter.printBase64Binary((byte[])secKeyBytes);
        headerFields.add("Sec-WebSocket-Key: " + secKeyString);
        headerFields.add("Sec-WebSocket-Version: 13");
        Collections.shuffle(headerFields, random);
        for (String field : headerFields) {
            Hybi17Handshake.writeHttpLine(output, field);
        }
        Hybi17Handshake.writeHttpLine(output, "");
        HandshakeUtil.LineReader lineReader = new HandshakeUtil.LineReader(){

            @Override
            byte[] readUpTo0x0D0A() throws IOException {
                ByteBuffer buffer = input.readUpTo0x0D0A();
                byte[] result = new byte[buffer.limit()];
                buffer.get(result);
                return result;
            }
        };
        HandshakeUtil.HttpResponse httpResponse = HandshakeUtil.readHttpResponse(lineReader);
        if (httpResponse.getCode() != 101) {
            return Hybi17Handshake.processResult(input, httpResponse);
        }
        Map<String, String> responseFields = httpResponse.getFields();
        if (!"websocket".equalsIgnoreCase(responseFields.get("upgrade"))) {
            throw new IOException("Malformed response");
        }
        if (!"upgrade".equalsIgnoreCase(responseFields.get("connection"))) {
            throw new IOException("Malformed response");
        }
        if (responseFields.get("sec-websocket-extensions") != null) {
            throw new IOException("Malformed response");
        }
        if (responseFields.get("sec-websocket-protocol") != null) {
            throw new IOException("Malformed response");
        }
        String secAcceptString = responseFields.get("sec-websocket-accept");
        if (secAcceptString == null) {
            throw new IOException("Malformed response");
        }
        String expectedConcatenation = String.valueOf(secKeyString) + GUID;
        try {
            digest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        byte[] expectedAcceptSha1 = digest.digest(expectedConcatenation.getBytes());
        String expectedAcceptString = DatatypeConverter.printBase64Binary((byte[])expectedAcceptSha1);
        if (!BasicUtil.eq((Object)expectedAcceptString, (Object)secAcceptString)) {
            throw new IOException("Malformed response");
        }
        return CONNECTED_RESULT;
    }

    private static Result processResult(ManualLoggingSocketWrapper.LoggableInput input, final HandshakeUtil.HttpResponse httpResponse) throws IOException {
        Map<String, String> fields = httpResponse.getFields();
        String contentType = fields.get("content-type");
        String contentLength = fields.get("content-length");
        if ("text/html".equals(contentType) && contentLength != null) {
            int length;
            try {
                length = Integer.parseInt(contentLength);
            }
            catch (NumberFormatException e) {
                return Result.createError(new Exception("Failed to parse context-length field", e));
            }
            byte[] response = input.readBytes(length);
            final String contentText = new String(response, HandshakeUtil.ASCII_CHARSET);
            return new Result(){

                @Override
                <R> R accept(Result.Visitor<R> visitor) {
                    return visitor.visitErrorMessage(httpResponse.getCode(), httpResponse.getReasonPhrase(), contentText);
                }
            };
        }
        return Result.createError(new Exception("Error response: " + httpResponse.getCode() + " " + httpResponse.getReasonPhrase()));
    }

    private static void writeHttpLine(ManualLoggingSocketWrapper.LoggableOutput output, String line) throws IOException {
        output.writeAsciiString(String.valueOf(line) + "\r\n");
    }

    static abstract class Result {
        Result() {
        }

        abstract <R> R accept(Visitor<R> var1);

        static Result createError(final Exception exception) {
            return new Result(){

                @Override
                <R> R accept(Visitor<R> visitor) {
                    return visitor.visitUnknownError(exception);
                }
            };
        }

        static interface Visitor<R> {
            public R visitConnected();

            public R visitUnknownError(Exception var1);

            public R visitErrorMessage(int var1, String var2, String var3);
        }
    }
}

