/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jpt.common.core.internal.utility.JptPlugin;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public abstract class JptUIPlugin
extends JptPlugin {
    private IDialogSettings dialogSettings;
    private IPreferenceStore preferenceStore;
    protected static final String DIALOG_SETTINGS_SECTION_NAME = "Workbench";
    protected static final String SIMPLE_DIALOG_SETTINGS_FILE_NAME = "dialog_settings.xml";

    protected JptUIPlugin() {
    }

    public void stop(BundleContext context) throws Exception {
        try {
            this.saveDialogSettings();
        }
        finally {
            super.stop(context);
        }
    }

    public synchronized IDialogSettings getDialogSettings(String sectionName) {
        IDialogSettings pluginSettings = this.getDialogSettings();
        if (pluginSettings == null) {
            return null;
        }
        IDialogSettings sectionSettings = pluginSettings.getSection(sectionName);
        if (sectionSettings == null) {
            sectionSettings = pluginSettings.addNewSection(sectionName);
        }
        return sectionSettings;
    }

    public synchronized IDialogSettings getDialogSettings() {
        if (this.dialogSettings == null) {
            this.dialogSettings = this.buildDialogSettings();
        }
        return this.dialogSettings;
    }

    protected IDialogSettings buildDialogSettings() {
        IDialogSettings settings = this.buildDialogSettings_();
        String settingsFileName = this.getDialogSettingsFileName();
        if (settingsFileName == null) {
            return settings;
        }
        File settingsFile = new File(settingsFileName);
        if (settingsFile.exists()) {
            try {
                settings.load(settingsFileName);
            }
            catch (IOException iOException) {
                return this.buildDialogSettings_();
            }
        }
        return settings;
    }

    protected IDialogSettings buildDialogSettings_() {
        return new DialogSettings(this.getDialogSettingsSectionName());
    }

    protected String getDialogSettingsSectionName() {
        return DIALOG_SETTINGS_SECTION_NAME;
    }

    protected synchronized void saveDialogSettings() {
        if (this.dialogSettings != null) {
            this.saveDialogSettings_();
        }
    }

    protected void saveDialogSettings_() {
        String settingsFileName = this.getDialogSettingsFileName();
        if (settingsFileName != null) {
            try {
                this.dialogSettings.save(settingsFileName);
            }
            catch (IOException iOException) {}
        }
    }

    protected String getDialogSettingsFileName() {
        IPath stateLocation = this.getStateLocation();
        if (stateLocation == null) {
            return null;
        }
        IPath path = stateLocation.append(this.getSimpleDialogSettingsFileName());
        return path.toOSString();
    }

    protected String getSimpleDialogSettingsFileName() {
        return SIMPLE_DIALOG_SETTINGS_FILE_NAME;
    }

    public ImageDescriptor buildImageDescriptor(String path) {
        if (StringTools.isBlank((String)path)) {
            throw new IllegalArgumentException("image path cannot be blank");
        }
        Bundle bundle = this.getBundle();
        if (bundle == null) {
            return null;
        }
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(path), null);
        return url == null ? null : ImageDescriptor.createFromURL((URL)url);
    }

    public synchronized IPreferenceStore getPreferenceStore() {
        if (this.preferenceStore == null) {
            this.preferenceStore = this.buildPreferenceStore();
        }
        return this.preferenceStore;
    }

    protected IPreferenceStore buildPreferenceStore() {
        String id = this.getPluginID();
        return id == null ? null : new ScopedPreferenceStore(InstanceScope.INSTANCE, id);
    }
}

