/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.core.javascript.search;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wst.jsdt.web.core.internal.JsCoreMessages;
import org.eclipse.wst.jsdt.web.core.internal.validation.Util;
import org.eclipse.wst.jsdt.web.core.javascript.search.JsIndexManager;
import org.eclipse.wst.jsdt.web.core.javascript.search.JsSearchSupport;

public class IndexWorkspaceJob
extends Job {
    static final boolean DEBUG;

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.wst.jsdt.web.core/debug/jsindexmanager");
        DEBUG = value != null && value.equalsIgnoreCase("true");
    }

    public IndexWorkspaceJob() {
        super(JsCoreMessages.JSPIndexManager_0);
        this.setPriority(30);
        this.setSystem(true);
    }

    protected IStatus run(IProgressMonitor monitor) {
        long start;
        IStatus status;
        block9: {
            status = Status.OK_STATUS;
            if (monitor.isCanceled()) {
                this.setCanceledState();
                return Status.CANCEL_STATUS;
            }
            if (DEBUG) {
                System.out.println(" ^ IndexWorkspaceJob started: ");
            }
            start = System.currentTimeMillis();
            try {
                try {
                    WebFileVisitor visitor = new WebFileVisitor(monitor);
                    ResourcesPlugin.getWorkspace().getRoot().accept((IResourceProxyVisitor)visitor, 2);
                    JsIndexManager.getInstance().indexFiles(visitor.getFiles());
                }
                catch (CoreException e) {
                    if (DEBUG) {
                        e.printStackTrace();
                    }
                    monitor.done();
                    break block9;
                }
            }
            catch (Throwable throwable) {
                monitor.done();
                throw throwable;
            }
            monitor.done();
        }
        long finish = System.currentTimeMillis();
        if (DEBUG) {
            System.out.println(" ^ IndexWorkspaceJob finished\n   total time running: " + (finish - start));
        }
        return status;
    }

    void setCanceledState() {
        JsIndexManager.getInstance().setIndexState(4);
    }

    private class WebFileVisitor
    implements IResourceProxyVisitor {
        private List files = new ArrayList();
        IProgressMonitor fMonitor = null;

        public WebFileVisitor(IProgressMonitor monitor) {
            this.fMonitor = monitor;
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            if (this.fMonitor != null && this.fMonitor.isCanceled()) {
                IndexWorkspaceJob.this.setCanceledState();
                return false;
            }
            if (JsSearchSupport.getInstance().isCanceled()) {
                IndexWorkspaceJob.this.setCanceledState();
                return false;
            }
            if (proxy.getType() == 1 && !proxy.isDerived() && !proxy.isHidden() && proxy.isAccessible() && Util.isJsType(proxy.getName())) {
                this.fMonitor.subTask(proxy.getName());
                IFile file = (IFile)proxy.requestResource();
                if (DEBUG) {
                    System.out.println("(+) IndexWorkspaceJob adding file: " + file.getName());
                }
                this.files.add(file);
                return false;
            }
            return !proxy.getName().startsWith(".");
        }

        public final IFile[] getFiles() {
            return this.files.toArray(new IFile[this.files.size()]);
        }
    }
}

