/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.core.internal.project;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.jsdt.web.core.internal.project.ConvertJob;
import org.eclipse.wst.jsdt.web.core.internal.project.JsWebNature;
import org.eclipse.wst.jsdt.web.core.internal.project.Messages;

public class JsNatureInstaller
implements IDelegate {
    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("Installing Facet for JavaScript Development Tools.", 100);
        try {
            if (!JsWebNature.hasNature(project)) {
                this.installNature(project, monitor);
            }
        }
        finally {
            monitor.done();
        }
    }

    public void installNature(IProject project, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(Messages.getString("JsNatureInstaller.1"), 100);
        monitor.subTask(Messages.getString("JsNatureInstaller.2"));
        try {
            monitor.worked(20);
            JsWebNature jsNature = new JsWebNature(project, monitor);
            monitor.worked(20);
            jsNature.configure();
            monitor.worked(40);
            new ConvertJob(project, false).schedule(1000L);
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.web.core", 0, Messages.getString("JsNatureInstaller.3"), (Throwable)e));
        }
    }
}

