/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui.listeners;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.jsdt.chromium.debug.ui.ChromiumDebugUIPlugin;
import org.eclipse.wst.jsdt.chromium.debug.ui.actions.PushChangesAction;

public class JavaScriptChangeListener
implements IResourceChangeListener {
    private static final PushChangesAction ACTION = new PushChangesAction();
    private static final String JS = ".js";

    public void resourceChanged(IResourceChangeEvent event) {
        if (1 == event.getType()) {
            try {
                event.getDelta().accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        IResource resource = delta.getResource();
                        if (resource.getName().endsWith(JavaScriptChangeListener.JS) && resource instanceof IFile) {
                            final IFile file = (IFile)resource;
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    ACTION.createRunnable(file).run(ChromiumDebugUIPlugin.getActiveShell(), ChromiumDebugUIPlugin.getActivePart());
                                }
                            });
                        }
                        return true;
                    }
                });
            }
            catch (CoreException e) {
                ChromiumDebugUIPlugin.logError(e, e.getMessage());
            }
        }
    }
}

