/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui.actions;

import java.io.IOException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ConnectedTargetData;
import org.eclipse.wst.jsdt.chromium.debug.core.model.DebugTargetImpl;
import org.eclipse.wst.jsdt.chromium.debug.core.model.JavaScriptFormatter;
import org.eclipse.wst.jsdt.chromium.debug.core.model.StringMappingData;
import org.eclipse.wst.jsdt.chromium.debug.core.model.VmResource;
import org.eclipse.wst.jsdt.chromium.debug.core.model.WorkspaceBridge;
import org.eclipse.wst.jsdt.chromium.debug.core.sourcemap.SourcePositionMapBuilder;
import org.eclipse.wst.jsdt.chromium.debug.core.sourcemap.TextSectionMapping;
import org.eclipse.wst.jsdt.chromium.debug.core.sourcemap.TextSectionMappingImpl;
import org.eclipse.wst.jsdt.chromium.debug.core.util.ChromiumDebugPluginUtil;
import org.eclipse.wst.jsdt.chromium.debug.ui.JsDebugModelPresentation;
import org.eclipse.wst.jsdt.chromium.debug.ui.actions.FileBasedAction;
import org.eclipse.wst.jsdt.chromium.debug.ui.actions.Messages;
import org.eclipse.wst.jsdt.chromium.debug.ui.actions.SelectionBasedAction;

public class TemporarilyFormatSourceAction
extends FileBasedAction.Multiple<ResourceData> {
    private static final FileBasedAction.FileFilter<ResourceData> RESOURCE_FILTER = new FileBasedAction.FileFilter<ResourceData>(){

        @Override
        ResourceData accept(IFile file) {
            for (ConnectedTargetData targetData : DebugTargetImpl.getAllConnectedTargetDatas()) {
                VmResource vmResource = targetData.getWorkspaceRelations().getVProjectVmResource(file);
                if (vmResource == null) continue;
                return new ResourceData(file, vmResource, targetData);
            }
            return null;
        }
    };
    private final SelectionBasedAction.ActionRunnable noFormatterActionStub = new SelectionBasedAction.ActionRunnable(){

        @Override
        public void adjustAction() {
            TemporarilyFormatSourceAction.this.restoreActionText();
            String baseText = TemporarilyFormatSourceAction.this.getAction().getText();
            TemporarilyFormatSourceAction.this.modifyActionText(String.valueOf(baseText) + Messages.TemporarilyFormatSourceAction_NO_FORMATTER_DISABLED_SUFFIX);
            TemporarilyFormatSourceAction.this.getAction().setEnabled(false);
        }

        @Override
        public void run(Shell shell, IWorkbenchPart workbenchPart) {
        }
    };

    public TemporarilyFormatSourceAction() {
        super(RESOURCE_FILTER);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected SelectionBasedAction.ActionRunnable createRunnable(List<? extends ResourceData> resourceDataList) {
        iterator = resourceDataList.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        firstElement = iterator.next();
        firstElementMode = this.checkActionMode(firstElement);
        if (firstElementMode != ActionMode.UNAPPLICABLE) ** GOTO lbl14
        return null;
lbl-1000:
        // 1 sources

        {
            otherElement = iterator.next();
            otherElementMode = this.checkActionMode(otherElement);
            if (otherElementMode == ActionMode.UNAPPLICABLE) {
                return null;
            }
            if (otherElementMode == firstElementMode) continue;
            return null;
lbl14:
            // 2 sources

            ** while (iterator.hasNext())
        }
lbl15:
        // 1 sources

        if (firstElementMode == ActionMode.FORMAT) {
            formatter = JavaScriptFormatter.Access.getInstance();
            if (formatter == null) {
                return this.noFormatterActionStub;
            }
            return new FormatActionRunnable(resourceDataList, formatter);
        }
        return new DeleteFormattedActionRunnable(resourceDataList);
    }

    private ActionMode checkActionMode(ResourceData data) {
        VmResource.Metadata metadata = data.getVmResource().getMetadata();
        if (metadata instanceof VmResource.ScriptHolder) {
            return ActionMode.FORMAT;
        }
        if (metadata instanceof MetadataImpl) {
            return ActionMode.DELETE_FORMATTED;
        }
        return ActionMode.UNAPPLICABLE;
    }

    private static enum ActionMode {
        FORMAT,
        DELETE_FORMATTED,
        UNAPPLICABLE;

    }

    private abstract class ActionRunnableImpl
    implements SelectionBasedAction.ActionRunnable {
        private final List<? extends ResourceData> resourceDataList;

        ActionRunnableImpl(List<? extends ResourceData> resourceDataList) {
            this.resourceDataList = resourceDataList;
        }

        @Override
        public void run(final Shell shell, final IWorkbenchPart workbenchPart) {
            Job job = new Job(TemporarilyFormatSourceAction.this.getAction().getText()){

                protected IStatus run(IProgressMonitor monitor) {
                    int i = 0;
                    while (i < ActionRunnableImpl.this.resourceDataList.size()) {
                        ResourceData resourceData = (ResourceData)ActionRunnableImpl.this.resourceDataList.get(i);
                        try {
                            ActionRunnableImpl.this.runInWorkerThread(resourceData, shell, workbenchPart, i == 0);
                        }
                        catch (CoreException e) {
                            throw new RuntimeException(e);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        ++i;
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }

        protected abstract void runInWorkerThread(ResourceData var1, Shell var2, IWorkbenchPart var3, boolean var4) throws CoreException, IOException;
    }

    private class DeleteFormattedActionRunnable
    extends ActionRunnableImpl {
        DeleteFormattedActionRunnable(List<? extends ResourceData> resourceDataList) {
            super(resourceDataList);
        }

        @Override
        public void adjustAction() {
            TemporarilyFormatSourceAction.this.modifyActionText(Messages.TemporarilyFormatSourceAction_DELETE_FORMATTER_ACTION_NAME);
        }

        @Override
        protected void runInWorkerThread(ResourceData resourceData, Shell shell, IWorkbenchPart workbenchPart, boolean highlightResult) throws CoreException, IOException {
            MetadataImpl metadataImpl = (MetadataImpl)resourceData.getVmResource().getMetadata();
            metadataImpl.mappingHandle.delete();
            resourceData.getVmResource().deleteResourceAndFile();
        }
    }

    private class FormatActionRunnable
    extends ActionRunnableImpl {
        private final JavaScriptFormatter formatter;

        FormatActionRunnable(List<? extends ResourceData> resourceDataList, JavaScriptFormatter formatter) {
            super(resourceDataList);
            this.formatter = formatter;
        }

        @Override
        public void adjustAction() {
            TemporarilyFormatSourceAction.this.restoreActionText();
        }

        @Override
        protected void runInWorkerThread(ResourceData data, Shell shell, IWorkbenchPart workbenchPart, boolean highlightResult) throws CoreException, IOException {
            SourcePositionMapBuilder.MappingHandle mappingHandle;
            byte[] sourceBytes = ChromiumDebugPluginUtil.readFileContents((IFile)data.getFile());
            String sourceString = new String(sourceBytes);
            JavaScriptFormatter.Result result = this.formatter.format(sourceString);
            WorkspaceBridge workspaceRelations = data.getConnectedTargetData().getWorkspaceRelations();
            String proposedFileName = String.valueOf(data.getVmResource().getLocalVisibleFileName()) + Messages.TemporarilyFormatSourceAction_FORMATTER_SUFFIX;
            MetadataImpl metadata = new MetadataImpl();
            VmResource formattedResource = workspaceRelations.createTemporaryFile((VmResource.Metadata)metadata, proposedFileName);
            try {
                SourcePositionMapBuilder builder = data.getConnectedTargetData().getSourcePositionMapBuilder();
                StringMappingData vmTextData = result.getInputTextData();
                StringMappingData originalTextData = result.getFormattedTextData();
                SourcePositionMapBuilder.ResourceSection vmResourceSection = new SourcePositionMapBuilder.ResourceSection(data.getVmResource().getId(), 0, 0, vmTextData.getEndLine(), vmTextData.getEndColumn());
                SourcePositionMapBuilder.ResourceSection originalResourceSection = new SourcePositionMapBuilder.ResourceSection(formattedResource.getId(), 0, 0, originalTextData.getEndLine(), originalTextData.getEndColumn());
                TextSectionMappingImpl mapTable = new TextSectionMappingImpl(originalTextData, vmTextData);
                mappingHandle = builder.addMapping(originalResourceSection, vmResourceSection, (TextSectionMapping)mapTable);
            }
            catch (SourcePositionMapBuilder.CannotAddException e) {
                formattedResource.deleteResourceAndFile();
                throw new RuntimeException(e);
            }
            metadata.mappingHandle = mappingHandle;
            ChromiumDebugPluginUtil.writeFile((IFile)formattedResource.getVProjectFile(), (String)result.getFormattedText());
            if (highlightResult) {
                this.highlightResult(formattedResource, workbenchPart, shell);
            }
        }

        private void highlightResult(final VmResource formattedResource, final IWorkbenchPart workbenchPart, Shell shell) {
            shell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (workbenchPart instanceof IShowInTarget) {
                        IShowInTarget showInTarget = (IShowInTarget)workbenchPart;
                        ShowInContext showInContext = new ShowInContext((Object)formattedResource.getVProjectFile(), null);
                        showInTarget.show(showInContext);
                    } else {
                        FormatActionRunnable.this.openFileInEditorAsync(formattedResource, workbenchPart.getSite().getWorkbenchWindow());
                    }
                }
            });
        }

        private void openFileInEditorAsync(VmResource formattedResource, IWorkbenchWindow workbenchWindow) {
            IEditorInput input = JsDebugModelPresentation.toEditorInput(formattedResource.getVProjectFile());
            try {
                workbenchWindow.getActivePage().openEditor(input, "org.eclipse.wst.jsdt.chromium.debug.ui.editors.JsEditor");
            }
            catch (PartInitException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class MetadataImpl
    implements VmResource.Metadata {
        SourcePositionMapBuilder.MappingHandle mappingHandle;

        private MetadataImpl() {
        }
    }

    static class ResourceData {
        private final IFile file;
        private final VmResource vmResource;
        private final ConnectedTargetData connectedTargetData;

        ResourceData(IFile file, VmResource vmResource, ConnectedTargetData connectedTargetData) {
            this.file = file;
            this.vmResource = vmResource;
            this.connectedTargetData = connectedTargetData;
        }

        IFile getFile() {
            return this.file;
        }

        public VmResource getVmResource() {
            return this.vmResource;
        }

        public ConnectedTargetData getConnectedTargetData() {
            return this.connectedTargetData;
        }
    }
}

