/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wst.jsdt.chromium.debug.core.model.Messages;

class ChromiumTabSelectionDialog
extends Dialog {
    private final List<String> urls;
    private Table table;
    private int selectedLine = -1;

    ChromiumTabSelectionDialog(Shell shell, List<String> urls) {
        super(shell);
        this.urls = urls;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.ChromiumTabSelectionDialog_DialogTitle);
    }

    public int open() {
        return super.open();
    }

    public void create() {
        super.create();
        this.updateOkButton();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        label.setText(Messages.ChromiumTabSelectionDialog_TableTitle);
        this.table = new Table(composite, 268437508);
        this.table.setLayoutData((Object)new GridData(1808));
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.setItemCount(10);
        TableColumn urlColumn = new TableColumn(this.table, 0);
        urlColumn.setText(Messages.ChromiumTabSelectionDialog_UrlColumnName);
        urlColumn.setWidth(400);
        this.table.addListener(36, new Listener(){

            public void handleEvent(Event event) {
                if (ChromiumTabSelectionDialog.this.table.isDisposed()) {
                    return;
                }
                this.processData(event);
            }

            private void processData(Event event) {
                TableItem item = (TableItem)event.item;
                int index = ChromiumTabSelectionDialog.this.table.indexOf(item);
                if (index < ChromiumTabSelectionDialog.this.urls.size()) {
                    item.setText((String)ChromiumTabSelectionDialog.this.urls.get(index));
                    GridData data = new GridData();
                    data.grabExcessHorizontalSpace = true;
                    item.setData((Object)data);
                    if (index == 0) {
                        ChromiumTabSelectionDialog.this.table.select(0);
                    }
                }
            }
        });
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ChromiumTabSelectionDialog.this.okPressed();
            }

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.table.setItemCount(this.urls.size());
        this.table.clearAll();
        return composite;
    }

    private void updateOkButton() {
        this.getButton(0).setEnabled(this.urls.size() != 0);
    }

    protected void okPressed() {
        this.selectedLine = this.table.getSelectionIndex();
        super.okPressed();
    }

    int getSelectedLine() {
        return this.selectedLine;
    }
}

