/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.section;

import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.ClassButtonDialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.ComboDialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.DialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.IDialogFieldApplyListener;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.IDialogFieldChangeListener;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.LayoutUtil;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.StringDialogField;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanNameType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanScopeType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanType;
import org.eclipse.jst.jsf.facesconfig.ui.EditorMessages;
import org.eclipse.jst.jsf.facesconfig.ui.page.IFacesConfigPage;
import org.eclipse.jst.jsf.facesconfig.ui.section.AbstractFacesConfigSection;
import org.eclipse.jst.jsf.facesconfig.ui.section.ManagedBeanScopeTreeItem;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ManagedBeanGeneralSection
extends AbstractFacesConfigSection {
    private StringDialogField mbNameField;
    private ClassButtonDialogField mbClassField;
    private ComboDialogField mbScopeField;
    private ManagedBeanGeneralSectionAdapter managedBeanGeneralSectionAdapter;

    public ManagedBeanGeneralSection(Composite parent, IManagedForm managedForm, IFacesConfigPage page, FormToolkit toolkit) {
        super(parent, managedForm, page, toolkit, null, null);
        this.getSection().setText(EditorMessages.ManagedBeanGeneralSection_Name);
        this.getSection().setDescription(EditorMessages.ManagedBeanGeneralSection_Desc);
    }

    @Override
    protected void createContents(Composite container, FormToolkit toolkit) {
        int numberOfColumns = 4;
        GridLayout layout = new GridLayout(numberOfColumns, false);
        container.setLayout((Layout)layout);
        toolkit.paintBordersFor(container);
        this.createMBNameEntry(container, toolkit, numberOfColumns);
        this.createMBClassEntry(container, toolkit, numberOfColumns);
        this.createMBScopeEntry(container, toolkit, numberOfColumns);
    }

    private void createMBNameEntry(Composite container, FormToolkit toolkit, int numberOfColumns) {
        this.mbNameField = new StringDialogField();
        this.mbNameField.setLabelText(EditorMessages.ManagedBeanGeneralSection_ManagedBeanName);
        this.mbNameField.doFillIntoGrid(toolkit, container, numberOfColumns);
        LayoutUtil.setHorizontalGrabbing((Control)this.mbNameField.getTextControl(toolkit, container));
        this.mbNameField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                String mbNameValue = ((StringDialogField)field).getText();
                Command cmd = null;
                ManagedBeanType managedBean = (ManagedBeanType)ManagedBeanGeneralSection.this.getInput();
                ManagedBeanNameType newManagedBeanName = FacesConfigFactory.eINSTANCE.createManagedBeanNameType();
                newManagedBeanName.setTextContent(mbNameValue);
                cmd = SetCommand.create((EditingDomain)ManagedBeanGeneralSection.this.getEditingDomain(), (Object)managedBean, (Object)FacesConfigPackage.eINSTANCE.getManagedBeanType_ManagedBeanName(), (Object)newManagedBeanName);
                if (cmd.canExecute()) {
                    ManagedBeanGeneralSection.this.getEditingDomain().getCommandStack().execute(cmd);
                }
            }
        });
    }

    private void createMBClassEntry(Composite container, FormToolkit toolkit, int numberOfColumns) {
        this.mbClassField = new ClassButtonDialogField(null);
        this.mbClassField.setLabelText(EditorMessages.ManagedBeanGeneralSection_ManagedBeanClass);
        this.mbClassField.setProject((IProject)this.getPage().getEditor().getAdapter(IProject.class));
        this.mbClassField.doFillIntoGrid(toolkit, container, numberOfColumns);
        LayoutUtil.setHorizontalGrabbing((Control)this.mbClassField.getTextControl(toolkit, container));
        this.mbClassField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                String newValue = ((StringDialogField)field).getText();
                Command cmd = null;
                ManagedBeanType managedBean = (ManagedBeanType)ManagedBeanGeneralSection.this.getInput();
                ManagedBeanClassType newManagedBeanClass = FacesConfigFactory.eINSTANCE.createManagedBeanClassType();
                newManagedBeanClass.setTextContent(newValue);
                cmd = SetCommand.create((EditingDomain)ManagedBeanGeneralSection.this.getEditingDomain(), (Object)managedBean, (Object)FacesConfigPackage.eINSTANCE.getManagedBeanType_ManagedBeanClass(), (Object)newManagedBeanClass);
                if (cmd.canExecute()) {
                    ManagedBeanGeneralSection.this.getEditingDomain().getCommandStack().execute(cmd);
                }
            }
        });
    }

    private void createMBScopeEntry(Composite container, FormToolkit toolkit, int numberOfColumns) {
        this.mbScopeField = new ComboDialogField(2060);
        this.mbScopeField.setLabelText(EditorMessages.ManagedBeanGeneralSection_ManagedBeanScope);
        this.mbScopeField.doFillIntoGrid(toolkit, container, numberOfColumns);
        LayoutUtil.setHorizontalGrabbing((Control)this.mbScopeField.getComboControl(toolkit, container));
        this.mbScopeField.setItems(ManagedBeanScopeTreeItem.scopeItems);
        this.mbScopeField.setDialogFieldChangeListener(new IDialogFieldChangeListener(){

            public void dialogFieldChanged(DialogField field) {
                String newValue = ((ComboDialogField)field).getText();
                Command cmd = null;
                ManagedBeanType managedBean = (ManagedBeanType)ManagedBeanGeneralSection.this.getInput();
                ManagedBeanScopeType newManagedBeanScope = FacesConfigFactory.eINSTANCE.createManagedBeanScopeType();
                newManagedBeanScope.setTextContent(newValue);
                cmd = SetCommand.create((EditingDomain)ManagedBeanGeneralSection.this.getEditingDomain(), (Object)managedBean, (Object)FacesConfigPackage.eINSTANCE.getManagedBeanType_ManagedBeanScope(), (Object)newManagedBeanScope);
                if (cmd.canExecute()) {
                    ManagedBeanGeneralSection.this.getEditingDomain().getCommandStack().execute(cmd);
                }
            }
        });
    }

    @Override
    public void refreshAll() {
        this.refresh();
    }

    @Override
    public void refresh() {
        super.refresh();
        Object input = this.getInput();
        if (input instanceof ManagedBeanType) {
            ManagedBeanType component = (ManagedBeanType)input;
            this.refreshControls(component);
        }
    }

    private void refreshControls(ManagedBeanType component) {
        if (component.getManagedBeanName() != null) {
            this.mbNameField.setTextWithoutUpdate(component.getManagedBeanName().getTextContent());
        } else {
            this.mbNameField.setTextWithoutUpdate("");
        }
        if (component.getManagedBeanClass() != null) {
            this.mbClassField.setTextWithoutUpdate(component.getManagedBeanClass().getTextContent());
        } else {
            this.mbClassField.setTextWithoutUpdate("");
        }
        if (component.getManagedBeanScope() != null) {
            this.mbScopeField.setTextWithoutUpdate(component.getManagedBeanScope().getTextContent());
        } else {
            this.mbScopeField.setTextWithoutUpdate("session");
        }
    }

    @Override
    protected void addAdaptersOntoInput(Object newInput) {
        super.addAdaptersOntoInput(newInput);
        ManagedBeanType managedBean = (ManagedBeanType)newInput;
        if (EcoreUtil.getExistingAdapter((Notifier)managedBean, ManagedBeanGeneralSection.class) == null) {
            managedBean.eAdapters().add((Object)this.getManagedBeanGeneralSectionAdatper());
        }
    }

    @Override
    protected void removeAdaptersFromInput(Object oldInput) {
        super.removeAdaptersFromInput(oldInput);
        ManagedBeanType managedBean = (ManagedBeanType)oldInput;
        if (EcoreUtil.getExistingAdapter((Notifier)managedBean, ManagedBeanGeneralSection.class) != null) {
            managedBean.eAdapters().remove((Object)this.getManagedBeanGeneralSectionAdatper());
        }
    }

    private ManagedBeanGeneralSectionAdapter getManagedBeanGeneralSectionAdatper() {
        if (this.managedBeanGeneralSectionAdapter == null) {
            this.managedBeanGeneralSectionAdapter = new ManagedBeanGeneralSectionAdapter();
        }
        return this.managedBeanGeneralSectionAdapter;
    }

    class ManagedBeanGeneralSectionAdapter
    extends AdapterImpl {
        ManagedBeanGeneralSectionAdapter() {
        }

        public boolean isAdapterForType(Object type) {
            return type == ManagedBeanGeneralSection.class;
        }

        public void notifyChanged(Notification msg) {
            if (!(msg.getEventType() != 3 && msg.getEventType() != 4 && msg.getEventType() != 1 || msg.getFeature() != FacesConfigPackage.eINSTANCE.getManagedBeanType_ManagedBeanName() && msg.getFeature() != FacesConfigPackage.eINSTANCE.getManagedBeanType_ManagedBeanClass() && msg.getFeature() != FacesConfigPackage.eINSTANCE.getManagedBeanType_ManagedBeanScope())) {
                if (Thread.currentThread() == PlatformUI.getWorkbench().getDisplay().getThread()) {
                    ManagedBeanGeneralSection.this.refresh();
                } else {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ManagedBeanGeneralSection.this.refresh();
                        }
                    });
                }
            }
        }
    }
}

