/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.core.internal.text;

import java.util.NoSuchElementException;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;

public class RegionIterator {
    private int currentIndex;
    private ITextRegionList regions;
    private ITextRegion startRegion;
    private ITextRegion endRegion;

    public RegionIterator(IStructuredDocumentRegion node) {
        this(node, node.getStart(), node.getEnd());
    }

    public RegionIterator(IStructuredDocumentRegion node, int startOffset, int endOffset) {
        this.regions = node.getRegions();
        this.startRegion = node.getRegionAtCharacterOffset(startOffset);
        this.endRegion = node.getRegionAtCharacterOffset(endOffset - 1);
        int i = 0;
        while (i < this.regions.size()) {
            ITextRegion region = this.regions.get(i);
            if (this.startRegion == region) {
                this.currentIndex = i;
                break;
            }
            ++i;
        }
    }

    public RegionIterator(ITextRegionList regions) {
        this.regions = regions;
        this.startRegion = regions.get(0);
        this.endRegion = regions.get(regions.size() - 1);
        this.currentIndex = 0;
    }

    public boolean hasNext() {
        if (this.currentIndex < this.regions.size()) {
            return this.currentIndex <= this.regions.indexOf(this.endRegion);
        }
        return false;
    }

    public boolean hasPrevious() {
        if (this.currentIndex >= 0) {
            return this.currentIndex >= this.regions.indexOf(this.startRegion);
        }
        return false;
    }

    public ITextRegion next() {
        if (this.hasNext()) {
            return this.regions.get(this.currentIndex++);
        }
        throw new NoSuchElementException();
    }

    public ITextRegion previous() {
        if (this.hasPrevious()) {
            return this.regions.get(--this.currentIndex);
        }
        throw new NoSuchElementException();
    }
}

