/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.internal.ui;

import java.io.ByteArrayOutputStream;
import org.eclipse.wst.common.snippets.core.ISnippetItem;
import org.eclipse.wst.common.snippets.core.ISnippetVariable;
import org.eclipse.wst.common.snippets.core.ISnippetsEntry;
import org.eclipse.wst.common.snippets.internal.Logger;
import org.eclipse.wst.common.snippets.internal.palette.SnippetPaletteDrawer;
import org.eclipse.wst.common.snippets.internal.palette.SnippetPaletteItem;
import org.eclipse.wst.common.snippets.internal.palette.SnippetVariable;
import org.eclipse.wst.common.snippets.internal.util.CommonXML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EntrySerializer {
    private static EntrySerializer writer = null;

    public static synchronized EntrySerializer getInstance() {
        if (writer == null) {
            writer = new EntrySerializer();
        }
        return writer;
    }

    private EntrySerializer() {
    }

    private static void assignEntryProperties(ISnippetsEntry entry, Element owningElement) {
        if (entry instanceof SnippetPaletteItem) {
            SnippetPaletteItem item = (SnippetPaletteItem)entry;
            owningElement.setAttribute("id", item.getId());
            if (item.getSmallIconName() != null) {
                owningElement.setAttribute("smallicon", item.getSmallIconName());
            }
        }
        if (entry instanceof SnippetPaletteDrawer) {
            SnippetPaletteDrawer drawer = (SnippetPaletteDrawer)entry;
            owningElement.setAttribute("id", drawer.getId());
            if (drawer.getSmallIconName() != null) {
                owningElement.setAttribute("smallicon", drawer.getSmallIconName());
            }
        }
        if (entry.getDescription() != null) {
            owningElement.appendChild(EntrySerializer.createDescription(owningElement.getOwnerDocument(), entry.getDescription()));
        }
        if (entry.getLabel() != null) {
            owningElement.setAttribute("label", entry.getLabel());
        }
    }

    private static Element createCategory(Document doc, SnippetPaletteDrawer category) {
        Element element = doc.createElement("category");
        EntrySerializer.assignEntryProperties(category, element);
        int i = 0;
        while (i < category.getChildren().size()) {
            SnippetPaletteItem item = (SnippetPaletteItem)category.getChildren().get(i);
            Element child = EntrySerializer.createItem(doc, item);
            element.appendChild(child);
            ++i;
        }
        if (Logger.DEBUG_DEFINITION_PERSISTENCE) {
            System.out.println("User item writer saving category " + category.getId());
        }
        return element;
    }

    private static Element createContent(Document doc, ISnippetItem item) {
        Element element = doc.createElement("content");
        element.appendChild(doc.createCDATASection(item.getContentString()));
        return element;
    }

    private static Element createDescription(Document doc, String description) {
        Element element = doc.createElement("description");
        if (description != null) {
            element.appendChild(doc.createCDATASection(description));
        } else {
            element.appendChild(doc.createCDATASection(""));
        }
        return element;
    }

    private static Element createItem(Document doc, SnippetPaletteItem item) {
        Element element = doc.createElement("item");
        EntrySerializer.assignEntryProperties(item, element);
        if (item.getCategory() != null) {
            element.setAttribute("category", ((SnippetPaletteDrawer)item.getCategory()).getId());
        }
        if (item.getClassName() != null) {
            element.setAttribute("class", item.getClassName());
        }
        if (item.getEditorClassName() != null) {
            element.setAttribute("editorclass", item.getEditorClassName());
        }
        if (item.getProvider() != null) {
            element.setAttribute("snippetProvider", item.getProvider().getId());
        }
        if (item.getContentString() != null) {
            element.appendChild(EntrySerializer.createContent(doc, item));
        }
        ISnippetVariable[] variables = item.getVariables();
        int i = 0;
        while (i < variables.length) {
            Element variable = EntrySerializer.createVariable(doc, variables[i]);
            element.appendChild(variable);
            ++i;
        }
        if (Logger.DEBUG_DEFINITION_PERSISTENCE) {
            System.out.println("User item writer saving item " + ((SnippetPaletteDrawer)item.getCategory()).getId() + ":" + item.getId());
        }
        return element;
    }

    private static Element createVariable(Document doc, ISnippetVariable variable) {
        Element element = doc.createElement("variable");
        element.setAttribute("id", ((SnippetVariable)variable).getId());
        if (variable.getName() != null) {
            element.setAttribute("name", variable.getName());
        }
        if (variable.getDefaultValue() != null) {
            element.setAttribute("default", variable.getDefaultValue());
        }
        if (variable.getDescription() != null) {
            element.appendChild(EntrySerializer.createDescription(doc, variable.getDescription()));
        }
        return element;
    }

    public byte[] toXML(ISnippetsEntry entry) {
        Document document = CommonXML.getDocumentBuilder().getDOMImplementation().createDocument(null, "snippets", null);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        if (entry instanceof ISnippetItem) {
            SnippetPaletteItem item = (SnippetPaletteItem)entry;
            Element itemElement = EntrySerializer.createItem(document, item);
            document.getDocumentElement().appendChild(itemElement);
        } else {
            SnippetPaletteDrawer category = (SnippetPaletteDrawer)entry;
            Element categoryElement = EntrySerializer.createCategory(document, category);
            document.getDocumentElement().appendChild(categoryElement);
        }
        try {
            CommonXML.serialize(document, output);
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        return output.toByteArray();
    }
}

