/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.persistence;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jpt.common.ui.JptCommonUiMessages;
import org.eclipse.jpt.common.ui.internal.jface.ResourceManagerLabelProvider;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.model.value.CollectionPropertyValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimpleCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.internal.transformer.AbstractTransformer;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiableCollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.context.persistence.ClassRef;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.ui.JavaManagedTypeUiDefinition;
import org.eclipse.jpt.jpa.ui.JpaPlatformUi;
import org.eclipse.jpt.jpa.ui.JptJpaUiImages;
import org.eclipse.jpt.jpa.ui.PersistenceResourceUiDefinition;
import org.eclipse.jpt.jpa.ui.internal.JpaHelpContextIds;
import org.eclipse.jpt.jpa.ui.internal.plugin.JptJpaUiPlugin;
import org.eclipse.jpt.jpa.ui.persistence.JptJpaUiPersistenceMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;

public class PersistenceUnitClassesComposite
extends Pane<PersistenceUnit> {
    private static final Transformer<ClassRef, ImageDescriptor> CLASS_REF_LABEL_IMAGE_DESCRIPTOR_TRANSFORMER = new ClassRefLabelImageDescriptorTransformer();
    private static final Transformer<ClassRef, String> CLASS_REF_LABEL_TEXT_TRANSFORMER = new ClassRefLabelTextTransformer();

    public PersistenceUnitClassesComposite(Pane<? extends PersistenceUnit> parent, Composite parentComposite) {
        super(parent, parentComposite);
    }

    protected void initializeLayout(Composite container) {
        new AddRemoveListPane((Pane)this, container, this.buildAddRemovePaneAdapter(), this.buildItemListModel(), this.buildSelectedItemsModel(), this.buildClassRefLabelProvider(), JpaHelpContextIds.PERSISTENCE_XML_GENERAL);
        this.addTriStateCheckBoxWithDefault(container, JptJpaUiPersistenceMessages.PERSISTENCE_UNIT_CLASSES_COMPOSITE_EXCLUDE_UNLISTED_CLASSES, this.buildExcludeUnlistedClassesModel(), this.buildExcludeUnlistedClassesStringModel(), JpaHelpContextIds.PERSISTENCE_XML_GENERAL);
    }

    protected ClassRef addClassRef() {
        IType type = this.chooseType();
        if (type != null) {
            String className = type.getFullyQualifiedName('$');
            if (this.classRefExists(className)) {
                return null;
            }
            return ((PersistenceUnit)this.getSubject()).addSpecifiedClassRef(className);
        }
        return null;
    }

    private boolean classRefExists(String className) {
        for (ClassRef classRef : ((PersistenceUnit)this.getSubject()).getSpecifiedClassRefs()) {
            if (!classRef.getClassName().equals(className)) continue;
            return true;
        }
        return false;
    }

    private AddRemovePane.Adapter<ClassRef> buildAddRemovePaneAdapter() {
        return new AddRemovePane.AbstractAdapter<ClassRef>(){

            public ClassRef addNewItem() {
                return PersistenceUnitClassesComposite.this.addClassRef();
            }

            public PropertyValueModel<Boolean> buildOptionalButtonEnabledModel(CollectionValueModel<ClassRef> selectedItemsModel) {
                return new CollectionPropertyValueModelAdapter<Boolean, ClassRef>(selectedItemsModel){

                    protected Boolean buildValue() {
                        if (this.collectionModel.size() == 1) {
                            ClassRef classRef = (ClassRef)this.collectionModel.iterator().next();
                            return PersistenceUnitClassesComposite.this.findType(classRef) != null;
                        }
                        return Boolean.FALSE;
                    }
                };
            }

            public boolean hasOptionalButton() {
                return true;
            }

            public String optionalButtonText() {
                return JptJpaUiPersistenceMessages.PERSISTENCE_UNIT_CLASSES_COMPOSITE_OPEN;
            }

            public void optionOnSelection(CollectionValueModel<ClassRef> selectedItemsModel) {
                PersistenceUnitClassesComposite.this.openMappedClass((ClassRef)selectedItemsModel.iterator().next());
            }

            public void removeSelectedItems(CollectionValueModel<ClassRef> selectedItemsModel) {
                ((PersistenceUnit)PersistenceUnitClassesComposite.this.getSubject()).removeSpecifiedClassRefs(selectedItemsModel);
            }
        };
    }

    private ModifiablePropertyValueModel<Boolean> buildExcludeUnlistedClassesModel() {
        return new PropertyAspectAdapter<PersistenceUnit, Boolean>(this.getSubjectHolder(), new String[]{"specifiedExcludeUnlistedClasses"}){

            protected Boolean buildValue_() {
                return ((PersistenceUnit)this.subject).getSpecifiedExcludeUnlistedClasses();
            }

            protected void setValue_(Boolean value) {
                ((PersistenceUnit)this.subject).setSpecifiedExcludeUnlistedClasses(value);
            }
        };
    }

    private PropertyValueModel<String> buildExcludeUnlistedClassesStringModel() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildDefaultExcludeUnlistedClassesModel()){

            protected String transform(Boolean v) {
                if (v != null) {
                    String defaultStringValue = v != false ? JptCommonUiMessages.BOOLEAN_TRUE : JptCommonUiMessages.BOOLEAN_FALSE;
                    return NLS.bind((String)JptJpaUiPersistenceMessages.PERSISTENCE_UNIT_CLASSES_COMPOSITE_EXCLUDE_UNLISTED_CLASSES_WITH_DEFAULT, (Object)defaultStringValue);
                }
                return JptJpaUiPersistenceMessages.PERSISTENCE_UNIT_CLASSES_COMPOSITE_EXCLUDE_UNLISTED_CLASSES;
            }
        };
    }

    private PropertyValueModel<Boolean> buildDefaultExcludeUnlistedClassesModel() {
        return new PropertyAspectAdapter<PersistenceUnit, Boolean>(this.getSubjectHolder(), new String[]{"specifiedExcludeUnlistedClasses", "defaultExcludeUnlistedClasses"}){

            protected Boolean buildValue_() {
                if (((PersistenceUnit)this.subject).getSpecifiedExcludeUnlistedClasses() != null) {
                    return null;
                }
                return ((PersistenceUnit)this.subject).getDefaultExcludeUnlistedClasses();
            }
        };
    }

    private ILabelProvider buildClassRefLabelProvider() {
        return new ResourceManagerLabelProvider(CLASS_REF_LABEL_IMAGE_DESCRIPTOR_TRANSFORMER, CLASS_REF_LABEL_TEXT_TRANSFORMER, this.getResourceManager());
    }

    private ListValueModel<ClassRef> buildItemListModel() {
        return new ItemPropertyListValueModelAdapter(this.buildListModel(), new String[]{"javaManagedType", "className"});
    }

    private ListValueModel<ClassRef> buildListModel() {
        return new ListAspectAdapter<PersistenceUnit, ClassRef>(this.getSubjectHolder(), new String[]{"specifiedClassRefs"}){

            protected ListIterable<ClassRef> getListIterable() {
                return ((PersistenceUnit)this.subject).getSpecifiedClassRefs();
            }

            protected int size_() {
                return ((PersistenceUnit)this.subject).getSpecifiedClassRefsSize();
            }
        };
    }

    private ModifiableCollectionValueModel<ClassRef> buildSelectedItemsModel() {
        return new SimpleCollectionValueModel();
    }

    private IType chooseType() {
        SelectionDialog dialog;
        try {
            dialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{this.getJavaProject()}), (int)2, (boolean)false, (String)"");
        }
        catch (JavaModelException ex) {
            JptJpaUiPlugin.instance().logError(ex);
            return null;
        }
        dialog.setTitle(JptCommonUiMessages.CLASS_CHOOSER_PANE__DIALOG_TITLE);
        dialog.setMessage(JptCommonUiMessages.CLASS_CHOOSER_PANE__DIALOG_MESSAGE);
        return dialog.open() == 0 ? (IType)dialog.getResult()[0] : null;
    }

    protected IType findType(ClassRef classRef) {
        String className = classRef.getClassName();
        if (className != null) {
            try {
                return ((PersistenceUnit)this.getSubject()).getJpaProject().getJavaProject().findType(className.replace('$', '.'));
            }
            catch (JavaModelException e) {
                JptJpaUiPlugin.instance().logError(e);
            }
        }
        return null;
    }

    protected void openMappedClass(ClassRef classRef) {
        IType type = this.findType(classRef);
        if (type != null) {
            try {
                IJavaElement javaElement = type.getParent();
                JavaUI.openInEditor((IJavaElement)javaElement, (boolean)true, (boolean)true);
            }
            catch (PartInitException e) {
                JptJpaUiPlugin.instance().logError(e);
            }
            catch (JavaModelException e) {
                JptJpaUiPlugin.instance().logError(e);
            }
        }
    }

    private IJavaProject getJavaProject() {
        return ((PersistenceUnit)this.getSubject()).getJpaProject().getJavaProject();
    }

    static class ClassRefLabelImageDescriptorTransformer
    extends AbstractTransformer<ClassRef, ImageDescriptor> {
        ClassRefLabelImageDescriptorTransformer() {
        }

        protected ImageDescriptor transform_(ClassRef classRef) {
            return this.getImageDescriptor(classRef);
        }

        private ImageDescriptor getImageDescriptor(ClassRef classRef) {
            if (classRef.getJavaManagedType() == null) {
                return JptJpaUiImages.NULL_TYPE_MAPPING;
            }
            JavaManagedTypeUiDefinition def = this.getManagedTypeUiDefinition(classRef);
            return def != null ? def.getImageDescriptor(classRef.getJavaManagedType()) : JptJpaUiImages.NULL_TYPE_MAPPING;
        }

        private JavaManagedTypeUiDefinition getManagedTypeUiDefinition(ClassRef classRef) {
            PersistenceResourceUiDefinition def = this.getPersistenceResourceUiDefinition(classRef);
            return def == null ? null : def.getJavaManagedTypeUiDefinition(classRef.getJavaManagedType().getManagedTypeType());
        }

        private PersistenceResourceUiDefinition getPersistenceResourceUiDefinition(ClassRef classRef) {
            JpaPlatformUi ui = this.getJpaPlatformUi(classRef);
            return ui == null ? null : (PersistenceResourceUiDefinition)this.getJpaPlatformUi(classRef).getResourceUiDefinition(classRef.getResourceType());
        }

        private JpaPlatformUi getJpaPlatformUi(ClassRef classRef) {
            return (JpaPlatformUi)classRef.getJpaPlatform().getAdapter(JpaPlatformUi.class);
        }
    }

    static class ClassRefLabelTextTransformer
    extends AbstractTransformer<ClassRef, String> {
        ClassRefLabelTextTransformer() {
        }

        protected String transform_(ClassRef classRef) {
            String name = classRef.getClassName();
            return name != null ? name : JptJpaUiPersistenceMessages.PERSISTENCE_UNIT_CLASSES_COMPOSITE_CLASS_REF_NO_NAME;
        }
    }
}

