/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.dialogs;

import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.JavaTypeCompletionProcessor;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.orm.EntityMappings;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.ui.JpaPlatformUi;
import org.eclipse.jpt.jpa.ui.JptJpaUiMessages;
import org.eclipse.jpt.jpa.ui.details.MappingUiDefinition;
import org.eclipse.jpt.jpa.ui.internal.plugin.JptJpaUiPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;

public class AddPersistentClassDialog
extends StatusDialog {
    private EntityMappings entityMappings;
    private Text classText;
    private Button classBrowseButton;
    private ComboViewer mappingCombo;
    private OrmPersistentType addedType;

    public AddPersistentClassDialog(Shell parentShell, EntityMappings entityMappings) {
        super(parentShell);
        this.entityMappings = entityMappings;
        this.setTitle(JptJpaUiMessages.ADD_PERSISTENT_CLASS_DIALOG_TITLE);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(dialogArea, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(3, false));
        this.createLabel(composite, JptJpaUiMessages.ADD_PERSISTENT_CLASS_DIALOG_CLASS_LABEL);
        this.classText = this.createText(composite);
        this.classText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddPersistentClassDialog.this.validate();
            }
        });
        this.classBrowseButton = this.createButton(composite, JptJpaUiMessages.GENERAL_BROWSE);
        this.classBrowseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IType type = AddPersistentClassDialog.this.chooseType();
                if (type != null) {
                    AddPersistentClassDialog.this.classText.setText(type.getFullyQualifiedName('$'));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.createLabel(composite, JptJpaUiMessages.ADD_PERSISTENT_CLASS_DIALOG_MAPPING_LABEL);
        this.mappingCombo = new ComboViewer(this.createCombo(composite, 2));
        this.mappingCombo.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ArrayTools.array(this.getTypeMappingUiDefinitions((EntityMappings)inputElement));
            }

            protected Iterable<MappingUiDefinition> getTypeMappingUiDefinitions(EntityMappings entityMappings) {
                JpaPlatformUi ui = AddPersistentClassDialog.this.getJpaPlatformUi();
                return ui != null ? ui.getTypeMappingUiDefinitions(entityMappings.getResourceType()) : IterableTools.emptyIterable();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.mappingCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((MappingUiDefinition)element).getLabel();
            }
        });
        this.mappingCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AddPersistentClassDialog.this.validate();
            }
        });
        this.mappingCombo.setInput((Object)this.entityMappings);
        this.mappingCombo.getCombo().select(0);
        AddPersistentClassDialog.applyDialogFont((Control)dialogArea);
        this.validate();
        return dialogArea;
    }

    private Label createLabel(Composite container, String text) {
        Label label = new Label(container, 0);
        label.setText(text);
        return label;
    }

    private Text createText(Composite container) {
        JavaTypeCompletionProcessor javaTypeCompletionProcessor = new JavaTypeCompletionProcessor(false, false);
        IPackageFragmentRoot pfr = this.getPackageFragmentRoot();
        if (pfr != null) {
            javaTypeCompletionProcessor.setPackageFragment(pfr.getPackageFragment(""));
        }
        Text text = new Text(container, 2052);
        ControlContentAssistHelper.createTextContentAssistant((Text)text, (IContentAssistProcessor)javaTypeCompletionProcessor);
        text.setLayoutData((Object)this.getFieldGridData());
        return text;
    }

    protected GridData getFieldGridData() {
        int margin = FieldDecorationRegistry.getDefault().getMaximumDecorationWidth();
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.widthHint = 200 + margin;
        data.horizontalIndent = margin;
        data.grabExcessHorizontalSpace = true;
        return data;
    }

    protected IPackageFragmentRoot getPackageFragmentRoot() {
        try {
            return this.getJpaProject().getJavaProject().getPackageFragmentRoots()[0];
        }
        catch (JavaModelException ex) {
            JptJpaUiPlugin.instance().logError(ex);
            return null;
        }
    }

    private Button createButton(Composite container, String text) {
        Button button = new Button(container, 0);
        button.setText(text);
        return button;
    }

    private Combo createCombo(Composite container, int span) {
        Combo combo = new Combo(container, 2060);
        GridData gd = this.getFieldGridData();
        gd.horizontalSpan = span;
        combo.setLayoutData((Object)gd);
        return combo;
    }

    protected JpaPlatformUi getJpaPlatformUi() {
        return (JpaPlatformUi)this.entityMappings.getJpaPlatform().getAdapter(JpaPlatformUi.class);
    }

    private JpaProject getJpaProject() {
        return this.entityMappings.getJpaProject();
    }

    public String getClassName() {
        return this.classText.getText();
    }

    public String getMappingKey() {
        StructuredSelection selection = (StructuredSelection)this.mappingCombo.getSelection();
        return selection.isEmpty() ? null : ((MappingUiDefinition)selection.getFirstElement()).getKey();
    }

    protected IType chooseType() {
        SelectionDialog dialog;
        try {
            dialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{this.getJpaProject().getJavaProject()}), (int)2, (boolean)false, (String)this.getClassName());
        }
        catch (JavaModelException ex) {
            JptJpaUiPlugin.instance().logError(ex);
            return null;
        }
        dialog.setTitle(JptJpaUiMessages.ADD_PERSISTENT_CLASS_DIALOG_CLASS_DIALOG_TITLE);
        dialog.setMessage(JptJpaUiMessages.ADD_PERSISTENT_CLASS_DIALOG_CLASS_DIALOG_MESSAGE);
        return dialog.open() == 0 ? (IType)dialog.getResult()[0] : null;
    }

    private void validate() {
        IType type;
        String className = this.getClassName();
        if (StringTools.isBlank((String)className)) {
            this.updateStatus(JptJpaUiPlugin.instance().buildErrorStatus(JptJpaUiMessages.ADD_PERSISTENT_CLASS_DIALOG_NO_CLASS_ERROR));
            return;
        }
        className = className.replace('$', '.');
        try {
            type = this.getJpaProject().getJavaProject().findType(className);
        }
        catch (JavaModelException javaModelException) {
            type = null;
        }
        if (type == null) {
            this.updateStatus(JptJpaUiPlugin.instance().buildWarningStatus(JptJpaUiMessages.ADD_PERSISTENT_CLASS_DIALOG_CLASS_NOT_FOUND_WARNING));
            return;
        }
        if (this.entityMappings.containsManagedType(className)) {
            this.updateStatus(JptJpaUiPlugin.instance().buildWarningStatus(JptJpaUiMessages.ADD_PERSISTENT_CLASS_DIALOG_DUPLICATE_CLASS_WARNING));
            return;
        }
        String mappingKey = this.getMappingKey();
        if (mappingKey == null) {
            this.updateStatus(JptJpaUiPlugin.instance().buildErrorStatus(JptJpaUiMessages.ADD_PERSISTENT_CLASS_DIALOG_NO_MAPPING_KEY_ERROR));
            return;
        }
        this.updateStatus(Status.OK_STATUS);
    }

    protected void okPressed() {
        this.addedType = this.entityMappings.addPersistentType(this.getMappingKey(), this.getClassName());
        super.okPressed();
    }

    public OrmPersistentType openAndReturnType() {
        super.open();
        return this.addedType;
    }
}

