/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.javaee.core.DisplayName;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.javaee.jca.Connector;
import org.eclipse.jst.javaee.jca.ConnectorDeploymentDescriptor;
import org.eclipse.jst.javaee.jca.IConnectorResource;
import org.eclipse.jst.javaee.jca.JcaFactory;
import org.eclipse.jst.jee.model.internal.JEE5ModelProvider;

public class Connector16ModelProvider
extends JEE5ModelProvider {
    private static final String CONNECTOR16_CONTENT_TYPE = "org.eclipse.jst.jee.ee6connectorDD";

    public Connector16ModelProvider(IProject proj) {
        this.proj = proj;
        this.setDefaultResourcePath((IPath)new Path("META-INF/ra.xml"));
    }

    @Override
    public Object getModelObject(IPath modelPath) {
        IConnectorResource connectorRes = (IConnectorResource)this.getModelResource(modelPath);
        if (connectorRes != null && connectorRes.getRootObject() != null) {
            return connectorRes.getConnector();
        }
        return null;
    }

    @Override
    protected String getContentTypeDescriber() {
        return CONNECTOR16_CONTENT_TYPE;
    }

    @Override
    public void populateRoot(XMLResourceImpl res, String name) {
        ConnectorDeploymentDescriptor dd = JcaFactory.eINSTANCE.createConnectorDeploymentDescriptor();
        dd.getXMLNSPrefixMap().put("", "http://java.sun.com/xml/ns/javaee");
        dd.getXMLNSPrefixMap().put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        Connector connector = JcaFactory.eINSTANCE.createConnector();
        DisplayName dn = JavaeeFactory.eINSTANCE.createDisplayName();
        dn.setValue(name);
        connector.getDisplayNames().add(dn);
        String version = J2EEProjectUtilities.getJ2EEProjectVersion((IProject)this.proj);
        if (version != null && version.equals("1.6")) {
            dd.getXSISchemaLocation().put("http://java.sun.com/xml/ns/javaee", "http://java.sun.com/xml/ns/javaee/connector_1_6.xsd");
            connector.setVersion("1.6");
        } else if (version != null && version.equals("2.1")) {
            dd.getXSISchemaLocation().put("http://java.sun.com/xml/ns/javaee", "https://jakarta.ee/xml/ns/jakartaee/connector_2_1.xsd");
            connector.setVersion("2.1");
        } else {
            dd.getXMLNSPrefixMap().put("", "http://xmlns.jcp.org/xml/ns/javaee");
            dd.getXSISchemaLocation().put("http://xmlns.jcp.org/xml/ns/javaee", "http://xmlns.jcp.org/xml/ns/javaee/connector_1_7.xsd");
            connector.setVersion("1.7");
        }
        dd.setConnector(connector);
        res.getContents().add((Object)((EObject)dd));
    }
}

