/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee8.annotations;

import org.eclipse.jetty.annotations.AnnotationParser;
import org.eclipse.jetty.ee8.annotations.AbstractDiscoverableAnnotationHandler;
import org.eclipse.jetty.ee8.annotations.WebFilterAnnotation;
import org.eclipse.jetty.ee8.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebFilterAnnotationHandler
extends AbstractDiscoverableAnnotationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(WebFilterAnnotationHandler.class);

    public WebFilterAnnotationHandler(WebAppContext context) {
        super(context);
    }

    public void handle(AnnotationParser.ClassInfo info, String annotationName) {
        if (annotationName == null || !"javax.servlet.annotation.WebFilter".equals(annotationName)) {
            return;
        }
        WebFilterAnnotation wfAnnotation = new WebFilterAnnotation(this._context, info.getClassName(), info.getContainingResource());
        this.addAnnotation(wfAnnotation);
    }

    public void handle(AnnotationParser.FieldInfo info, String annotationName) {
        if (annotationName == null || !"javax.servlet.annotation.WebFilter".equals(annotationName)) {
            return;
        }
        LOG.warn("@WebFilter not applicable for fields: {}.{}", (Object)info.getClassInfo().getClassName(), (Object)info.getFieldName());
    }

    public void handle(AnnotationParser.MethodInfo info, String annotationName) {
        if (annotationName == null || !"javax.servlet.annotation.WebFilter".equals(annotationName)) {
            return;
        }
        LOG.warn("@WebFilter not applicable for methods: {}.{} {}", new Object[]{info.getClassInfo().getClassName(), info.getMethodName(), info.getSignature()});
    }
}

