/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.ui.internal;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.project.facet.core.ICategory;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IPreset;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.events.IProjectFacetsChangedEvent;
import org.eclipse.wst.common.project.facet.core.internal.ProjectFacet;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.common.project.facet.core.runtime.events.IRuntimeLifecycleEvent;
import org.eclipse.wst.common.project.facet.core.runtime.events.IRuntimeLifecycleListener;
import org.eclipse.wst.common.project.facet.ui.IDecorationsProvider;
import org.eclipse.wst.common.project.facet.ui.ModifyFacetedProjectWizard;
import org.eclipse.wst.common.project.facet.ui.internal.ChangeFacetVersionDialog;
import org.eclipse.wst.common.project.facet.ui.internal.DetailsPanel;
import org.eclipse.wst.common.project.facet.ui.internal.FacetUiPlugin;
import org.eclipse.wst.common.project.facet.ui.internal.RuntimesPanel;
import org.eclipse.wst.common.project.facet.ui.internal.SavePresetDialog;
import org.eclipse.wst.common.project.facet.ui.internal.util.BasicToolTip;
import org.eclipse.wst.common.project.facet.ui.internal.util.GridLayoutUtil;
import org.eclipse.wst.common.project.facet.ui.internal.util.HeaderToolTip;
import org.eclipse.wst.common.project.facet.ui.internal.util.ReadOnlyComboBoxCellEditor;
import org.eclipse.wst.common.project.facet.ui.internal.util.SwtUtil;
import org.osgi.framework.Bundle;

public final class FacetsSelectionPanel
extends Composite
implements ISelectionProvider {
    private static final String IMG_DOWN_ARROW = "##down-arrow##";
    private final Composite topComposite;
    private final SashForm sform1;
    private final SashForm sform2;
    private final Label presetsLabel;
    private final Combo presetsCombo;
    private final Button savePresetButton;
    private final Button deletePresetButton;
    private final CheckboxTreeViewer treeViewer;
    private final Tree tree;
    private final TreeViewerColumn colFacet;
    private final TreeViewerColumn colVersion;
    private final FixedFacetToolTip fixedFacetToolTip;
    private final Menu popupMenu;
    private final MenuItem popupMenuLockUnlock;
    private final MenuItem popupMenuChangeVersion;
    private final TableViewer problemsView;
    private final TabItem detailsTabItem;
    private final DetailsPanel detailsPanel;
    private final TabItem runtimesTabItem;
    private final RuntimesPanel runtimesPanel;
    private boolean showToolTips;
    private final IFacetedProjectWorkingCopy fpjwc;
    private final List<IFacetedProjectListener> registeredWorkingCopyListeners;
    private final Map<IProjectFacet, IProjectFacetVersion> selectedVersions;
    private final List<ISelectionChangedListener> selectionListeners;
    private Object selection;
    private final ImageRegistry imageRegistry;
    private final IRuntimeLifecycleListener runtimeLifecycleListener;

    public FacetsSelectionPanel(Composite parent, IFacetedProjectWorkingCopy fpjwc) {
        super(parent, 0);
        this.fpjwc = fpjwc;
        this.registeredWorkingCopyListeners = new ArrayList<IFacetedProjectListener>();
        this.selectedVersions = new HashMap<IProjectFacet, IProjectFacetVersion>();
        this.selection = null;
        this.selectionListeners = new ArrayList<ISelectionChangedListener>();
        this.showToolTips = false;
        this.imageRegistry = new ImageRegistry();
        Bundle bundle = Platform.getBundle((String)"org.eclipse.wst.common.project.facet.ui");
        URL url = bundle.getEntry("images/down-arrow.gif");
        this.imageRegistry.put(IMG_DOWN_ARROW, ImageDescriptor.createFromURL((URL)url));
        this.setLayout((Layout)GridLayoutUtil.glmargins(GridLayoutUtil.gl(1), 0, 0));
        this.topComposite = new Composite((Composite)this, 0);
        this.topComposite.setLayout((Layout)GridLayoutUtil.glmargins(GridLayoutUtil.gl(4), 0, 0));
        this.presetsLabel = new Label(this.topComposite, 0);
        this.presetsLabel.setText(Resources.presetsLabel);
        this.presetsCombo = new Combo(this.topComposite, 8);
        this.presetsCombo.setLayoutData((Object)GridLayoutUtil.gdhfill());
        this.savePresetButton = new Button(this.topComposite, 8);
        this.savePresetButton.setText(Resources.saveButtonLabel);
        GridDataFactory.defaultsFor((Control)this.savePresetButton).applyTo((Control)this.savePresetButton);
        this.savePresetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FacetsSelectionPanel.this.handleSavePreset();
            }
        });
        this.deletePresetButton = new Button(this.topComposite, 8);
        this.deletePresetButton.setText(Resources.deleteButtonLabel);
        GridDataFactory.defaultsFor((Control)this.deletePresetButton).applyTo((Control)this.deletePresetButton);
        this.deletePresetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FacetsSelectionPanel.this.handleDeletePreset();
            }
        });
        this.sform1 = new SashForm(this.topComposite, 66048);
        this.sform1.setLayoutData((Object)GridLayoutUtil.gdhspan(GridLayoutUtil.gdfill(), 4));
        this.sform2 = new SashForm((Composite)this.sform1, 65792);
        this.sform2.setLayoutData((Object)GridLayoutUtil.gdhspan(GridLayoutUtil.gdfill(), 4));
        this.treeViewer = new CheckboxTreeViewer((Composite)this.sform2, 2048);
        this.tree = this.treeViewer.getTree();
        this.tree.setHeaderVisible(true);
        this.treeViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.treeViewer.setSorter((ViewerSorter)new Sorter());
        this.colFacet = new TreeViewerColumn((TreeViewer)this.treeViewer, 0);
        this.colFacet.getColumn().setText(Resources.facetColumnLabel);
        this.colFacet.getColumn().setResizable(true);
        this.colFacet.setLabelProvider((CellLabelProvider)new FacetColumnLabelProvider());
        this.colFacet.getColumn().setWidth(this.computeDefaultFacetColumnWidth());
        this.colVersion = new TreeViewerColumn((TreeViewer)this.treeViewer, 0);
        this.colVersion.getColumn().setText(Resources.versionColumnLabel);
        this.colVersion.getColumn().setResizable(true);
        this.colVersion.setLabelProvider((CellLabelProvider)new FacetVersionColumnLabelProvider());
        this.colVersion.setEditingSupport((EditingSupport)new FacetVersionColumnEditingSupport((TreeViewer)this.treeViewer));
        this.colVersion.getColumn().setWidth(this.computeDefaultVersionColumnWidth());
        this.popupMenu = new Menu((Decorations)this.getShell(), 8);
        this.popupMenuChangeVersion = new MenuItem(this.popupMenu, 8);
        this.popupMenuChangeVersion.setText(Resources.changeVersionMenuItem);
        this.popupMenuChangeVersion.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FacetsSelectionPanel.this.handleChangeVersionMenuSelected();
            }
        });
        this.popupMenuLockUnlock = new MenuItem(this.popupMenu, 8);
        this.popupMenuLockUnlock.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FacetsSelectionPanel.this.handleFacetLockUnlock();
            }
        });
        new FacetToolTip((Control)this.tree);
        new CategoryToolTip((Control)this.tree);
        this.fixedFacetToolTip = new FixedFacetToolTip((Control)this.tree);
        this.treeViewer.setInput(new Object());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                FacetsSelectionPanel.this.handleSelectionChangedEvent();
            }
        });
        this.treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent e) {
                FacetsSelectionPanel.this.handleCheckStateChanged(e);
            }
        });
        this.tree.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                FacetsSelectionPanel.this.handlePaintItemEvent(event);
            }
        });
        this.tree.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                FacetsSelectionPanel.this.handleMouseDownEvent(event);
            }
        });
        this.tree.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent arg0) {
                FacetsSelectionPanel.this.updatePopupMenu();
            }
        });
        TabFolder tabFolder = new TabFolder((Composite)this.sform2, 0);
        tabFolder.setLayoutData((Object)GridLayoutUtil.gdhhint(GridLayoutUtil.gdhfill(), 80));
        this.detailsPanel = new DetailsPanel((Composite)tabFolder, this);
        this.detailsTabItem = new TabItem(tabFolder, 0);
        this.detailsTabItem.setControl((Control)this.detailsPanel);
        this.detailsTabItem.setText(Resources.detailsTabLabel);
        this.runtimesPanel = new RuntimesPanel((Composite)tabFolder, this.fpjwc);
        this.runtimesTabItem = new TabItem(tabFolder, 0);
        this.runtimesTabItem.setControl((Control)this.runtimesPanel);
        this.runtimesTabItem.setText(Resources.runtimesTabLabel);
        this.problemsView = new TableViewer((Composite)this.sform1, 2048);
        this.problemsView.setContentProvider((IContentProvider)new ProblemsContentProvider());
        this.problemsView.setLabelProvider((IBaseLabelProvider)new ProblemsLabelProvider());
        this.problemsView.setInput(new Object());
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FacetsSelectionPanel.this.handleDisposeEvent();
            }
        });
        Dialog.applyDialogFont((Control)parent);
        this.runtimeLifecycleListener = new IRuntimeLifecycleListener(){

            public void handleEvent(IRuntimeLifecycleEvent event) {
                FacetsSelectionPanel.this.handleValidationProblemsChangedEvent();
            }
        };
        RuntimeManager.addListener((IRuntimeLifecycleListener)this.runtimeLifecycleListener, (IRuntimeLifecycleEvent.Type[])new IRuntimeLifecycleEvent.Type[]{IRuntimeLifecycleEvent.Type.VALIDATION_STATUS_CHANGED});
        this.addWorkingCopyListener(new IFacetedProjectListener(){

            public void handleEvent(IFacetedProjectEvent event) {
                FacetsSelectionPanel.this.handleProjectFacetsChangedEvent(event);
            }
        }, IFacetedProjectEvent.Type.PROJECT_FACETS_CHANGED);
        this.handleProjectFacetsChangedEvent(null);
        this.addWorkingCopyListener(new IFacetedProjectListener(){

            public void handleEvent(IFacetedProjectEvent event) {
                FacetsSelectionPanel.this.handleValidationProblemsChangedEvent();
            }
        }, IFacetedProjectEvent.Type.VALIDATION_PROBLEMS_CHANGED, IFacetedProjectEvent.Type.PROJECT_MODIFIED);
        this.handleValidationProblemsChangedEvent();
        this.addWorkingCopyListener(new IFacetedProjectListener(){

            public void handleEvent(IFacetedProjectEvent event) {
                FacetsSelectionPanel.this.handleSelectedPresetChangedEvent();
            }
        }, IFacetedProjectEvent.Type.SELECTED_PRESET_CHANGED);
        ModifyFacetedProjectWizard.syncWithPresetsModel(this.fpjwc, this.presetsCombo);
        this.addWorkingCopyListener(new IFacetedProjectListener(){

            public void handleEvent(IFacetedProjectEvent event) {
                FacetsSelectionPanel.this.handleModelChangedEvent(event);
            }
        }, IFacetedProjectEvent.Type.FIXED_FACETS_CHANGED, IFacetedProjectEvent.Type.SELECTED_PRESET_CHANGED, IFacetedProjectEvent.Type.TARGETED_RUNTIMES_CHANGED);
        int prefWidthTree = SwtUtil.getPreferredWidth((Control)this.tree);
        int prefWidthRuntimesPanel = SwtUtil.getPreferredWidth((Control)this.runtimesPanel);
        prefWidthRuntimesPanel = Math.max(prefWidthRuntimesPanel, 300);
        int prefWidth = prefWidthTree + prefWidthRuntimesPanel + 80;
        this.topComposite.setLayoutData((Object)GridLayoutUtil.gdwhint(GridLayoutUtil.gdhhint(GridLayoutUtil.gdfill(), 500), prefWidth));
        this.sform1.setWeights(new int[]{70, 30});
        this.sform2.setWeights(new int[]{prefWidthTree, prefWidthRuntimesPanel});
        if (this.tree.getItemCount() > 0) {
            TreeItem firstItem = this.tree.getItem(0);
            this.treeViewer.setSelection((ISelection)new StructuredSelection(firstItem.getData()));
        }
        this.handleSelectionChangedEvent();
    }

    public IFacetedProjectWorkingCopy getFacetedProjectWorkingCopy() {
        return this.fpjwc;
    }

    public boolean isSelectionValid() {
        return this.fpjwc.validate().getSeverity() != 4;
    }

    public boolean setFocus() {
        return this.tree.setFocus();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public ISelection getSelection() {
        if (this.selection != null) {
            return new StructuredSelection(this.selection);
        }
        return new StructuredSelection(new Object[0]);
    }

    public void setSelection(ISelection selection) {
        throw new UnsupportedOperationException();
    }

    private void notifySelectionChangedListeners() {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        for (ISelectionChangedListener listener : this.selectionListeners) {
            listener.selectionChanged(event);
        }
    }

    private ImageRegistry getImageRegistry() {
        return this.imageRegistry;
    }

    public Image getImage(IProjectFacet facet, boolean showDecorations) {
        boolean isFixed = this.getFacetedProjectWorkingCopy().isFixedProjectFacet(facet);
        String id = (isFixed && showDecorations ? "F:" : "f:") + facet.getId();
        Image image = this.getImageRegistry().get(id);
        if (image == null) {
            IDecorationsProvider decprov = (IDecorationsProvider)facet.getAdapter(IDecorationsProvider.class);
            Object imgdesc = decprov.getIcon();
            if (isFixed && showDecorations) {
                imgdesc = new FixedFacetImageDescriptor((ImageDescriptor)imgdesc);
            }
            this.getImageRegistry().put(id, imgdesc);
            image = this.getImageRegistry().get(id);
        }
        return image;
    }

    public Image getImage(ICategory category) {
        String id = "c:" + category.getId();
        Image image = this.getImageRegistry().get(id);
        if (image == null) {
            IDecorationsProvider decprov = (IDecorationsProvider)category.getAdapter(IDecorationsProvider.class);
            ImageDescriptor imgdesc = decprov.getIcon();
            this.getImageRegistry().put(id, imgdesc);
            image = this.getImageRegistry().get(id);
        }
        return image;
    }

    private void refresh() {
        Object[] checked = this.treeViewer.getCheckedElements();
        this.treeViewer.refresh();
        this.treeViewer.setCheckedElements(checked);
    }

    public void setCategoryExpandedState(ICategory category, boolean expanded) {
        this.treeViewer.setExpandedState((Object)category, expanded);
    }

    public boolean getShowToolTips() {
        return this.showToolTips;
    }

    public void setShowToolTips(boolean showToolTips) {
        this.showToolTips = showToolTips;
    }

    private void refreshCategoryState(ICategory category) {
        if (category == null) {
            return;
        }
        int available = 0;
        int selected = 0;
        for (IProjectFacet f : category.getProjectFacets()) {
            if (this.fpjwc.isFacetAvailable(f)) {
                ++available;
            }
            if (!this.fpjwc.hasProjectFacet(f)) continue;
            ++selected;
        }
        if (selected == 0) {
            this.treeViewer.setChecked((Object)category, false);
            this.treeViewer.setGrayed((Object)category, false);
        } else if (selected == available) {
            this.treeViewer.setChecked((Object)category, true);
            this.treeViewer.setGrayed((Object)category, false);
        } else {
            this.treeViewer.setGrayChecked((Object)category, true);
        }
    }

    private void addWorkingCopyListener(IFacetedProjectListener listener, IFacetedProjectEvent.Type ... types) {
        this.fpjwc.addListener(listener, types);
        this.registeredWorkingCopyListeners.add(listener);
    }

    public IProjectFacet getSelectedProjectFacet() {
        IProjectFacetVersion fv = this.getSelectedProjectFacetVersion();
        if (fv != null) {
            return fv.getProjectFacet();
        }
        return null;
    }

    public IProjectFacetVersion getSelectedProjectFacetVersion() {
        if (this.selection != null && this.selection instanceof IProjectFacetVersion) {
            return (IProjectFacetVersion)this.selection;
        }
        return null;
    }

    private IProjectFacetVersion getSelectedVersion(IProjectFacet f) {
        SortedSet availableVersions = this.fpjwc.getAvailableVersions(f);
        if (availableVersions.isEmpty()) {
            throw new IllegalStateException();
        }
        IProjectFacetVersion selectedVersion = this.fpjwc.getProjectFacetVersion(f);
        if (selectedVersion == null) {
            selectedVersion = this.selectedVersions.get(f);
            if (selectedVersion == null) {
                selectedVersion = f.getDefaultVersion();
            }
            if (!availableVersions.contains(selectedVersion)) {
                selectedVersion = this.fpjwc.getHighestAvailableVersion(f);
            }
        }
        this.selectedVersions.put(f, selectedVersion);
        return selectedVersion;
    }

    private void setSelectedVersion(IProjectFacet f, IProjectFacetVersion fv) {
        if (this.fpjwc.getProjectFacetVersion(f) != null) {
            this.fpjwc.changeProjectFacetVersion(fv);
        }
        this.selectedVersions.put(f, fv);
        if (f == this.getSelectedProjectFacet()) {
            this.selection = fv;
            this.notifySelectionChangedListeners();
        }
    }

    private void handleSelectionChangedEvent() {
        Object selection = this.getCurrentSelection();
        if (selection != this.selection) {
            this.selection = selection;
            this.notifySelectionChangedListeners();
        }
    }

    private void handleCheckStateChanged(CheckStateChangedEvent event) {
        Object el = event.getElement();
        boolean checked = event.getChecked();
        if (el instanceof IProjectFacet) {
            IProjectFacet f = (IProjectFacet)el;
            if (this.fpjwc.getFixedProjectFacets().contains(f)) {
                if (!checked) {
                    this.treeViewer.setChecked(el, true);
                    String msg = NLS.bind((String)Resources.couldNotDeselectFixedFacetMessage, (Object)f.getLabel());
                    this.fixedFacetToolTip.setMessage(msg);
                    Point cursorLocation = this.getDisplay().getCursorLocation();
                    this.fixedFacetToolTip.show(this.tree.toControl(cursorLocation));
                }
                return;
            }
            if (checked) {
                this.fpjwc.addProjectFacet(this.getSelectedVersion(f));
            } else {
                this.fpjwc.removeProjectFacet(f);
            }
            this.refreshCategoryState(f.getCategory());
        } else {
            ContentProvider cp = (ContentProvider)this.treeViewer.getContentProvider();
            HashSet<IProjectFacetVersion> facets = new HashSet<IProjectFacetVersion>(this.fpjwc.getProjectFacets());
            Object[] children = cp.getChildren(el);
            int selected = 0;
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                IProjectFacet f = (IProjectFacet)child;
                if (!this.fpjwc.getFixedProjectFacets().contains(f)) {
                    IProjectFacetVersion fv = this.getSelectedVersion(f);
                    if (checked) {
                        facets.add(fv);
                    } else {
                        facets.remove(fv);
                    }
                    this.treeViewer.setChecked((Object)f, checked);
                }
                if (this.fpjwc.hasProjectFacet(f)) {
                    ++selected;
                }
                ++n2;
            }
            if (selected == 0 || selected == children.length) {
                this.treeViewer.setGrayed(el, false);
            } else {
                this.treeViewer.setGrayChecked(el, true);
            }
            this.fpjwc.setProjectFacets(facets);
        }
        this.fpjwc.setSelectedPreset(null);
    }

    private void handleMouseDownEvent(Event event) {
        this.handleMouseDownEventHelper(event, this.tree.getItems());
    }

    private boolean handleMouseDownEventHelper(Event event, TreeItem[] items) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getBounds(1).contains(event.x, event.y)) {
                Object[] newSelection = new TreeItem[]{item};
                if (!Arrays.equals(this.tree.getSelection(), newSelection)) {
                    this.tree.setSelection(new TreeItem[]{item});
                    this.treeViewer.editElement(item.getData(), 1);
                }
                return true;
            }
            if (this.handleMouseDownEventHelper(event, item.getItems())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void handlePaintItemEvent(Event event) {
        IProjectFacet f;
        TreeItem item = (TreeItem)event.item;
        Object itemData = item.getData();
        if (itemData instanceof IProjectFacet && event.index == 1 && this.fpjwc.getAvailableVersions(f = (IProjectFacet)itemData).size() > 1) {
            Image arrowImage = this.getImageRegistry().get(IMG_DOWN_ARROW);
            Rectangle arrowImageBounds = arrowImage.getBounds();
            int columnWidth = this.colVersion.getColumn().getWidth();
            int itemHeight = this.tree.getItemHeight();
            int x = event.x + columnWidth - arrowImageBounds.width - 10;
            int y = event.y;
            event.gc.fillRectangle(x, y, arrowImageBounds.width + 10, itemHeight);
            y = event.y + (itemHeight - arrowImageBounds.height) / 2;
            event.gc.drawImage(arrowImage, x, y);
        }
    }

    private void handleDisposeEvent() {
        this.imageRegistry.dispose();
        for (IFacetedProjectListener listener : this.registeredWorkingCopyListeners) {
            this.fpjwc.removeListener(listener);
        }
        RuntimeManager.removeListener((IRuntimeLifecycleListener)this.runtimeLifecycleListener);
    }

    private void handleSavePreset() {
        Set facets = this.fpjwc.getProjectFacets();
        IPreset preset = SavePresetDialog.showDialog(this.getShell(), facets);
        if (preset != null) {
            this.fpjwc.setSelectedPreset(preset.getId());
        }
    }

    private void handleDeletePreset() {
        IPreset preset = this.fpjwc.getSelectedPreset();
        this.fpjwc.setSelectedPreset(null);
        ProjectFacetsManager.deletePreset((IPreset)preset);
    }

    private void handleProjectFacetsChangedEvent(final IFacetedProjectEvent event) {
        if (!Thread.currentThread().equals(this.getDisplay().getThread())) {
            Runnable uiRunnable = new Runnable(){

                @Override
                public void run() {
                    FacetsSelectionPanel.this.handleProjectFacetsChangedEvent(event);
                }
            };
            this.getDisplay().asyncExec(uiRunnable);
            return;
        }
        HashSet<ICategory> affectedCategories = new HashSet<ICategory>();
        if (event != null) {
            IFacetedProjectWorkingCopy fpjwc = event.getWorkingCopy();
            IProjectFacetsChangedEvent evt = (IProjectFacetsChangedEvent)event;
            for (IProjectFacetVersion fv : evt.getAllAffectedFacets()) {
                IProjectFacet f = fv.getProjectFacet();
                boolean checked = fpjwc.hasProjectFacet(fv);
                this.treeViewer.setChecked((Object)f, checked);
                this.treeViewer.update((Object)f, null);
                ICategory category = f.getCategory();
                if (category == null) continue;
                affectedCategories.add(category);
            }
        } else {
            ArrayList<IProjectFacet> facets = new ArrayList<IProjectFacet>();
            for (IProjectFacetVersion fv : this.fpjwc.getProjectFacets()) {
                facets.add(fv.getProjectFacet());
            }
            this.treeViewer.setCheckedElements(facets.toArray());
            for (IProjectFacet facet : this.fpjwc.getAvailableFacets().keySet()) {
                ICategory category = facet.getCategory();
                if (category == null) continue;
                affectedCategories.add(category);
            }
            this.treeViewer.update(this.fpjwc.getAvailableFacets().keySet().toArray(), null);
        }
        for (ICategory category : affectedCategories) {
            this.refreshCategoryState(category);
        }
    }

    private void handleValidationProblemsChangedEvent() {
        if (!Thread.currentThread().equals(this.getDisplay().getThread())) {
            Runnable uiRunnable = new Runnable(){

                @Override
                public void run() {
                    FacetsSelectionPanel.this.handleValidationProblemsChangedEvent();
                }
            };
            this.getDisplay().asyncExec(uiRunnable);
            return;
        }
        this.problemsView.refresh();
        if (this.getFilteredProblems().length == 0) {
            if (this.sform1.getMaximizedControl() == null) {
                this.sform1.setMaximizedControl((Control)this.sform2);
            }
        } else if (this.sform1.getMaximizedControl() != null) {
            this.sform1.setMaximizedControl(null);
        }
    }

    private void handleSelectedPresetChangedEvent() {
        IPreset preset = this.fpjwc.getSelectedPreset();
        if (preset == null) {
            this.savePresetButton.setEnabled(true);
            this.deletePresetButton.setEnabled(false);
        } else {
            this.savePresetButton.setEnabled(false);
            this.deletePresetButton.setEnabled(preset.getType() == IPreset.Type.USER_DEFINED);
        }
    }

    private void handleModelChangedEvent(IFacetedProjectEvent event) {
        switch (event.getType()) {
            case FIXED_FACETS_CHANGED: 
            case TARGETED_RUNTIMES_CHANGED: {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        FacetsSelectionPanel.this.refresh();
                    }
                };
                SwtUtil.runOnDisplayThread(this.getDisplay(), runnable);
            }
        }
    }

    private void handleChangeVersionMenuSelected() {
        IProjectFacet f = this.getSelectedProjectFacet();
        IProjectFacetVersion fv = this.getSelectedVersion(f);
        SortedSet versions = this.fpjwc.getAvailableVersions(f);
        IProjectFacetVersion newVersion = ChangeFacetVersionDialog.showDialog(this.getShell(), f, fv, versions);
        if (newVersion != null) {
            this.fpjwc.changeProjectFacetVersion(newVersion);
        }
    }

    private void handleFacetLockUnlock() {
        IProjectFacet f = this.getSelectedProjectFacet();
        HashSet<IProjectFacet> fixedFacets = new HashSet<IProjectFacet>(this.fpjwc.getFixedProjectFacets());
        if (fixedFacets.contains(f)) {
            fixedFacets.remove(f);
        } else {
            fixedFacets.add(f);
        }
        this.fpjwc.setFixedProjectFacets(fixedFacets);
    }

    private void updatePopupMenu() {
        Object selection = this.getCurrentSelection();
        if (selection instanceof IProjectFacetVersion) {
            this.tree.setMenu(this.popupMenu);
            IProjectFacet f = ((IProjectFacetVersion)selection).getProjectFacet();
            if (this.fpjwc.isFixedProjectFacet(f)) {
                this.popupMenuLockUnlock.setText(Resources.unlockMenuItem);
            } else {
                this.popupMenuLockUnlock.setText(Resources.lockMenuItem);
            }
            this.popupMenuLockUnlock.setEnabled(this.fpjwc.hasProjectFacet(f));
            int numAvailableVersions = this.fpjwc.getAvailableVersions(f).size();
            this.popupMenuChangeVersion.setEnabled(numAvailableVersions > 1);
        } else {
            this.tree.setMenu(null);
        }
    }

    private Object getCurrentSelection() {
        Object selection = ((IStructuredSelection)this.treeViewer.getSelection()).getFirstElement();
        if (selection != null && selection instanceof IProjectFacet) {
            return this.getSelectedVersion((IProjectFacet)selection);
        }
        return null;
    }

    private TreeItem getTreeItem(int x, int y) {
        return FacetsSelectionPanel.getTreeItemHelper(x, y, this.tree.getItems());
    }

    private static TreeItem getTreeItemHelper(int x, int y, TreeItem[] items) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getBounds().contains(x, y)) {
                return item;
            }
            TreeItem res = FacetsSelectionPanel.getTreeItemHelper(x, y, item.getItems());
            if (res != null) {
                return res;
            }
            ++n2;
        }
        return null;
    }

    private int computeDefaultFacetColumnWidth() {
        GC gc = new GC((Drawable)this.getDisplay());
        int maxFacetLabelWidth = 0;
        try {
            gc.setFont(this.tree.getFont());
            for (IProjectFacet f : ProjectFacetsManager.getProjectFacets()) {
                maxFacetLabelWidth = Math.max(maxFacetLabelWidth, gc.textExtent((String)f.getLabel()).x);
            }
        }
        finally {
            gc.dispose();
        }
        return Math.max(maxFacetLabelWidth + 100, 200);
    }

    private int computeDefaultVersionColumnWidth() {
        int columnLabelWidth;
        GC gc = new GC((Drawable)this.getDisplay());
        int maxVersionStringWidth = 0;
        try {
            gc.setFont(this.tree.getFont());
            for (IProjectFacet f : ProjectFacetsManager.getProjectFacets()) {
                for (IProjectFacetVersion fv : f.getVersions()) {
                    int textExtent = gc.textExtent((String)fv.getVersionString()).x;
                    maxVersionStringWidth = Math.max(maxVersionStringWidth, textExtent + 30);
                }
            }
            columnLabelWidth = gc.textExtent((String)Resources.versionColumnLabel).x + 30;
        }
        finally {
            gc.dispose();
        }
        return Math.max(maxVersionStringWidth, columnLabelWidth);
    }

    private IStatus[] getFilteredProblems() {
        IStatus[] unfiltered = this.fpjwc.validate().getChildren();
        boolean somethingToRemove = false;
        IStatus[] iStatusArray = unfiltered;
        int n = unfiltered.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus st = iStatusArray[n2];
            if (st.getCode() == 1) {
                somethingToRemove = true;
                break;
            }
            ++n2;
        }
        if (!somethingToRemove) {
            return unfiltered;
        }
        ArrayList<IStatus> filtered = new ArrayList<IStatus>();
        IStatus[] iStatusArray2 = unfiltered;
        int n3 = unfiltered.length;
        n = 0;
        while (n < n3) {
            IStatus st = iStatusArray2[n];
            if (st.getCode() != 1) {
                filtered.add(st);
            }
            ++n;
        }
        return filtered.toArray(new IStatus[filtered.size()]);
    }

    private final class CategoryToolTip
    extends HeaderToolTip {
        public CategoryToolTip(Control control) {
            super(control);
        }

        protected final boolean shouldCreateToolTip(Event event) {
            Object treeItemData;
            if (!FacetsSelectionPanel.this.getShowToolTips()) {
                return false;
            }
            TreeItem treeItem = FacetsSelectionPanel.this.getTreeItem(event.x, event.y);
            String description = null;
            if (treeItem != null && treeItem.getBounds(0).contains(event.x, event.y) && (treeItemData = treeItem.getData()) instanceof ICategory) {
                description = ((ICategory)treeItemData).getDescription();
            }
            return description != null && description.trim().length() > 0;
        }

        @Override
        protected String getToolTipTitle(Event event) {
            return ((ICategory)FacetsSelectionPanel.this.getTreeItem(event.x, event.y).getData()).getLabel();
        }

        @Override
        protected Composite createContentArea(Event event, Composite parent) {
            Display display = parent.getDisplay();
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)GridLayoutUtil.gl(1));
            composite.setBackground(display.getSystemColor(29));
            Label label = new Label(composite, 64);
            label.setLayoutData((Object)GridLayoutUtil.gdfill());
            label.setBackground(display.getSystemColor(29));
            ICategory category = (ICategory)FacetsSelectionPanel.this.getTreeItem(event.x, event.y).getData();
            label.setText(category.getDescription());
            return composite;
        }
    }

    private final class ContentProvider
    implements ITreeContentProvider {
        private ContentProvider() {
        }

        public Object[] getElements(Object element) {
            IFacetedProjectWorkingCopy fpjwc = FacetsSelectionPanel.this.getFacetedProjectWorkingCopy();
            ArrayList<Object> list = new ArrayList<Object>();
            Set categories = ProjectFacetsManager.getCategories();
            for (ICategory iCategory : categories) {
                boolean visible = false;
                for (IProjectFacet f : iCategory.getProjectFacets()) {
                    if (fpjwc.getAvailableVersions(f).isEmpty()) continue;
                    visible = true;
                    break;
                }
                if (!visible) continue;
                list.add(iCategory);
            }
            for (Map.Entry entry : fpjwc.getAvailableFacets().entrySet()) {
                IProjectFacet f = (IProjectFacet)entry.getKey();
                SortedSet availableVersions = (SortedSet)entry.getValue();
                if (f.getCategory() != null || availableVersions.isEmpty()) continue;
                list.add(f);
            }
            return list.toArray();
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof ICategory) {
                IFacetedProjectWorkingCopy fpjwc = FacetsSelectionPanel.this.getFacetedProjectWorkingCopy();
                ICategory category = (ICategory)parent;
                ArrayList<IProjectFacet> facets = new ArrayList<IProjectFacet>();
                for (IProjectFacet f : category.getProjectFacets()) {
                    if (fpjwc.getAvailableVersions(f).isEmpty()) continue;
                    facets.add(f);
                }
                return facets.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof IProjectFacet) {
                IProjectFacet f = (IProjectFacet)element;
                return f.getCategory();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof ICategory && !((ICategory)element).getProjectFacets().isEmpty();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldObject, Object newObject) {
        }
    }

    private final class FacetColumnLabelProvider
    extends ColumnLabelProvider {
        private FacetColumnLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof ICategory) {
                return ((ICategory)element).getLabel();
            }
            return ((IProjectFacet)element).getLabel();
        }

        public Image getImage(Object element) {
            if (element instanceof IProjectFacet) {
                return FacetsSelectionPanel.this.getImage((IProjectFacet)element, true);
            }
            return FacetsSelectionPanel.this.getImage((ICategory)element);
        }
    }

    private final class FacetToolTip
    extends HeaderToolTip {
        public FacetToolTip(Control control) {
            super(control);
        }

        protected final boolean shouldCreateToolTip(Event event) {
            Object treeItemData;
            if (!FacetsSelectionPanel.this.getShowToolTips()) {
                return false;
            }
            TreeItem treeItem = FacetsSelectionPanel.this.getTreeItem(event.x, event.y);
            String description = null;
            if (treeItem != null && treeItem.getBounds(0).contains(event.x, event.y) && (treeItemData = treeItem.getData()) instanceof IProjectFacet) {
                description = ((IProjectFacet)treeItemData).getDescription();
            }
            return description != null && description.trim().length() > 0;
        }

        @Override
        protected String getToolTipTitle(Event event) {
            IProjectFacet f = (IProjectFacet)FacetsSelectionPanel.this.getTreeItem(event.x, event.y).getData();
            return FacetsSelectionPanel.this.getSelectedVersion(f).toString();
        }

        @Override
        protected Composite createContentArea(Event event, Composite parent) {
            Display display = parent.getDisplay();
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)GridLayoutUtil.gl(1));
            composite.setBackground(display.getSystemColor(29));
            Label label = new Label(composite, 64);
            label.setLayoutData((Object)GridLayoutUtil.gdfill());
            label.setBackground(display.getSystemColor(29));
            IProjectFacet f = (IProjectFacet)FacetsSelectionPanel.this.getTreeItem(event.x, event.y).getData();
            label.setText(f.getDescription());
            return composite;
        }
    }

    private final class FacetVersionColumnEditingSupport
    extends EditingSupport {
        private final ReadOnlyComboBoxCellEditor ceditor;
        private final IFacetedProjectWorkingCopy fpjwc;

        public FacetVersionColumnEditingSupport(TreeViewer treeViewer) {
            super((ColumnViewer)treeViewer);
            this.ceditor = new ReadOnlyComboBoxCellEditor((Composite)treeViewer.getTree(), new String[0], 12);
            this.fpjwc = FacetsSelectionPanel.this.getFacetedProjectWorkingCopy();
        }

        public boolean canEdit(Object element) {
            return element instanceof IProjectFacet && this.fpjwc.getAvailableVersions((IProjectFacet)element).size() > 1;
        }

        protected CellEditor getCellEditor(Object element) {
            IProjectFacet f = (IProjectFacet)element;
            if (f == null) {
                throw new IllegalStateException();
            }
            SortedSet versions = this.fpjwc.getAvailableVersions(f);
            String[] verstrs = new String[versions.size()];
            Integer value = null;
            int i = 0;
            for (IProjectFacetVersion fv : versions) {
                verstrs[i] = fv.getVersionString();
                if (fv == FacetsSelectionPanel.this.getSelectedVersion(f)) {
                    value = new Integer(i);
                }
                ++i;
            }
            this.ceditor.setItems(verstrs);
            this.ceditor.setValue(value);
            return this.ceditor;
        }

        public Object getValue(Object element) {
            IProjectFacet f = (IProjectFacet)element;
            int i = 0;
            for (IProjectFacetVersion fv : this.fpjwc.getAvailableVersions(f)) {
                if (fv == FacetsSelectionPanel.this.getSelectedVersion(f)) {
                    return new Integer(i);
                }
                ++i;
            }
            return new IllegalStateException();
        }

        public void setValue(Object element, Object value) {
            IProjectFacet f = (IProjectFacet)element;
            int index = (Integer)value;
            if (index != -1) {
                int i = 0;
                for (IProjectFacetVersion fv : this.fpjwc.getAvailableVersions(f)) {
                    if (i == index) {
                        FacetsSelectionPanel.this.setSelectedVersion(f, fv);
                        FacetsSelectionPanel.this.treeViewer.update((Object)f, null);
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    private final class FacetVersionColumnLabelProvider
    extends ColumnLabelProvider {
        private FacetVersionColumnLabelProvider() {
        }

        public String getText(Object element) {
            ProjectFacet f;
            if (element instanceof IProjectFacet && !(f = (ProjectFacet)element).isVersionHidden()) {
                return FacetsSelectionPanel.this.getSelectedVersion((IProjectFacet)f).getVersionString();
            }
            return null;
        }
    }

    private static final class FixedFacetImageDescriptor
    extends CompositeImageDescriptor {
        private static final String OVERLAY_IMG_LOCATION = "images/lock.gif";
        private static final ImageData OVERLAY = FacetUiPlugin.getImageDescriptor("images/lock.gif").getImageData();
        private final ImageData base;
        private final Point size;

        public FixedFacetImageDescriptor(ImageDescriptor base) {
            this.base = base.getImageData();
            this.size = new Point(this.base.width, this.base.height);
        }

        protected void drawCompositeImage(int width, int height) {
            this.drawImage(this.base, 0, 0);
            this.drawImage(OVERLAY, 0, height - FixedFacetImageDescriptor.OVERLAY.height);
        }

        protected Point getSize() {
            return this.size;
        }
    }

    private final class FixedFacetToolTip
    extends BasicToolTip {
        private static final int FAKE_EVENT_TYPE = -9999;

        public FixedFacetToolTip(Control control) {
            super(control);
            this.setPopupDelay(0);
        }

        public void show(Point location) {
            Event fakeEvent = new Event();
            fakeEvent.type = -9999;
            fakeEvent.x = location.x;
            fakeEvent.y = location.y;
            try {
                Method method = ToolTip.class.getDeclaredMethod("toolTipCreate", Event.class);
                method.setAccessible(true);
                method.invoke((Object)this, fakeEvent);
            }
            catch (Exception e) {
                FacetUiPlugin.log(e);
            }
        }

        protected final boolean shouldCreateToolTip(Event event) {
            return event.type == -9999;
        }
    }

    public static interface IFilter {
        public boolean check(IProjectFacetVersion var1);
    }

    private final class ProblemsContentProvider
    implements IStructuredContentProvider {
        private ProblemsContentProvider() {
        }

        public Object[] getElements(Object element) {
            return FacetsSelectionPanel.this.getFilteredProblems();
        }

        public void inputChanged(Viewer viewer, Object oldObject, Object newObject) {
        }

        public void dispose() {
        }
    }

    private final class ProblemsLabelProvider
    implements ITableLabelProvider {
        private ProblemsLabelProvider() {
        }

        public String getColumnText(Object element, int column) {
            return ((IStatus)element).getMessage();
        }

        public Image getColumnImage(Object element, int column) {
            ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
            String imageType = ((IStatus)element).getSeverity() == 4 ? "IMG_OBJS_ERROR_TSK" : "IMG_OBJS_WARN_TSK";
            return sharedImages.getImage(imageType);
        }

        public boolean isLabelProperty(Object obj, String s) {
            return false;
        }

        public void dispose() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private static final class Resources
    extends NLS {
        public static String presetsLabel;
        public static String saveButtonLabel;
        public static String deleteButtonLabel;
        public static String facetColumnLabel;
        public static String versionColumnLabel;
        public static String couldNotDeselectFixedFacetMessage;
        public static String detailsTabLabel;
        public static String runtimesTabLabel;
        public static String lockMenuItem;
        public static String unlockMenuItem;
        public static String changeVersionMenuItem;

        static {
            Resources.initializeMessages((String)FacetsSelectionPanel.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }

    private static final class Sorter
    extends ViewerSorter {
        private Sorter() {
        }

        public int compare(Viewer viewer, Object a, Object b) {
            return Sorter.getLabel(a).compareToIgnoreCase(Sorter.getLabel(b));
        }

        private static String getLabel(Object obj) {
            if (obj instanceof IProjectFacet) {
                return ((IProjectFacet)obj).getLabel();
            }
            return ((ICategory)obj).getLabel();
        }
    }
}

