/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.refactor.listeners;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.refactor.listeners.RefactorMessages;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public class J2EEElementChangedListener
implements IElementChangedListener {
    public static final String PROJECT_COMPONENT_UPDATE_JOB_FAMILY = "org.eclipse.jst.j2ee.refactor.component";

    public void elementChanged(ElementChangedEvent event) {
        this.processJavaElementDelta(event.getDelta());
    }

    private void processJavaElementDelta(IJavaElementDelta delta) {
        int kind = delta.getKind();
        if (kind == 4) {
            int flags = delta.getFlags();
            IJavaElement element = delta.getElement();
            if (element instanceof IJavaModel) {
                if ((flags & 8) == 8) {
                    IJavaElementDelta[] children = delta.getChangedChildren();
                    int i = 0;
                    while (i < children.length) {
                        this.processJavaElementDelta(children[i]);
                        ++i;
                    }
                } else {
                    this.processResourceDeltas(flags, kind, delta);
                }
            } else if (element instanceof IJavaProject) {
                this.processJavaProject((IJavaProject)element, flags, kind, delta);
            }
        }
    }

    private void processJavaProject(final IJavaProject jproject, final int flags, int kind, final IJavaElementDelta delta) {
        final IProject project = jproject.getProject();
        final ArrayList pathsToAdd = new ArrayList();
        final ArrayList pathsToRemove = new ArrayList();
        final ArrayList changedJavaPaths = new ArrayList();
        if (ModuleCoreNature.isFlexibleProject((IProject)project)) {
            WorkspaceJob job = new WorkspaceJob(RefactorMessages.J2EEElementChangedListener_J2EE_Component_Mapping_Update_){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    IVirtualFolder destFolder;
                    IResourceDelta[] deltas;
                    if ((flags & 8) == 8) {
                        boolean cpChanged = (flags & 0x20000) != 0;
                        J2EEElementChangedListener.this.getJavaSrcMappings(delta.getAffectedChildren(), cpChanged, jproject, pathsToAdd, pathsToRemove, changedJavaPaths);
                    }
                    if ((deltas = delta.getResourceDeltas()) != null && deltas.length > 0) {
                        J2EEElementChangedListener.this.getNonJavaFolderMappings(deltas, project, pathsToAdd, pathsToRemove, changedJavaPaths);
                    }
                    int i = 0;
                    while (i < pathsToAdd.size()) {
                        Object[] toAdd = (Object[])pathsToAdd.get(i);
                        destFolder = (IVirtualFolder)toAdd[1];
                        IPath pathToAdd = (IPath)toAdd[0];
                        destFolder.createLink(pathToAdd, 0, monitor);
                        ++i;
                    }
                    i = 0;
                    while (i < pathsToRemove.size()) {
                        Object[] toRemove = (Object[])pathsToRemove.get(i);
                        destFolder = (IVirtualFolder)toRemove[1];
                        IPath pathToRemove = (IPath)toRemove[0];
                        destFolder.removeLink(pathToRemove, 0, monitor);
                        ++i;
                    }
                    return Status.OK_STATUS;
                }

                public boolean belongsTo(Object family) {
                    return J2EEElementChangedListener.PROJECT_COMPONENT_UPDATE_JOB_FAMILY.equals(family);
                }
            };
            job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            job.setSystem(true);
            job.schedule();
        }
    }

    private void processResourceDeltas(int flags, int kind, IJavaElementDelta delta) {
        ArrayList pathsToAdd = new ArrayList();
        ArrayList pathsToRemove = new ArrayList();
        IResourceDelta[] deltas = delta.getResourceDeltas();
        if (deltas != null && deltas.length > 0) {
            try {
                this.getNonJavaFolderMappings(deltas, null, pathsToAdd, pathsToRemove, Collections.EMPTY_LIST);
            }
            catch (CoreException ce) {
                J2EEPlugin.logError(ce);
                return;
            }
        }
        this.updateMappingsInJob(pathsToAdd, pathsToRemove);
    }

    private void getJavaSrcMappings(IJavaElementDelta[] children, boolean cpChanged, IJavaProject jproject, List pathsToAdd, List pathsToRemove, List changedPaths) throws CoreException {
        IVirtualComponent c = ComponentCore.createComponent((IProject)jproject.getProject());
        if (c == null) {
            return;
        }
        IVirtualFolder defaultDestFolder = this.getDestinationFolder(c);
        int i = 0;
        while (i < children.length) {
            IJavaElementDelta delta = children[i];
            IJavaElement element = delta.getElement();
            if (element.getElementType() == 3) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)element;
                int cpeKind = 1;
                boolean abortAdd = false;
                try {
                    cpeKind = root.getKind();
                }
                catch (JavaModelException javaModelException) {
                    abortAdd = true;
                }
                if (cpeKind == 1) {
                    int kind = delta.getKind();
                    if (!cpChanged) {
                        if (kind == 4 || kind == 2) {
                            changedPaths.add(root.getPath().removeFirstSegments(1));
                        }
                    } else {
                        int flags = delta.getFlags();
                        if (kind == 1 || (flags & 0x40) == 64) {
                            if (!abortAdd) {
                                IPath pathToAdd = root.getPath().removeFirstSegments(1);
                                pathsToAdd.add(new Object[]{pathToAdd, defaultDestFolder});
                                if ((flags & 0x10) == 16) {
                                    IJavaElement movedFromElement = delta.getMovedFromElement();
                                    IPath pathToRemove = movedFromElement.getPath().removeFirstSegments(1);
                                    pathsToRemove.add(new Object[]{pathToRemove, defaultDestFolder});
                                }
                            }
                        } else if (kind == 2 || (flags & 0x80) == 128) {
                            IPath path = root.getPath().removeFirstSegments(1);
                            pathsToRemove.add(new Object[]{path, defaultDestFolder});
                        }
                    }
                }
            }
            ++i;
        }
    }

    private void getNonJavaFolderMappings(IResourceDelta[] deltas, IProject project, List pathsToAdd, List pathsToRemove, List changedJavaPaths) throws CoreException {
        IVirtualFolder rootFolder = null;
        IVirtualComponent c = ComponentCore.createComponent((IProject)project);
        if (c == null) {
            return;
        }
        if (project != null) {
            rootFolder = c.getRootFolder();
        }
        Map sourceToRuntime = null;
        if (project != null) {
            sourceToRuntime = this.getResourceMappings(project);
        }
        int i = 0;
        while (i < deltas.length) {
            IResourceDelta delta = deltas[i];
            this.processResourceDelta(delta, rootFolder, sourceToRuntime, pathsToAdd, pathsToRemove, changedJavaPaths);
            ++i;
        }
    }

    private void processResourceDelta(IResourceDelta delta, IVirtualFolder rootFolder, Map sourceToRuntime, List pathsToAdd, List pathsToRemove, List changedJavaPaths) throws CoreException {
        IVirtualFolder localRootFolder = rootFolder;
        Map localSourceToRuntime = sourceToRuntime;
        int kind = delta.getKind();
        if (kind == 4) {
            IResourceDelta[] childDeltas = delta.getAffectedChildren();
            int i = 0;
            while (i < childDeltas.length) {
                this.processResourceDelta(childDeltas[i], localRootFolder, localSourceToRuntime, pathsToAdd, pathsToRemove, changedJavaPaths);
                ++i;
            }
        } else {
            int flags = delta.getFlags();
            if ((flags & 0x1000) == 4096) {
                IPath movedFrom;
                if (localRootFolder == null) {
                    IProject project = delta.getResource().getProject();
                    if (ModuleCoreNature.getModuleCoreNature((IProject)project) != null) {
                        IVirtualComponent c = ComponentCore.createComponent((IProject)project);
                        localRootFolder = c.getRootFolder();
                        localSourceToRuntime = this.getResourceMappings(project);
                    } else {
                        return;
                    }
                }
                if (changedJavaPaths.contains(movedFrom = delta.getMovedFromPath().removeFirstSegments(1))) {
                    return;
                }
                IPath movedTo = delta.getFullPath().removeFirstSegments(1);
                IPath runtimePath = (IPath)localSourceToRuntime.get(movedFrom);
                if (runtimePath != null) {
                    IVirtualFolder folder = localRootFolder.getFolder(runtimePath);
                    if (!movedFrom.equals((Object)movedTo)) {
                        pathsToRemove.add(new Object[]{movedFrom, folder});
                        pathsToAdd.add(new Object[]{movedTo, folder});
                    }
                }
            }
        }
    }

    private Map getResourceMappings(IProject project) {
        HashMap<IPath, IPath> sourceToRuntime = new HashMap<IPath, IPath>();
        StructureEdit core = null;
        try {
            try {
                core = StructureEdit.getStructureEditForRead((IProject)project);
                WorkbenchComponent component = core.getComponent();
                if (component != null) {
                    ArrayList currentResources = new ArrayList(component.getResources());
                    for (ComponentResource resource : currentResources) {
                        sourceToRuntime.put(resource.getSourcePath().makeRelative(), resource.getRuntimePath());
                    }
                }
            }
            catch (NullPointerException e) {
                J2EEPlugin.logError(e);
                if (core != null) {
                    core.dispose();
                }
            }
        }
        finally {
            if (core != null) {
                core.dispose();
            }
        }
        return sourceToRuntime;
    }

    private IVirtualFolder getDestinationFolder(IVirtualComponent c) throws CoreException {
        IVirtualFolder root = c.getRootFolder();
        if (JavaEEProjectUtilities.usesJavaEEComponent(c)) {
            if (JavaEEProjectUtilities.isDynamicWebProject(c.getProject())) {
                return root.getFolder((IPath)new Path("WEB-INF/classes"));
            }
            return root;
        }
        List<IPath> srcFolders = J2EEElementChangedListener.getSourceFolders(c.getProject());
        Map mapping = this.getResourceMappings(c.getProject());
        IPath deployPath = null;
        for (IPath srcFolder : srcFolders) {
            if (!mapping.containsKey(srcFolder)) continue;
            deployPath = (IPath)mapping.get(srcFolder);
            if (deployPath == null) {
                return root;
            }
            return root.getFolder(deployPath);
        }
        return root;
    }

    private void updateMappingsInJob(final List pathsToAdd, final List pathsToRemove) {
        if (!pathsToAdd.isEmpty() || !pathsToRemove.isEmpty()) {
            WorkspaceJob job = new WorkspaceJob(RefactorMessages.J2EEElementChangedListener_J2EE_Component_Mapping_Update_){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    IVirtualFolder destFolder;
                    int i = 0;
                    while (i < pathsToAdd.size()) {
                        Object[] toAdd = (Object[])pathsToAdd.get(i);
                        destFolder = (IVirtualFolder)toAdd[1];
                        IPath pathToAdd = (IPath)toAdd[0];
                        destFolder.createLink(pathToAdd, 0, monitor);
                        ++i;
                    }
                    i = 0;
                    while (i < pathsToRemove.size()) {
                        Object[] toRemove = (Object[])pathsToRemove.get(i);
                        destFolder = (IVirtualFolder)toRemove[1];
                        IPath pathToRemove = (IPath)toRemove[0];
                        destFolder.removeLink(pathToRemove, 0, monitor);
                        ++i;
                    }
                    return Status.OK_STATUS;
                }

                public boolean belongsTo(Object family) {
                    return J2EEElementChangedListener.PROJECT_COMPONENT_UPDATE_JOB_FAMILY.equals(family);
                }
            };
            job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            job.setSystem(true);
            job.schedule();
        }
    }

    protected static List<IPath> getSourceFolders(IProject project) {
        IJavaProject javaProj = JavaCore.create((IProject)project);
        if (javaProj == null) {
            return null;
        }
        if (!javaProj.exists()) {
            return null;
        }
        IClasspathEntry[] cp = null;
        try {
            cp = javaProj.getRawClasspath();
        }
        catch (JavaModelException ex) {
            J2EEPlugin.logError((CoreException)((Object)ex));
            return null;
        }
        ArrayList<IPath> sourcePaths = new ArrayList<IPath>();
        int i = 0;
        while (i < cp.length) {
            if (cp[i].getEntryKind() == 3) {
                sourcePaths.add(cp[i].getPath().removeFirstSegments(1));
            }
            ++i;
        }
        return sourcePaths;
    }
}

