/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.config;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import org.eclipse.persistence.exceptions.PersistenceUnitLoadingException;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryProvider;
import org.eclipse.persistence.internal.jpa.EntityManagerSetupImpl;
import org.eclipse.persistence.internal.jpa.config.persistenceunit.MetadataSource;
import org.eclipse.persistence.internal.jpa.deployment.JPAInitializer;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.jpa.PersistenceProvider;
import org.eclipse.persistence.jpa.config.PersistenceUnit;
import org.eclipse.persistence.sessions.factories.SessionManager;

public class RuntimeFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityManagerFactory createEntityManagerFactory(PersistenceUnit pu) {
        Object manager;
        EntityManagerSetupImpl emSetupImpl = null;
        boolean isNew = false;
        String name = pu.getName();
        pu.setProperty("eclipselink.metadata-source", new MetadataSource(pu));
        SEPersistenceUnitInfo puInfo = (SEPersistenceUnitInfo)pu.getPersistenceUnitInfo();
        JPAInitializer initializer = new PersistenceProvider().getInitializer(name, null);
        HashMap props = new HashMap();
        String uniqueName = initializer.createUniquePersistenceUnitName(puInfo);
        String sessionName = EntityManagerSetupImpl.getOrBuildSessionName(props, puInfo, uniqueName);
        try {
            Map<String, EntityManagerSetupImpl> map = EntityManagerFactoryProvider.emSetupImpls;
            synchronized (map) {
                emSetupImpl = EntityManagerFactoryProvider.getEntityManagerSetupImpl(sessionName);
                if (emSetupImpl != null && puInfo.getClassLoader() != emSetupImpl.getPersistenceUnitInfo().getClassLoader()) {
                    emSetupImpl.undeploy();
                    EntityManagerFactoryProvider.getEmSetupImpls().remove(sessionName);
                    manager = SessionManager.getManager();
                    if (manager.getSessions().containsKey(sessionName)) {
                        manager.destroySession(sessionName);
                    }
                    manager.destroy();
                    emSetupImpl = null;
                }
                if (emSetupImpl == null) {
                    emSetupImpl = initializer.extractInitialEmSetupImpl(name);
                    if (emSetupImpl == null) {
                        emSetupImpl = initializer.callPredeploy(puInfo, props, uniqueName, sessionName);
                    } else {
                        emSetupImpl.changeSessionName(sessionName);
                    }
                    emSetupImpl.predeploy(emSetupImpl.getPersistenceUnitInfo(), props);
                    EntityManagerFactoryProvider.addEntityManagerSetupImpl(sessionName, emSetupImpl);
                    isNew = true;
                }
            }
        }
        catch (Exception e) {
            throw PersistenceUnitLoadingException.exceptionSearchingForPersistenceResources((ClassLoader)initializer.getInitializationClassLoader(), (Exception)e);
        }
        if (!isNew) {
            if (!uniqueName.equals(emSetupImpl.getPersistenceUnitUniqueName())) {
                throw PersistenceUnitLoadingException.sessionNameAlreadyInUse((String)sessionName, (String)uniqueName, (String)emSetupImpl.getPersistenceUnitUniqueName());
            }
            boolean undeployed = false;
            manager = emSetupImpl;
            synchronized (manager) {
                if (emSetupImpl.isUndeployed()) {
                    undeployed = true;
                }
                emSetupImpl.predeploy(emSetupImpl.getPersistenceUnitInfo(), props);
            }
            if (undeployed) {
                return this.createEntityManagerFactory(pu);
            }
        }
        EntityManagerFactoryImpl factory = null;
        try {
            factory = new EntityManagerFactoryImpl(emSetupImpl, props);
            if (emSetupImpl.shouldGetSessionOnCreateFactory(props)) {
                factory.getDatabaseSession();
            }
        }
        catch (RuntimeException ex) {
            if (factory != null) {
                factory.close();
            } else {
                emSetupImpl.undeploy();
            }
            throw ex;
        }
        return factory;
    }

    public static RuntimeFactory getInstance() {
        return new RuntimeFactory();
    }
}

