/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.remote.rmi;

import java.rmi.RemoteException;
import java.rmi.server.ObjID;
import java.util.Enumeration;
import java.util.IdentityHashMap;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.CommunicationException;
import org.eclipse.persistence.internal.sessions.remote.RemoteCommand;
import org.eclipse.persistence.internal.sessions.remote.RemoteConnection;
import org.eclipse.persistence.internal.sessions.remote.RemoteCursoredStream;
import org.eclipse.persistence.internal.sessions.remote.RemoteScrollableCursor;
import org.eclipse.persistence.internal.sessions.remote.RemoteUnitOfWork;
import org.eclipse.persistence.internal.sessions.remote.RemoteValueHolder;
import org.eclipse.persistence.internal.sessions.remote.Transporter;
import org.eclipse.persistence.queries.CursoredStreamPolicy;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.ScrollableCursorPolicy;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.remote.DistributedSession;
import org.eclipse.persistence.sessions.remote.RemoteSession;
import org.eclipse.persistence.sessions.remote.rmi.RMIRemoteSessionController;

public class RMIConnection
extends RemoteConnection {
    RMIRemoteSessionController remoteSessionController;

    public RMIConnection(RMIRemoteSessionController controller) {
        this.remoteSessionController = controller;
    }

    @Override
    public void processCommand(RemoteCommand command) {
        try {
            Transporter transporter = new Transporter();
            transporter.setObject(command);
            transporter = this.getRemoteSessionController().processCommand(transporter);
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation(exception);
        }
    }

    @Override
    public void beginTransaction() {
        try {
            Transporter transporter = this.getRemoteSessionController().beginTransaction();
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation(exception);
        }
    }

    @Override
    public void beginEarlyTransaction() {
        try {
            Transporter transporter = this.getRemoteSessionController().beginEarlyTransaction();
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation(exception);
        }
    }

    @Override
    public RemoteUnitOfWork commitRootUnitOfWork(RemoteUnitOfWork theRemoteUnitOfWork) {
        try {
            Transporter transporter = new Transporter();
            transporter.setObject(theRemoteUnitOfWork);
            transporter.prepare(this.session);
            transporter = this.getRemoteSessionController().commitRootUnitOfWork(transporter);
            transporter.expand(this.session);
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
            return (RemoteUnitOfWork)transporter.getObject();
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation(exception);
        }
    }

    @Override
    public void commitTransaction() {
        try {
            Transporter transporter = this.getRemoteSessionController().commitTransaction();
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation(exception);
        }
    }

    @Override
    public Session createRemoteSession() {
        return new RemoteSession(this);
    }

    @Override
    public void cursoredStreamClose(ObjID remoteCursoredStreamOid) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().cursoredStreamClose(new Transporter(remoteCursoredStreamOid));
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation(exception);
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
    }

    @Override
    public Vector cursoredStreamNextPage(RemoteCursoredStream remoteCursoredStream, ReadQuery query, DistributedSession session, int pageSize) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().cursoredStreamNextPage(new Transporter(remoteCursoredStream.getID()), pageSize);
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation(exception);
        }
        if (transporter == null) {
            return null;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        Vector<Object> serverNextPageObjects = (Vector<Object>)transporter.getObject();
        if (serverNextPageObjects == null) {
            this.cursoredStreamClose(remoteCursoredStream.getID());
            return null;
        }
        Vector<Object> clientNextPageObjects = serverNextPageObjects;
        if (query.isReadAllQuery() && !query.isReportQuery()) {
            clientNextPageObjects = new Vector<Object>(serverNextPageObjects.size());
            Enumeration objEnum = serverNextPageObjects.elements();
            while (objEnum.hasMoreElements()) {
                Object clientObject = session.getObjectCorrespondingTo(objEnum.nextElement(), transporter.getObjectDescriptors(), new IdentityHashMap(), (ObjectLevelReadQuery)query);
                clientNextPageObjects.addElement(clientObject);
            }
        }
        return clientNextPageObjects;
    }

    @Override
    public int cursoredStreamSize(ObjID remoteCursoredStreamID) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().cursoredStreamSize(new Transporter(remoteCursoredStreamID));
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation(exception);
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Integer)transporter.getObject();
    }

    @Override
    public RemoteCursoredStream cursorSelectObjects(CursoredStreamPolicy policy, DistributedSession session) {
        try {
            Transporter transporter = this.getRemoteSessionController().cursorSelectObjects(new Transporter(policy));
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
            RemoteCursoredStream remoteCursoredStream = (RemoteCursoredStream)transporter.getObject();
            remoteCursoredStream.setSession(session);
            remoteCursoredStream.setPolicy(policy);
            if (policy.getQuery().isReadAllQuery() && !policy.getQuery().isReportQuery()) {
                this.fixObjectReferences(transporter, (ObjectLevelReadQuery)policy.getQuery(), session);
            }
            return remoteCursoredStream;
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation(exception);
        }
    }

    @Override
    public RemoteScrollableCursor cursorSelectObjects(ScrollableCursorPolicy policy, DistributedSession session) {
        try {
            Transporter transporter = this.getRemoteSessionController().cursorSelectObjects(new Transporter(policy));
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
            RemoteScrollableCursor remoteScrollableCursor = (RemoteScrollableCursor)transporter.getObject();
            remoteScrollableCursor.setSession(session);
            remoteScrollableCursor.setPolicy(policy);
            return remoteScrollableCursor;
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation(exception);
        }
    }

    @Override
    public Vector getDefaultReadOnlyClasses() {
        try {
            Transporter transporter = this.getRemoteSessionController().getDefaultReadOnlyClasses();
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
            return (Vector)transporter.getObject();
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation(exception);
        }
    }

    @Override
    public ClassDescriptor getDescriptor(Class domainClass) {
        try {
            Transporter transporter = this.getRemoteSessionController().getDescriptor(new Transporter(domainClass));
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
            return (ClassDescriptor)transporter.getObject();
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation(exception);
        }
    }

    @Override
    public ClassDescriptor getDescriptorForAlias(String alias) {
        try {
            Transporter transporter = this.getRemoteSessionController().getDescriptorForAlias(new Transporter(alias));
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
            return (ClassDescriptor)transporter.getObject();
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation(exception);
        }
    }

    @Override
    public Login getLogin() {
        try {
            Transporter transporter = this.getRemoteSessionController().getLogin();
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
            return (Login)transporter.getObject();
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation(exception);
        }
    }

    public RMIRemoteSessionController getRemoteSessionController() {
        return this.remoteSessionController;
    }

    @Override
    public Object getSequenceNumberNamed(Object remoteFunctionCall) {
        try {
            Transporter transporter = this.getRemoteSessionController().getSequenceNumberNamed(new Transporter(remoteFunctionCall));
            Object returnValue = transporter.getObject();
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
            return returnValue;
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation(exception);
        }
    }

    @Override
    public void initializeIdentityMapsOnServerSession() {
        try {
            Transporter transporter = this.getRemoteSessionController().initializeIdentityMapsOnServerSession();
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation(exception);
        }
    }

    @Override
    public Transporter instantiateRemoteValueHolderOnServer(RemoteValueHolder remoteValueHolder) {
        try {
            Transporter transporter = new Transporter();
            transporter.setObject(remoteValueHolder);
            transporter.prepare(this.session);
            transporter = this.getRemoteSessionController().instantiateRemoteValueHolderOnServer(transporter);
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
            transporter.expand(this.session);
            return transporter;
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation(exception);
        }
    }

    @Override
    public Transporter remoteExecute(DatabaseQuery query) {
        try {
            Transporter transporter = new Transporter();
            transporter.setObject(query);
            transporter.prepare(this.session);
            transporter = this.getRemoteSessionController().executeQuery(transporter);
            transporter.expand(this.session);
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
            return transporter;
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation(exception);
        }
    }

    @Override
    public Transporter remoteExecuteNamedQuery(String name, Class javaClass, Vector arguments) {
        try {
            Transporter transporter = this.getRemoteSessionController().executeNamedQuery(new Transporter(name), new Transporter(javaClass), new Transporter(arguments));
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
            return transporter;
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation(exception);
        }
    }

    @Override
    public void rollbackTransaction() {
        try {
            Transporter transporter = this.getRemoteSessionController().rollbackTransaction();
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation(exception);
        }
    }

    @Override
    public boolean scrollableCursorAbsolute(ObjID remoteScrollableCursorOid, int rows) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().scrollableCursorAbsolute(new Transporter(remoteScrollableCursorOid), rows);
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation(exception);
        }
        if (transporter == null) {
            return false;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Boolean)transporter.getObject();
    }

    @Override
    public void scrollableCursorAfterLast(ObjID remoteScrollableCursorOid) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().scrollableCursorAfterLast(new Transporter(remoteScrollableCursorOid));
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation(exception);
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
    }

    @Override
    public void scrollableCursorBeforeFirst(ObjID remoteScrollableCursorOid) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().scrollableCursorBeforeFirst(new Transporter(remoteScrollableCursorOid));
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation(exception);
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
    }

    @Override
    public void scrollableCursorClose(ObjID remoteScrollableCursorOid) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().scrollableCursorClose(new Transporter(remoteScrollableCursorOid));
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation(exception);
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
    }

    @Override
    public int scrollableCursorCurrentIndex(ObjID remoteScrollableCursorOid) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().scrollableCursorAfterLast(new Transporter(remoteScrollableCursorOid));
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation(exception);
        }
        if (transporter == null) {
            return -1;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Integer)transporter.getObject();
    }

    @Override
    public boolean scrollableCursorFirst(ObjID remoteScrollableCursorOid) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().scrollableCursorFirst(new Transporter(remoteScrollableCursorOid));
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation(exception);
        }
        if (transporter == null) {
            return false;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Boolean)transporter.getObject();
    }

    @Override
    public boolean scrollableCursorIsAfterLast(ObjID remoteScrollableCursorOid) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().scrollableCursorIsAfterLast(new Transporter(remoteScrollableCursorOid));
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation(exception);
        }
        if (transporter == null) {
            return false;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Boolean)transporter.getObject();
    }

    @Override
    public boolean scrollableCursorIsBeforeFirst(ObjID remoteScrollableCursorOid) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().scrollableCursorIsBeforeFirst(new Transporter(remoteScrollableCursorOid));
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation(exception);
        }
        if (transporter == null) {
            return false;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Boolean)transporter.getObject();
    }

    @Override
    public boolean scrollableCursorIsFirst(ObjID remoteScrollableCursorOid) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().scrollableCursorIsFirst(new Transporter(remoteScrollableCursorOid));
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation(exception);
        }
        if (transporter == null) {
            return false;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Boolean)transporter.getObject();
    }

    @Override
    public boolean scrollableCursorIsLast(ObjID remoteScrollableCursorOid) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().scrollableCursorIsLast(new Transporter(remoteScrollableCursorOid));
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation(exception);
        }
        if (transporter == null) {
            return false;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Boolean)transporter.getObject();
    }

    @Override
    public boolean scrollableCursorLast(ObjID remoteScrollableCursorOid) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().scrollableCursorLast(new Transporter(remoteScrollableCursorOid));
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation(exception);
        }
        if (transporter == null) {
            return false;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Boolean)transporter.getObject();
    }

    @Override
    public Object scrollableCursorNextObject(ObjID remoteScrollableCursorOid, ReadQuery query, DistributedSession session) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().scrollableCursorNextObject(new Transporter(remoteScrollableCursorOid));
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation(exception);
        }
        if (transporter == null) {
            return null;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        Object object = transporter.getObject();
        if (object == null) {
            return null;
        }
        if (query.isReadAllQuery() && !query.isReportQuery()) {
            object = session.getObjectCorrespondingTo(object, transporter.getObjectDescriptors(), new IdentityHashMap(), (ObjectLevelReadQuery)query);
        }
        return object;
    }

    @Override
    public Object scrollableCursorPreviousObject(ObjID remoteScrollableCursorOid, ReadQuery query, DistributedSession session) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().scrollableCursorPreviousObject(new Transporter(remoteScrollableCursorOid));
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation(exception);
        }
        if (transporter == null) {
            return null;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        Object object = transporter.getObject();
        if (object == null) {
            return null;
        }
        if (query.isReadAllQuery() && !query.isReportQuery()) {
            object = session.getObjectCorrespondingTo(object, transporter.getObjectDescriptors(), new IdentityHashMap(), (ObjectLevelReadQuery)query);
        }
        return object;
    }

    @Override
    public boolean scrollableCursorRelative(ObjID remoteScrollableCursorOid, int rows) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().scrollableCursorRelative(new Transporter(remoteScrollableCursorOid), rows);
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation(exception);
        }
        if (transporter == null) {
            return false;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Boolean)transporter.getObject();
    }

    @Override
    public int scrollableCursorSize(ObjID cursorId) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().scrollableCursorSize(new Transporter(cursorId));
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation(exception);
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Integer)transporter.getObject();
    }

    public void setRemoteSessionController(RMIRemoteSessionController remoteSessionController) {
        this.remoteSessionController = remoteSessionController;
    }
}

