/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.part.Page;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.OpenCallHierarchyAction;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.ui.actions.OpenExternalJavadocAction;
import org.eclipse.wst.jsdt.ui.actions.OpenSuperImplementationAction;
import org.eclipse.wst.jsdt.ui.actions.OpenTypeHierarchyAction;

public class OpenViewActionGroup
extends ActionGroup {
    private boolean fEditorIsOwner;
    private boolean fIsTypeHiararchyViewerOwner;
    private boolean fIsCallHiararchyViewerOwner;
    private ISelectionProvider fSelectionProvider;
    private OpenSuperImplementationAction fOpenSuperImplementation;
    private OpenExternalJavadocAction fOpenExternalJavadoc;
    private OpenTypeHierarchyAction fOpenTypeHierarchy;
    private OpenCallHierarchyAction fOpenCallHierarchy;
    private PropertyDialogAction fOpenPropertiesDialog;
    private boolean fShowOpenPropertiesAction = true;
    private boolean fShowShowInMenu = false;

    public OpenViewActionGroup(Page page) {
        this.createSiteActions((IWorkbenchSite)page.getSite(), null);
    }

    public OpenViewActionGroup(Page page, ISelectionProvider selectionProvider) {
        this.createSiteActions((IWorkbenchSite)page.getSite(), selectionProvider);
    }

    public OpenViewActionGroup(IViewPart part) {
        this(part, null);
    }

    public OpenViewActionGroup(IViewPart part, ISelectionProvider selectionProvider) {
        this.createSiteActions((IWorkbenchSite)part.getSite(), selectionProvider);
        String partName = part.getClass().getName();
        this.fIsTypeHiararchyViewerOwner = "org.eclipse.wst.jsdt.internal.ui.typehierarchy.TypeHierarchyViewPart".equals(partName);
        this.fIsCallHiararchyViewerOwner = "org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyViewPart".equals(partName);
    }

    public OpenViewActionGroup(IWorkbenchSite site, ISelectionProvider selectionProvider) {
        this.createSiteActions(site, selectionProvider);
    }

    public OpenViewActionGroup(JavaEditor part) {
        this.fEditorIsOwner = true;
        this.fShowShowInMenu = false;
        this.fOpenSuperImplementation = new OpenSuperImplementationAction(part);
        this.fOpenSuperImplementation.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.open.super.implementation");
        part.setAction("OpenSuperImplementation", (IAction)this.fOpenSuperImplementation);
        this.fOpenExternalJavadoc = new OpenExternalJavadocAction(part);
        this.fOpenExternalJavadoc.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.open.external.javadoc");
        part.setAction("OpenExternalJavadoc", (IAction)this.fOpenExternalJavadoc);
        this.fOpenTypeHierarchy = new OpenTypeHierarchyAction(part);
        this.fOpenTypeHierarchy.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.open.type.hierarchy");
        part.setAction("OpenTypeHierarchy", (IAction)this.fOpenTypeHierarchy);
        this.fOpenCallHierarchy = new OpenCallHierarchyAction(part);
        this.fOpenCallHierarchy.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.open.call.hierarchy");
        part.setAction("OpenCallHierarchy", (IAction)this.fOpenCallHierarchy);
        this.initialize(part.getEditorSite().getSelectionProvider());
    }

    public void containsOpenPropertiesAction(boolean enable) {
        this.fShowOpenPropertiesAction = enable;
    }

    public void containsShowInMenu(boolean enable) {
        this.fShowShowInMenu = enable;
    }

    private void createSiteActions(IWorkbenchSite site, ISelectionProvider specialProvider) {
        this.fOpenSuperImplementation = new OpenSuperImplementationAction(site);
        this.fOpenSuperImplementation.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.open.super.implementation");
        this.fOpenSuperImplementation.setSpecialSelectionProvider(specialProvider);
        this.fOpenExternalJavadoc = new OpenExternalJavadocAction(site);
        this.fOpenExternalJavadoc.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.open.external.javadoc");
        this.fOpenExternalJavadoc.setSpecialSelectionProvider(specialProvider);
        this.fOpenTypeHierarchy = new OpenTypeHierarchyAction(site);
        this.fOpenTypeHierarchy.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.open.type.hierarchy");
        this.fOpenTypeHierarchy.setSpecialSelectionProvider(specialProvider);
        this.fOpenCallHierarchy = new OpenCallHierarchyAction(site);
        this.fOpenCallHierarchy.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.open.call.hierarchy");
        this.fOpenCallHierarchy.setSpecialSelectionProvider(specialProvider);
        ISelectionProvider provider = specialProvider != null ? specialProvider : site.getSelectionProvider();
        this.fOpenPropertiesDialog = new PropertyDialogAction((IShellProvider)site, provider);
        this.fOpenPropertiesDialog.setActionDefinitionId("org.eclipse.ui.file.properties");
        this.initialize(provider);
    }

    private void initialize(ISelectionProvider provider) {
        this.fSelectionProvider = provider;
        ISelection selection = provider.getSelection();
        this.fOpenSuperImplementation.update(selection);
        this.fOpenExternalJavadoc.update(selection);
        this.fOpenTypeHierarchy.update(selection);
        this.fOpenCallHierarchy.update(selection);
        if (!this.fEditorIsOwner) {
            if (this.fShowOpenPropertiesAction) {
                if (selection instanceof IStructuredSelection) {
                    this.fOpenPropertiesDialog.selectionChanged((IStructuredSelection)selection);
                } else {
                    this.fOpenPropertiesDialog.selectionChanged(selection);
                }
            }
            provider.addSelectionChangedListener((ISelectionChangedListener)this.fOpenSuperImplementation);
            provider.addSelectionChangedListener((ISelectionChangedListener)this.fOpenExternalJavadoc);
            provider.addSelectionChangedListener((ISelectionChangedListener)this.fOpenTypeHierarchy);
            provider.addSelectionChangedListener((ISelectionChangedListener)this.fOpenCallHierarchy);
        }
    }

    public void fillActionBars(IActionBars actionBar) {
        super.fillActionBars(actionBar);
        this.setGlobalActionHandlers(actionBar);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        if (!this.fIsTypeHiararchyViewerOwner) {
            this.appendToGroup(menu, (IAction)this.fOpenTypeHierarchy);
        }
        if (!this.fIsCallHiararchyViewerOwner) {
            this.appendToGroup(menu, (IAction)this.fOpenCallHierarchy);
        }
        if (this.fShowShowInMenu) {
            MenuManager showInSubMenu = new MenuManager(this.getShowInMenuLabel());
            IWorkbenchWindow workbenchWindow = this.fOpenSuperImplementation.getSite().getWorkbenchWindow();
            showInSubMenu.add(ContributionItemFactory.VIEWS_SHOW_IN.create(workbenchWindow));
            menu.appendToGroup("group.open", (IContributionItem)showInSubMenu);
        }
        IStructuredSelection selection = this.getStructuredSelection();
        if (this.fShowOpenPropertiesAction && selection != null) {
            menu.appendToGroup("group.properties", (IAction)this.fOpenPropertiesDialog);
        }
    }

    private String getShowInMenuLabel() {
        String keyBinding = null;
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        if (bindingService != null) {
            keyBinding = bindingService.getBestActiveBindingFormattedFor("org.eclipse.ui.navigate.showInQuickMenu");
        }
        if (keyBinding == null) {
            keyBinding = "";
        }
        return String.valueOf(ActionMessages.OpenViewActionGroup_showInAction_label) + '\t' + keyBinding;
    }

    public void dispose() {
        this.fSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.fOpenSuperImplementation);
        this.fSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.fOpenExternalJavadoc);
        this.fSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.fOpenTypeHierarchy);
        this.fSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.fOpenCallHierarchy);
        super.dispose();
    }

    private void setGlobalActionHandlers(IActionBars actionBars) {
        actionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.OpenSuperImplementation", (IAction)this.fOpenSuperImplementation);
        actionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.OpenExternalJavaDoc", (IAction)this.fOpenExternalJavadoc);
        actionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.OpenTypeHierarchy", (IAction)this.fOpenTypeHierarchy);
        actionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.OpenCallHierarchy", (IAction)this.fOpenCallHierarchy);
        if (!this.fEditorIsOwner && this.fShowOpenPropertiesAction) {
            actionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.fOpenPropertiesDialog);
        }
    }

    private void appendToGroup(IMenuManager menu, IAction action) {
        if (action.isEnabled()) {
            menu.appendToGroup("group.open", action);
        }
    }

    private IStructuredSelection getStructuredSelection() {
        ISelection selection = this.getContext().getSelection();
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return null;
    }
}

