/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.viewsupport;

import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DecorationContext;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelDecorator;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.internal.ui.packageview.HierarchicalDecorationContext;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ColoredJavaElementLabels;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ColoredString;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.IRichLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaUILabelProvider;
import org.eclipse.wst.jsdt.ui.ProblemsLabelDecorator;

public class DecoratingJavaLabelProvider
extends DecoratingLabelProvider
implements IRichLabelProvider {
    public DecoratingJavaLabelProvider(JavaUILabelProvider labelProvider) {
        this(labelProvider, true);
    }

    public DecoratingJavaLabelProvider(JavaUILabelProvider labelProvider, boolean errorTick) {
        this(labelProvider, errorTick, true);
    }

    public DecoratingJavaLabelProvider(JavaUILabelProvider labelProvider, boolean errorTick, boolean flatPackageMode) {
        super((ILabelProvider)labelProvider, PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
        if (errorTick) {
            labelProvider.addLabelDecorator(new ProblemsLabelDecorator(null));
        }
        this.setFlatPackageMode(flatPackageMode);
    }

    public void setFlatPackageMode(boolean enable) {
        if (enable) {
            this.setDecorationContext(DecorationContext.DEFAULT_CONTEXT);
        } else {
            this.setDecorationContext(HierarchicalDecorationContext.CONTEXT);
        }
    }

    @Override
    public ColoredString getRichTextLabel(Object element) {
        IRichLabelProvider richLabelProvider;
        ColoredString richLabel;
        ILabelProvider labelProvider = this.getLabelProvider();
        if (labelProvider instanceof IRichLabelProvider && (richLabel = (richLabelProvider = (IRichLabelProvider)labelProvider).getRichTextLabel(element)) != null) {
            String decorated = null;
            ILabelDecorator labelDecorator = this.getLabelDecorator();
            if (labelDecorator != null) {
                decorated = labelDecorator instanceof LabelDecorator ? ((LabelDecorator)labelDecorator).decorateText(richLabel.getString(), element, this.getDecorationContext()) : labelDecorator.decorateText(richLabel.getString(), element);
            }
            if (decorated != null) {
                return ColoredJavaElementLabels.decorateColoredString(richLabel, decorated, ColoredJavaElementLabels.DECORATIONS_STYLE);
            }
            return richLabel;
        }
        return null;
    }
}

